/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.widget.list;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.gui.screen.MainScreen;
import net.atif.buildnotes.gui.widget.list.AbstractListWidget;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class NoteListWidget
extends AbstractListWidget<NoteEntry> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public NoteListWidget(MainScreen parent, class_310 client, int width, int height, int top, int bottom, int itemHeight) {
        super(parent, client, top, bottom, itemHeight);
    }

    public void setNotes(List<Note> notes) {
        this.method_25339();
        notes.forEach(note -> this.method_25321(new NoteEntry((Note)note)));
    }

    public Note getSelectedNote() {
        NoteEntry entry = (NoteEntry)this.method_25334();
        return entry != null ? entry.getNote() : null;
    }

    public NoteEntry getPublicEntry(int index) {
        return (NoteEntry)this.method_25326(index);
    }

    public void setSelected(NoteEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.parentScreen.onNoteSelected();
    }

    public class NoteEntry
    extends class_350.class_351<NoteEntry> {
        private final Note note;
        private final String firstLine;
        private final String formattedDateTime;

        public NoteEntry(Note note) {
            this.note = note;
            this.firstLine = note.getContent().split("\n")[0];
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(note.getLastModified()), ZoneId.systemDefault());
            this.formattedDateTime = dateTime.format(DATE_TIME_FORMATTER);
        }

        public Note getNote() {
            return this.note;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_1729(matrices, this.note.getTitle(), (float)(x + 2), (float)(y + 2), 0xFFFFFF);
            class_5250 contentPreview = new class_2585(this.firstLine).method_27692(class_124.field_1080);
            String truncated = ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_27523(contentPreview.getString(), entryWidth - 4);
            ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_30883(matrices, (class_2561)new class_2585(truncated), (float)(x + 2), (float)(y + 12), 0xCCCCCC);
            ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_1729(matrices, "Last Modified: " + this.formattedDateTime, (float)(x + 2), (float)(y + 22), 0xCCCCCC);
            if (this.note.isGlobal()) {
                class_5250 globalText = new class_2585("Global").method_27692(class_124.field_1075);
                int globalWidth = ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_27525((class_5348)globalText);
                ((NoteListWidget)NoteListWidget.this).field_22740.field_1772.method_30883(matrices, (class_2561)globalText, (float)(x + entryWidth - globalWidth - 7), (float)(y + 2), 0xFFFFFF);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                NoteListWidget.this.setSelected(this);
                NoteListWidget.this.handleEntryClick(this);
                return true;
            }
            return false;
        }
    }
}

