/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes;

import io.netty.buffer.Unpooled;
import net.atif.buildnotes.data.PermissionLevel;
import net.atif.buildnotes.network.PacketIdentifiers;
import net.atif.buildnotes.network.ServerPacketHandler;
import net.atif.buildnotes.server.PermissionManager;
import net.atif.buildnotes.server.ServerDataManager;
import net.atif.buildnotes.server.ServerImageTransferManager;
import net.atif.buildnotes.server.command.BuildNotesCommands;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buildnotes
implements ModInitializer {
    public static final String MOD_ID = "buildnotes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"buildnotes");
    public static ServerDataManager SERVER_DATA_MANAGER;
    public static PermissionManager PERMISSION_MANAGER;

    public void onInitialize() {
        LOGGER.info("BuildNotes Initialized!");
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SERVER_DATA_MANAGER = new ServerDataManager(server);
            PERMISSION_MANAGER = new PermissionManager(server);
        });
        BuildNotesCommands.register();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (!server.method_3816()) {
                return;
            }
            PermissionLevel permission = PERMISSION_MANAGER.isAllowedToEdit(player) ? PermissionLevel.CAN_EDIT : PermissionLevel.VIEW_ONLY;
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10817((Enum)permission);
            ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.HANDSHAKE_S2C, (class_2540)buf);
            LOGGER.info("Sent handshake packet to " + player.method_5477().getString());
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerImageTransferManager.onPlayerDisconnect(handler.field_14140.method_5667()));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.REQUEST_DATA_C2S, ServerPacketHandler::handleRequestInitialData);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.SAVE_NOTE_C2S, ServerPacketHandler::handleSaveNote);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.SAVE_BUILD_C2S, ServerPacketHandler::handleSaveBuild);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.DELETE_NOTE_C2S, ServerPacketHandler::handleDeleteNote);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.DELETE_BUILD_C2S, ServerPacketHandler::handleDeleteBuild);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.UPLOAD_IMAGE_CHUNK_C2S, ServerPacketHandler::handleImageChunkUpload);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.REQUEST_IMAGE_C2S, ServerPacketHandler::handleImageRequest);
    }
}

