package net.atif.buildnotes.gui.screen;

import net.atif.buildnotes.client.ClientSession;
import net.atif.buildnotes.data.DataManager;
import net.atif.buildnotes.data.Note;
import net.atif.buildnotes.data.Scope;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.helper.NoteScreenLayouts;
import net.atif.buildnotes.gui.helper.UIHelper;
import net.atif.buildnotes.gui.widget.DarkButtonWidget;
import net.atif.buildnotes.gui.widget.MultiLineTextFieldWidget;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import java.util.List;

public class EditNoteScreen extends BaseScreen {

    private final Note note;

    private MultiLineTextFieldWidget titleField;
    private MultiLineTextFieldWidget contentField;
    private MultiLineTextFieldWidget lastFocusedTextField;

    public EditNoteScreen(class_437 parent, Note note) {
        super(class_2561.method_43471("gui.buildnotes.edit_note_title"), parent);
        this.note = note;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int contentWidth = (int) (this.field_22789 * NoteScreenLayouts.CONTENT_WIDTH_RATIO);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginDoubleRow();

        // --- Title Text Field ---
        this.titleField = new MultiLineTextFieldWidget(
                this.field_22793,
                contentX,
                NoteScreenLayouts.TOP_MARGIN + 5,
                contentWidth,
                NoteScreenLayouts.TITLE_PANEL_HEIGHT,
                note.getTitle(),
                class_2561.method_43471("gui.buildnotes.placeholder.title").getString(),
                1, false
        );
        this.method_25429(this.titleField);

        // --- Content Text Field ---
        int contentPanelY = NoteScreenLayouts.TOP_MARGIN + NoteScreenLayouts.TITLE_PANEL_HEIGHT + NoteScreenLayouts.PANEL_SPACING;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        this.contentField = new MultiLineTextFieldWidget(
                this.field_22793, contentX, contentPanelY, contentWidth,
                contentPanelBottom - contentPanelY, note.getContent(),
                class_2561.method_43471("gui.buildnotes.placeholder.note_content").getString(), Integer.MAX_VALUE, true
        );
        this.method_25429(this.contentField);

        // --- TOP BUTTON ROW (3) ---
        int topRowY = UIHelper.getBottomButtonY(this, 1);
        List<class_2561> topButtonTexts = List.of(
                class_2561.method_43471("gui.buildnotes.edit.coords"),
                class_2561.method_43471("gui.buildnotes.edit.biome"),
                getScopeButtonText()
        );

        UIHelper.createButtonRow(this, topRowY, topButtonTexts, (index, x, width) -> { // Note the new 'width' parameter
            switch (index) {
                case 0 -> this.method_37063(new DarkButtonWidget(x, topRowY, width, UIHelper.BUTTON_HEIGHT, topButtonTexts.get(0), b -> insertCoords()));
                case 1 -> this.method_37063(new DarkButtonWidget(x, topRowY, width, UIHelper.BUTTON_HEIGHT, topButtonTexts.get(1), b -> insertBiome()));
                case 2 ->
                        this.method_37063(new DarkButtonWidget(x, topRowY, width, UIHelper.BUTTON_HEIGHT, topButtonTexts.get(2), b -> {
                            saveNote();
                            cycleScope();
                            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                        }));
            }
        });

        // --- BOTTOM BUTTON ROW ---
        int bottomRowY = UIHelper.getBottomButtonY(this, 2);
        List<class_2561> bottomButtonTexts = List.of(
                class_2561.method_43471("gui.buildnotes.save_button"),
                class_2561.method_43471("gui.buildnotes.close_button")
        );
        UIHelper.createButtonRow(this, bottomRowY, bottomButtonTexts, (index, x, width) -> {
            if (index == 0) {
                this.method_37063(new DarkButtonWidget(x, bottomRowY, width, UIHelper.BUTTON_HEIGHT,
                    bottomButtonTexts.get(0), button -> {
                        saveNote();
                        open(new ViewNoteScreen(this.parent, this.note));
                    })
                );
            } else {
                this.method_37063(new DarkButtonWidget(x, bottomRowY, width, UIHelper.BUTTON_HEIGHT, bottomButtonTexts.get(1), button -> this.method_25419()));
            }
        });

        this.method_48265(this.titleField);
    }

    private void cycleScope() {
        Scope currentScope = note.getScope();
        if (ClientSession.isOnServer() && ClientSession.hasEditPermission()) {
            // Cycle through all three: WORLD -> GLOBAL -> SERVER -> WORLD
            if (currentScope == Scope.WORLD) note.setScope(Scope.GLOBAL);
            else if (currentScope == Scope.GLOBAL) note.setScope(Scope.SERVER);
            else note.setScope(Scope.WORLD);
        } else {
            // Cycle between WORLD and GLOBAL
            note.setScope(currentScope == Scope.WORLD ? Scope.GLOBAL : Scope.WORLD);
        }
    }

    private class_2561 getScopeButtonText() {
        class_2561 scopeName;
        Scope currentScope = note.getScope();
        if (currentScope == Scope.GLOBAL) {
            scopeName = class_2561.method_43471("gui.buildnotes.edit.scope.global");
        } else if (currentScope == Scope.SERVER) {
            scopeName = class_2561.method_43471("gui.buildnotes.edit.scope.server");
        } else {
            scopeName = this.field_22787 != null && this.field_22787.method_1496()
                    ? class_2561.method_43471("gui.buildnotes.edit.scope.world")
                    : class_2561.method_43471("gui.buildnotes.edit.scope.per_server");
        }
        return class_2561.method_43469("gui.buildnotes.edit.scope_button", scopeName);
    }

    private void saveNote() {
        note.setTitle(this.titleField.getText());
        note.setContent(this.contentField.getText());
        note.updateTimestamp();
        DataManager.getInstance().saveNote(this.note);
    }

    private void insertTextAtLastFocus(String text) {
        if (this.lastFocusedTextField != null) {
            this.lastFocusedTextField.insertText(text);
            this.method_25395(this.lastFocusedTextField);
        } else if (this.contentField != null) { // Fallback to the content field
            this.contentField.insertText(text);
            this.method_25395(this.contentField);
        }
    }

    private void insertCoords() {
        if (this.field_22787.field_1724 == null) return;
        String coords = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321());
        insertTextAtLastFocus(coords);
    }

    private void insertBiome() {
        if (this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) return;
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        class_6880<class_1959> biomeEntry = this.field_22787.field_1687.method_23753(playerPos);
        String biomeId = biomeEntry.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("minecraft:unknown");
        insertTextAtLastFocus(biomeId);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);

        int contentWidth = (int) (this.field_22789 * NoteScreenLayouts.CONTENT_WIDTH_RATIO);
        int contentX = (this.field_22789 - contentWidth) / 2;
        int bottomMargin = NoteScreenLayouts.getBottomMarginDoubleRow();

        // --- Title Panel ---
        UIHelper.drawPanel(context, contentX, NoteScreenLayouts.TOP_MARGIN, contentWidth, NoteScreenLayouts.TITLE_PANEL_HEIGHT);
        this.titleField.method_25394(context, mouseX, mouseY, delta);

        // --- Content Panel ---
        int contentPanelY = NoteScreenLayouts.TOP_MARGIN + NoteScreenLayouts.TITLE_PANEL_HEIGHT + NoteScreenLayouts.PANEL_SPACING;
        int contentPanelBottom = this.field_22790 - bottomMargin;
        UIHelper.drawPanel(context, contentX, contentPanelY, contentWidth, contentPanelBottom - contentPanelY);
        this.contentField.method_25394(context, mouseX, mouseY, delta);

        // Draw screen title
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, Colors.TEXT_PRIMARY);
    }

    // We need to override mouseScrolled to pass the event to our custom widget
    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.contentField.method_25405(mouseX, mouseY)) {
            return this.contentField.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.titleField.method_25405(mouseX, mouseY)) {
            return this.titleField.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public void method_25395(class_364 focused) {
        super.method_25395(focused);
        if (focused instanceof MultiLineTextFieldWidget widget) {
            this.lastFocusedTextField = widget;
        }
    }

    @Override
    public void method_25419() {
        saveNote();
        super.method_25419();
    }
}