/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.data;

import java.time.Instant;
import java.util.UUID;
import net.atif.buildnotes.data.Scope;

public abstract class BaseEntry {
    private UUID id;
    private long lastModified;
    private Scope scope;

    protected BaseEntry() {
        this.id = UUID.randomUUID();
        this.lastModified = Instant.now().getEpochSecond();
        this.scope = Scope.WORLD;
    }

    protected BaseEntry(UUID id, long lastModified, Scope scope) {
        this.id = id;
        this.lastModified = lastModified;
        this.scope = scope;
    }

    public UUID getId() {
        return this.id;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void updateTimestamp() {
        this.lastModified = Instant.now().getEpochSecond();
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }
}

