/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Stack;
import net.atif.buildnotes.Buildnotes;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ScissorStack {
    private static final Stack<Rect> stack = new Stack();

    public static void push(int x, int y, int width, int height, class_4587 matrices) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        Vector4f corner1 = new Vector4f((float)x, (float)y, 0.0f, 1.0f);
        matrix.transform(corner1);
        Vector4f corner2 = new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f);
        matrix.transform(corner2);
        int transformedX = (int)Math.min(corner1.x, corner2.x);
        int transformedY = (int)Math.min(corner1.y, corner2.y);
        int transformedWidth = (int)(Math.max(corner1.x, corner2.x) - (float)transformedX);
        int transformedHeight = (int)(Math.max(corner1.y, corner2.y) - (float)transformedY);
        Rect newRect = new Rect(transformedX, transformedY, transformedWidth, transformedHeight);
        if (!stack.isEmpty()) {
            Rect parent = stack.peek();
            newRect = ScissorStack.intersect(parent, newRect);
        }
        stack.push(newRect);
        ScissorStack.applyScissor(newRect);
    }

    public static void pop() {
        if (stack.isEmpty()) {
            Buildnotes.LOGGER.warn("ScissorStack pop attempted on an empty stack.");
            return;
        }
        stack.pop();
        if (stack.isEmpty()) {
            RenderSystem.disableScissor();
        } else {
            ScissorStack.applyScissor(stack.peek());
        }
    }

    private static Rect intersect(Rect r1, Rect r2) {
        int x = Math.max(r1.x, r2.x);
        int y = Math.max(r1.y, r2.y);
        int width = Math.min(r1.x + r1.width, r2.x + r2.width) - x;
        int height = Math.min(r1.y + r1.height, r2.y + r2.height) - y;
        return new Rect(x, y, Math.max(0, width), Math.max(0, height));
    }

    private static void applyScissor(Rect rect) {
        double scale = class_310.method_1551().method_22683().method_4495();
        int windowHeight = class_310.method_1551().method_22683().method_4506();
        int scissorY = (int)((double)windowHeight - (double)(rect.y + rect.height) * scale);
        RenderSystem.enableScissor((int)((int)((double)rect.x * scale)), (int)scissorY, (int)((int)((double)rect.width * scale)), (int)((int)((double)rect.height * scale)));
    }

    private record Rect(int x, int y, int width, int height) {
    }
}

