/*
 * Decompiled with CFR 0.152.
 */
package net.atif.buildnotes.gui.widget;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.atif.buildnotes.data.undoredo.TextAction;
import net.atif.buildnotes.data.undoredo.UndoManager;
import net.atif.buildnotes.gui.helper.Colors;
import net.atif.buildnotes.gui.helper.ScissorStack;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class MultiLineTextFieldWidget
implements class_4068,
class_364,
class_6379 {
    private final class_327 textRenderer;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected final int maxLines;
    protected final boolean scrollingEnabled;
    protected boolean allowVerticalScroll;
    protected boolean allowHorizontalScroll;
    protected List<String> lines = Lists.newArrayList((Object[])new String[]{""});
    protected int cursorX = 0;
    protected int cursorY = 0;
    protected boolean focused = false;
    protected double scrollY = 0.0;
    protected double scrollX = 0.0;
    protected static final int SCROLLBAR_THICKNESS = 6;
    protected boolean isDraggingVScrollbar = false;
    protected double vScrollbarDragStartY = 0.0;
    protected double vScrollbarDragStartScrollY = 0.0;
    protected boolean isDraggingHScrollbar = false;
    protected double hScrollbarDragStartX = 0.0;
    protected double hScrollbarDragStartScrollX = 0.0;
    protected int selectionStart = 0;
    protected int selectionEnd = 0;
    protected int selectionAnchor = 0;
    protected long lastClickTime = 0L;
    protected int lastClickIndex = -1;
    protected int clickCount = 0;
    private static final long DOUBLE_CLICK_INTERVAL_MS = 300L;
    protected boolean isDraggingText = false;
    private final UndoManager undoManager = new UndoManager(this);
    protected String placeholderText;
    protected boolean caretVisible = true;
    protected long lastBlinkTime = System.currentTimeMillis();
    protected static final long BLINK_INTERVAL_MS = 500L;
    private boolean caretEnabled = true;
    private boolean internalScissoringEnabled = true;
    private Consumer<String> changedListener = s -> {};

    public MultiLineTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, String initialText, String placeholder, int maxLines, boolean scrollingEnabled) {
        this.textRenderer = textRenderer;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.maxLines = maxLines;
        this.scrollingEnabled = scrollingEnabled;
        this.placeholderText = placeholder;
        boolean defaultVerticalScroll = this.scrollingEnabled;
        if (maxLines == 1) {
            defaultVerticalScroll = false;
        }
        this.allowVerticalScroll = defaultVerticalScroll;
        this.allowHorizontalScroll = true;
        this.setText(initialText);
    }

    public void setCaretEnabled(boolean enabled) {
        this.caretEnabled = enabled;
        this.caretVisible = enabled;
    }

    public void setChangedListener(Consumer<String> listener) {
        this.changedListener = listener;
    }

    private void onChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.getText());
        }
    }

    public void setInternalScissoring(boolean enabled) {
        this.internalScissoringEnabled = enabled;
    }

    public void setText(String text) {
        this.lines.clear();
        this.lines.addAll(Arrays.asList(Objects.requireNonNullElse(text, "").split("\n", -1)));
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
        this.setCursorToEnd();
        this.clearSelection();
        this.focused = false;
        this.scrollX = 0.0;
        this.scrollY = 0.0;
        this.clampScroll();
    }

    public String getText() {
        return String.join((CharSequence)"\n", this.lines);
    }

    protected void setCursor(int x, int y) {
        this.cursorY = Math.max(0, Math.min(y, this.lines.size() - 1));
        this.cursorX = Math.max(0, Math.min(x, this.lines.get(this.cursorY).length()));
        this.ensureCursorVisible();
    }

    protected void setCursorToEnd() {
        this.cursorY = this.lines.size() - 1;
        this.cursorX = this.lines.get(this.cursorY).length();
        this.ensureCursorVisible();
    }

    protected int getTotalLength() {
        int total = 0;
        for (String s : this.lines) {
            total += s.length();
        }
        return total += Math.max(0, this.lines.size() - 1);
    }

    protected int getAbsoluteIndex(int lineIndex, int col) {
        int abs = 0;
        for (int i = 0; i < lineIndex; ++i) {
            abs += this.lines.get(i).length() + 1;
        }
        return abs += Math.max(0, Math.min(col, this.lines.get(lineIndex).length()));
    }

    protected int[] getLineColFromAbsolute(int absoluteIndex) {
        int remaining = Math.max(0, Math.min(absoluteIndex, this.getTotalLength()));
        for (int i = 0; i < this.lines.size(); ++i) {
            int lineLen = this.lines.get(i).length();
            if (remaining <= lineLen) {
                return new int[]{i, remaining};
            }
            if ((remaining -= lineLen + 1) >= 0) continue;
            return new int[]{i, lineLen};
        }
        int last = this.lines.size() - 1;
        return new int[]{last, this.lines.get(last).length()};
    }

    public int getCursorAbsolute() {
        return this.getAbsoluteIndex(this.cursorY, this.cursorX);
    }

    public int getSelectionStartAbsolute() {
        return this.selectionStart;
    }

    public int getSelectionEndAbsolute() {
        return this.selectionEnd;
    }

    public void setCursorFromAbsolute(int absoluteIndex) {
        int[] lc = this.getLineColFromAbsolute(absoluteIndex);
        this.setCursor(lc[1], lc[0]);
    }

    public void setSelectionAbsolute(int a, int b) {
        int e;
        int t = Math.max(0, Math.min(a, this.getTotalLength()));
        if (t <= (e = Math.max(0, Math.min(b, this.getTotalLength())))) {
            this.selectionStart = t;
            this.selectionEnd = e;
        } else {
            this.selectionStart = e;
            this.selectionEnd = t;
        }
    }

    protected void clearSelection() {
        int abs;
        this.selectionStart = abs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
        this.selectionEnd = abs;
        this.selectionAnchor = abs;
    }

    protected boolean hasSelection() {
        return this.selectionEnd > this.selectionStart;
    }

    protected String getSelectedText() {
        int[] eLC;
        if (!this.hasSelection()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int start = this.selectionStart;
        int end = this.selectionEnd;
        int[] sLC = this.getLineColFromAbsolute(start);
        if (sLC[0] == (eLC = this.getLineColFromAbsolute(end))[0]) {
            return this.lines.get(sLC[0]).substring(sLC[1], eLC[1]);
        }
        sb.append(this.lines.get(sLC[0]).substring(sLC[1]));
        sb.append('\n');
        for (int i = sLC[0] + 1; i < eLC[0]; ++i) {
            sb.append(this.lines.get(i));
            sb.append('\n');
        }
        sb.append(this.lines.get(eLC[0]), 0, eLC[1]);
        return sb.toString();
    }

    protected void deleteSelection() {
        if (!this.hasSelection()) {
            return;
        }
        final int start = this.selectionStart;
        final int end = this.selectionEnd;
        final String selectedText = this.getSelectedText();
        TextAction action = new TextAction(){

            @Override
            public void execute() {
                MultiLineTextFieldWidget.this._deleteTextInternal(start, end);
            }

            @Override
            public void undo() {
                MultiLineTextFieldWidget.this._insertTextInternal(start, selectedText);
            }
        };
        this.undoManager.perform(action);
        this.onChanged();
    }

    protected void selectWordAt(int absoluteIndex) {
        int wordEndCol;
        int[] lc = this.getLineColFromAbsolute(absoluteIndex);
        int line = lc[0];
        int col = lc[1];
        String lineStr = this.lines.get(line);
        if (lineStr.isEmpty()) {
            return;
        }
        int wordStartCol = col;
        if ((wordStartCol > 0 && wordStartCol >= lineStr.length() || Character.isWhitespace(lineStr.charAt(wordStartCol))) && wordStartCol > 0) {
            --wordStartCol;
        }
        while (wordStartCol > 0 && !Character.isWhitespace(lineStr.charAt(wordStartCol - 1))) {
            --wordStartCol;
        }
        for (wordEndCol = col; wordEndCol < lineStr.length() && !Character.isWhitespace(lineStr.charAt(wordEndCol)); ++wordEndCol) {
        }
        int selectionStartAbs = this.getAbsoluteIndex(line, wordStartCol);
        int selectionEndAbs = this.getAbsoluteIndex(line, wordEndCol);
        this.setSelectionAbsolute(selectionStartAbs, selectionEndAbs);
        this.setCursorFromAbsolute(selectionEndAbs);
    }

    protected void selectLineAt(int absoluteIndex) {
        int[] lc = this.getLineColFromAbsolute(absoluteIndex);
        int line = lc[0];
        int lineStartAbs = this.getAbsoluteIndex(line, 0);
        int lineEndAbs = this.getAbsoluteIndex(line, this.lines.get(line).length());
        this.setSelectionAbsolute(lineStartAbs, lineEndAbs);
        this.setCursorFromAbsolute(lineEndAbs);
    }

    public void insertText(String textToInsert) {
        if (textToInsert == null || textToInsert.isEmpty()) {
            return;
        }
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        final int start = this.getCursorAbsolute();
        final String text = textToInsert;
        TextAction action = new TextAction(){

            @Override
            public void execute() {
                MultiLineTextFieldWidget.this._insertTextInternal(start, text);
            }

            @Override
            public void undo() {
                MultiLineTextFieldWidget.this._deleteTextInternal(start, start + text.length());
            }
        };
        this.undoManager.perform(action);
        this.onChanged();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_437 currentScreen;
        if (this.focused && (currentScreen = class_310.method_1551().field_1755) != null && currentScreen.method_25399() != this) {
            this.focused = false;
        }
        int padding = 5;
        int contentX = this.x + padding;
        int contentY = this.y + padding;
        int contentWidth = this.width - padding * 2;
        int contentHeight = this.height - padding * 2;
        boolean vNeeded = this.isScrollbarNeededV();
        boolean hNeeded = this.isScrollbarNeededH();
        if (vNeeded) {
            contentWidth -= 8;
        }
        if (hNeeded) {
            contentHeight -= 8;
        }
        if (this.internalScissoringEnabled) {
            ScissorStack.push(this.x, this.y, this.width, this.height, matrices);
        }
        if (this.getText().isEmpty() && !this.focused && this.placeholderText != null && !this.placeholderText.isEmpty()) {
            int drawX = contentX - (int)Math.round(this.scrollX);
            this.textRenderer.method_1729(matrices, this.placeholderText, (float)drawX, (float)contentY, Colors.TEXT_DISABLED);
        }
        Objects.requireNonNull(this.textRenderer);
        int firstVisibleLine = (int)(this.scrollY / 9.0);
        int n = this.lines.size() - 1;
        Objects.requireNonNull(this.textRenderer);
        int lastVisibleLine = Math.min(n, firstVisibleLine + contentHeight / 9 + 1);
        if (this.hasSelection() && this.focused) {
            int selStart = this.selectionStart;
            int selEnd = this.selectionEnd;
            for (int i = firstVisibleLine; i <= lastVisibleLine; ++i) {
                int interEnd;
                int lineStartAbs = this.getAbsoluteIndex(i, 0);
                int lineEndAbs = lineStartAbs + this.lines.get(i).length();
                int interStart = Math.max(selStart, lineStartAbs);
                if (interStart >= (interEnd = Math.min(selEnd, lineEndAbs))) continue;
                int startCol = interStart - lineStartAbs;
                int endCol = interEnd - lineStartAbs;
                int sx = contentX + (int)Math.round((double)this.textRenderer.method_1727(this.lines.get(i).substring(0, startCol)) - this.scrollX);
                int ex = contentX + (int)Math.round((double)this.textRenderer.method_1727(this.lines.get(i).substring(0, endCol)) - this.scrollX);
                Objects.requireNonNull(this.textRenderer);
                int lineYPos = contentY + i * 9 - (int)this.scrollY;
                Objects.requireNonNull(this.textRenderer);
                class_332.method_25294((class_4587)matrices, (int)sx, (int)lineYPos, (int)ex, (int)(lineYPos + 9), (int)Colors.SELECTION_BACKGROUND);
            }
        }
        for (int i = firstVisibleLine; i <= lastVisibleLine; ++i) {
            Objects.requireNonNull(this.textRenderer);
            int lineYPos = contentY + i * 9 - (int)this.scrollY;
            Objects.requireNonNull(this.textRenderer);
            if (lineYPos <= this.y - 9 || lineYPos >= this.y + this.height) continue;
            int drawX = contentX - (int)Math.round(this.scrollX);
            this.textRenderer.method_1729(matrices, this.lines.get(i), (float)drawX, (float)lineYPos, Colors.TEXT_PRIMARY);
        }
        long now = System.currentTimeMillis();
        if (now - this.lastBlinkTime >= 500L) {
            this.caretVisible = !this.caretVisible;
            this.lastBlinkTime = now;
        }
        if (this.caretEnabled && this.focused && this.caretVisible) {
            int paddingTop = 1;
            int paddingBottom = 1;
            if (this.cursorY >= firstVisibleLine && this.cursorY <= lastVisibleLine) {
                String line = this.lines.get(this.cursorY);
                int caretPixelX = contentX + (int)Math.round((double)this.textRenderer.method_1727(line.substring(0, this.cursorX)) - this.scrollX);
                Objects.requireNonNull(this.textRenderer);
                int caretYPos = contentY + this.cursorY * 9 - (int)this.scrollY;
                int top = caretYPos - paddingTop;
                Objects.requireNonNull(this.textRenderer);
                int bottom = caretYPos + 9 + paddingBottom;
                class_332.method_25294((class_4587)matrices, (int)caretPixelX, (int)top, (int)(caretPixelX + 1), (int)bottom, (int)Colors.CARET_PRIMARY);
            }
        }
        if (this.internalScissoringEnabled) {
            ScissorStack.pop();
        }
        if (this.scrollingEnabled && vNeeded) {
            this.renderVScrollbar(matrices, contentHeight);
        }
        if (this.scrollingEnabled && hNeeded) {
            this.renderHScrollbar(matrices, contentX, contentWidth);
        }
    }

    protected void renderVScrollbar(class_4587 matrices, int contentHeight) {
        int scrollbarX = this.x + this.width - 6 - 2;
        int maxScroll = this.getMaxScrollV();
        int n = this.lines.size();
        Objects.requireNonNull(this.textRenderer);
        float contentPixelHeight = n * 9;
        float thumbHeight = Math.max(10.0f, (float)contentHeight / contentPixelHeight * (float)contentHeight);
        float thumbY = (float)(this.scrollY / (double)Math.max(1, maxScroll) * (double)((float)contentHeight - thumbHeight));
        int thumbColor = this.isDraggingVScrollbar ? Colors.SCROLLBAR_THUMB_ACTIVE : Colors.SCROLLBAR_THUMB_INACTIVE;
        class_332.method_25294((class_4587)matrices, (int)scrollbarX, (int)(this.y + 5 + (int)thumbY), (int)(scrollbarX + 6), (int)(this.y + 5 + (int)(thumbY + thumbHeight)), (int)thumbColor);
    }

    protected void renderHScrollbar(class_4587 matrices, int contentX, int contentWidth) {
        int scrollbarY = this.y + this.height - 6 - 2;
        int maxLinePixel = this.getMaxLinePixelWidth();
        if (maxLinePixel <= 0) {
            return;
        }
        float thumbWidth = Math.max(10.0f, (float)contentWidth / (float)Math.max(1, this.getMaxLinePixelWidth()) * (float)contentWidth);
        float thumbX = (float)(this.scrollX / (double)Math.max(1, this.getMaxScrollH()) * (double)((float)contentWidth - thumbWidth));
        int thumbColor = this.isDraggingHScrollbar ? Colors.SCROLLBAR_THUMB_ACTIVE : Colors.SCROLLBAR_THUMB_INACTIVE;
        class_332.method_25294((class_4587)matrices, (int)(contentX + (int)thumbX), (int)scrollbarY, (int)(contentX + (int)(thumbX + thumbWidth)), (int)(scrollbarY + 6), (int)thumbColor);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            boolean hNeeded;
            boolean vNeeded = this.scrollingEnabled && this.isScrollbarNeededV();
            boolean bl = hNeeded = this.scrollingEnabled && this.isScrollbarNeededH();
            if (vNeeded) {
                int vXStart = this.x + this.width - 6 - 2;
                int vYEnd = this.y + this.height - (hNeeded ? 8 : 0);
                if (mouseX >= (double)vXStart && mouseY < (double)vYEnd) {
                    this.isDraggingVScrollbar = true;
                    this.vScrollbarDragStartY = mouseY;
                    this.vScrollbarDragStartScrollY = this.scrollY;
                    this.focused = true;
                    return true;
                }
            }
            if (hNeeded) {
                int hYStart = this.y + this.height - 6 - 2;
                int hXEnd = this.x + this.width - (vNeeded ? 8 : 0);
                if (mouseY >= (double)hYStart && mouseX < (double)hXEnd) {
                    this.isDraggingHScrollbar = true;
                    this.hScrollbarDragStartX = mouseX;
                    this.hScrollbarDragStartScrollX = this.scrollX;
                    this.focused = true;
                    return true;
                }
            }
            this.focused = true;
            int clickedAbs = this.absoluteIndexFromMouse(mouseX, mouseY);
            long now = System.currentTimeMillis();
            this.clickCount = now - this.lastClickTime < 300L && clickedAbs == this.lastClickIndex ? ++this.clickCount : 1;
            this.lastClickTime = now;
            this.lastClickIndex = clickedAbs;
            if (this.clickCount == 1) {
                boolean shift = class_437.method_25442();
                if (shift) {
                    this.setSelectionAbsolute(this.selectionAnchor, clickedAbs);
                    this.setCursorFromAbsolute(clickedAbs);
                } else {
                    this.selectionAnchor = clickedAbs;
                    this.setSelectionAbsolute(clickedAbs, clickedAbs);
                    this.setCursorFromAbsolute(clickedAbs);
                    this.isDraggingText = true;
                }
            } else if (this.clickCount == 2) {
                this.selectWordAt(clickedAbs);
                this.isDraggingText = false;
            } else if (this.clickCount == 3) {
                this.selectLineAt(clickedAbs);
                this.isDraggingText = false;
                this.clickCount = 0;
            }
            return true;
        }
        this.focused = false;
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingVScrollbar = false;
        this.isDraggingHScrollbar = false;
        this.isDraggingText = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollingEnabled && this.isDraggingVScrollbar) {
            double dragDelta = mouseY - this.vScrollbarDragStartY;
            int trackHeight = this.height - 10 - (this.isScrollbarNeededH() ? 8 : 0);
            double maxScroll = Math.max(1, this.getMaxScrollV());
            int n = this.lines.size();
            Objects.requireNonNull(this.textRenderer);
            double contentPixelHeight = n * 9;
            double thumbHeight = Math.max(10.0, (double)trackHeight / contentPixelHeight * (double)trackHeight);
            double toTrack = (double)trackHeight - thumbHeight;
            if (toTrack <= 0.0) {
                return true;
            }
            this.scrollY = this.vScrollbarDragStartScrollY + dragDelta * (maxScroll / toTrack);
            this.clampScroll();
            return true;
        }
        if (this.scrollingEnabled && this.isDraggingHScrollbar) {
            double dragDelta = mouseX - this.hScrollbarDragStartX;
            int padding = 5;
            int contentWidth = this.width - padding * 2 - (this.isScrollbarNeededV() ? 8 : 0);
            int maxH = this.getMaxScrollH();
            double thumbWidth = Math.max(10.0f, (float)contentWidth / (float)Math.max(1, this.getMaxLinePixelWidth()) * (float)contentWidth);
            double toTrack = (double)contentWidth - thumbWidth;
            if (toTrack <= 0.0) {
                return true;
            }
            this.scrollX = this.hScrollbarDragStartScrollX + dragDelta * ((double)maxH / toTrack);
            this.clampScroll();
            return true;
        }
        if (this.isDraggingText) {
            int abs = this.absoluteIndexFromMouse(mouseX, mouseY);
            this.setSelectionAbsolute(this.selectionAnchor, abs);
            this.setCursorFromAbsolute(abs);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        boolean shift = class_437.method_25442();
        if (shift && this.allowHorizontalScroll) {
            this.scrollX -= amount * 10.0;
            this.clampScroll();
            return true;
        }
        if (!shift && this.allowVerticalScroll) {
            this.scrollY -= amount * 10.0;
            this.clampScroll();
            return true;
        }
        return false;
    }

    protected int absoluteIndexFromMouse(double mouseX, double mouseY) {
        int padding = 5;
        int contentX = this.x + padding;
        double d = mouseY - (double)(this.y + padding) + this.scrollY;
        Objects.requireNonNull(this.textRenderer);
        int clickedLine = (int)(d / 9.0);
        clickedLine = Math.max(0, Math.min(clickedLine, this.lines.size() - 1));
        int relX = (int)Math.round(mouseX - (double)contentX + this.scrollX);
        if (relX < 0) {
            relX = 0;
        }
        String line = this.lines.get(clickedLine);
        int charIndex = this.textRenderer.method_27523(line, relX).length();
        return this.getAbsoluteIndex(clickedLine, charIndex);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.focused) {
            return false;
        }
        boolean shift = class_437.method_25442();
        boolean ctrl = class_437.method_25441();
        if (ctrl && keyCode == 90) {
            this.undoManager.undo();
            this.onChanged();
            return true;
        }
        if (ctrl && keyCode == 89) {
            this.undoManager.redo();
            this.onChanged();
            return true;
        }
        if (ctrl && keyCode == 263) {
            int oldAbs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
            int newAbs = this.moveWordBackAbsolute(oldAbs);
            this.moveCursorToAbsolute(newAbs, shift);
            return true;
        }
        if (ctrl && keyCode == 262) {
            int oldAbs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
            int newAbs = this.moveWordForwardAbsolute(oldAbs);
            this.moveCursorToAbsolute(newAbs, shift);
            return true;
        }
        if (class_437.method_25439((int)keyCode)) {
            this.setSelectionAbsolute(0, this.getTotalLength());
            this.setCursorFromAbsolute(this.getTotalLength());
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            if (this.hasSelection()) {
                class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            }
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            String clip = class_310.method_1551().field_1774.method_1460();
            if (clip != null && !clip.isEmpty()) {
                this.insertText(clip);
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            if (this.hasSelection()) {
                class_310.method_1551().field_1774.method_1455(this.getSelectedText());
                this.deleteSelection();
            }
            return true;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                if (this.lines.size() < this.maxLines) {
                    this.insertText("\n");
                }
                return true;
            }
            case 259: {
                if (this.hasSelection()) {
                    this.deleteSelection();
                    return true;
                }
                if (ctrl) {
                    int oldAbs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
                    if (oldAbs > 0) {
                        int newAbs = this.moveWordBackAbsolute(oldAbs);
                        this.setSelectionAbsolute(newAbs, oldAbs);
                        this.deleteSelection();
                    }
                    return true;
                }
                if (this.cursorX == 0 && this.cursorY > 0) {
                    String lineToMerge = this.lines.remove(this.cursorY);
                    int prevLineIndex = this.cursorY - 1;
                    String prevLine = this.lines.get(prevLineIndex);
                    int newCursorX = prevLine.length();
                    this.lines.set(prevLineIndex, prevLine + lineToMerge);
                    this.setCursor(newCursorX, prevLineIndex);
                } else if (this.cursorX > 0) {
                    String line = this.lines.get(this.cursorY);
                    String before = line.substring(0, this.cursorX - 1);
                    String after = line.substring(this.cursorX);
                    this.lines.set(this.cursorY, before + after);
                    this.setCursor(this.cursorX - 1, this.cursorY);
                }
                this.onChanged();
                return true;
            }
            case 261: {
                if (this.hasSelection()) {
                    this.deleteSelection();
                    return true;
                }
                if (ctrl) {
                    int oldAbs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
                    if (oldAbs < this.getTotalLength()) {
                        int newAbs = this.moveWordForwardAbsolute(oldAbs);
                        this.setSelectionAbsolute(oldAbs, newAbs);
                        this.deleteSelection();
                    }
                    return true;
                }
                String line = this.lines.get(this.cursorY);
                if (this.cursorX == line.length() && this.cursorY < this.lines.size() - 1) {
                    String nextLine = this.lines.remove(this.cursorY + 1);
                    this.lines.set(this.cursorY, line + nextLine);
                } else if (this.cursorX < line.length()) {
                    String before = line.substring(0, this.cursorX);
                    String after = line.substring(this.cursorX + 1);
                    this.lines.set(this.cursorY, before + after);
                }
                this.onChanged();
                return true;
            }
            case 265: {
                int newLine = Math.max(0, this.cursorY - 1);
                int newCol = Math.min(this.cursorX, this.lines.get(newLine).length());
                int newAbs = this.getAbsoluteIndex(newLine, newCol);
                this.moveCursorToAbsolute(newAbs, shift);
                return true;
            }
            case 264: {
                int newLine = Math.min(this.lines.size() - 1, this.cursorY + 1);
                int newCol = Math.min(this.cursorX, this.lines.get(newLine).length());
                int newAbs = this.getAbsoluteIndex(newLine, newCol);
                this.moveCursorToAbsolute(newAbs, shift);
                return true;
            }
            case 263: {
                int oldAbs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
                if (oldAbs == 0) {
                    return true;
                }
                int newAbs = oldAbs - 1;
                this.moveCursorToAbsolute(newAbs, shift);
                return true;
            }
            case 262: {
                int oldAbs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
                if (oldAbs >= this.getTotalLength()) {
                    return true;
                }
                int newAbs = oldAbs + 1;
                this.moveCursorToAbsolute(newAbs, shift);
                return true;
            }
            case 268: {
                int newAbs = this.getAbsoluteIndex(this.cursorY, 0);
                this.moveCursorToAbsolute(newAbs, shift);
                return true;
            }
            case 269: {
                int newAbs = this.getAbsoluteIndex(this.cursorY, this.lines.get(this.cursorY).length());
                this.moveCursorToAbsolute(newAbs, shift);
                return true;
            }
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.focused) {
            if (chr == '\u0000' || Character.isISOControl(chr)) {
                return false;
            }
            this.insertText(Character.toString(chr));
            return true;
        }
        return false;
    }

    protected void ensureCursorVisible() {
        String line;
        int caretPixel;
        int padding = 5;
        int contentWidth = this.width - padding * 2 - (this.isScrollbarNeededV() ? 8 : 0);
        int contentHeight = this.height - padding * 2 - (this.isScrollbarNeededH() ? 8 : 0);
        Objects.requireNonNull(this.textRenderer);
        int topVisibleLine = (int)(this.scrollY / 9.0);
        if (this.cursorY < topVisibleLine) {
            Objects.requireNonNull(this.textRenderer);
            this.scrollY = this.cursorY * 9;
        }
        Objects.requireNonNull(this.textRenderer);
        int linesOnScreen = contentHeight / 9;
        if (this.cursorY >= topVisibleLine + linesOnScreen) {
            Objects.requireNonNull(this.textRenderer);
            this.scrollY = (this.cursorY - linesOnScreen + 1) * 9;
        }
        if ((double)(caretPixel = this.textRenderer.method_1727((line = this.lines.get(this.cursorY)).substring(0, this.cursorX))) - this.scrollX < 0.0) {
            this.scrollX = caretPixel;
        } else if ((double)caretPixel - this.scrollX > (double)(contentWidth - 4)) {
            this.scrollX = caretPixel - (contentWidth - 4);
        }
        this.clampScroll();
    }

    protected int getMaxScrollV() {
        int n = this.lines.size();
        Objects.requireNonNull(this.textRenderer);
        return Math.max(0, n * 9 - (this.height - 10 - (this.isScrollbarNeededH() ? 8 : 0)));
    }

    protected boolean isScrollbarNeededV() {
        int n = this.lines.size();
        Objects.requireNonNull(this.textRenderer);
        return n * 9 > this.height - 10;
    }

    protected int getMaxLinePixelWidth() {
        int max = 0;
        for (String s : this.lines) {
            int w = this.textRenderer.method_1727(s);
            if (w <= max) continue;
            max = w;
        }
        return max;
    }

    protected int getMaxScrollH() {
        int padding = 5;
        int contentWidth = this.width - padding * 2 - (this.isScrollbarNeededV() ? 8 : 0);
        int maxLine = this.getMaxLinePixelWidth();
        return Math.max(0, maxLine - contentWidth);
    }

    protected boolean isScrollbarNeededH() {
        return this.getMaxLinePixelWidth() > this.width - 10 - (this.isScrollbarNeededV() ? 8 : 0);
    }

    protected void clampScroll() {
        if (this.allowVerticalScroll) {
            double maxV = this.getMaxScrollV();
            if (this.scrollY > maxV) {
                this.scrollY = maxV;
            }
            if (this.scrollY < 0.0) {
                this.scrollY = 0.0;
            }
        } else {
            this.scrollY = 0.0;
        }
        if (this.allowHorizontalScroll) {
            double maxH = this.getMaxScrollH();
            if (this.scrollX > maxH) {
                this.scrollX = maxH;
            }
            if (this.scrollX < 0.0) {
                this.scrollX = 0.0;
            }
        } else {
            this.scrollX = 0.0;
        }
    }

    protected void moveCursorToAbsolute(int newAbs, boolean keepSelection) {
        newAbs = Math.max(0, Math.min(newAbs, this.getTotalLength()));
        int oldAbs = this.getAbsoluteIndex(this.cursorY, this.cursorX);
        if (keepSelection) {
            if (!this.hasSelection()) {
                this.selectionAnchor = oldAbs;
                this.setSelectionAbsolute(this.selectionAnchor, newAbs);
            } else {
                this.setSelectionAbsolute(this.selectionAnchor, newAbs);
            }
        } else {
            this.setCursorFromAbsolute(newAbs);
            this.clearSelection();
            return;
        }
        this.setCursorFromAbsolute(newAbs);
        this.ensureCursorVisible();
    }

    protected int moveWordBackAbsolute(int abs) {
        int pos;
        if (abs <= 0) {
            return 0;
        }
        int[] lc = this.getLineColFromAbsolute(abs);
        int line = lc[0];
        int col = lc[1];
        if (col == 0) {
            if (line == 0) {
                return 0;
            }
            int prevLine = line - 1;
            return this.getAbsoluteIndex(prevLine, this.lines.get(prevLine).length());
        }
        String lineStr = this.lines.get(line);
        for (pos = col; pos > 0 && Character.isWhitespace(lineStr.charAt(pos - 1)); --pos) {
        }
        while (pos > 0 && !Character.isWhitespace(lineStr.charAt(pos - 1))) {
            --pos;
        }
        return this.getAbsoluteIndex(line, pos);
    }

    protected int moveWordForwardAbsolute(int abs) {
        int pos;
        int line;
        String lineStr;
        if (abs >= this.getTotalLength()) {
            return this.getTotalLength();
        }
        int[] lc = this.getLineColFromAbsolute(abs);
        int col = lc[1];
        if (col == (lineStr = this.lines.get(line = lc[0])).length()) {
            if (line >= this.lines.size() - 1) {
                return this.getTotalLength();
            }
            return this.getAbsoluteIndex(line + 1, 0);
        }
        for (pos = col; pos < lineStr.length() && !Character.isWhitespace(lineStr.charAt(pos)); ++pos) {
        }
        while (pos < lineStr.length() && Character.isWhitespace(lineStr.charAt(pos))) {
            ++pos;
        }
        return this.getAbsoluteIndex(line, pos);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void _deleteTextInternal(int startAbsolute, int endAbsolute) {
        int[] eLC;
        int[] sLC = this.getLineColFromAbsolute(startAbsolute);
        if (sLC[0] == (eLC = this.getLineColFromAbsolute(endAbsolute))[0]) {
            String line = this.lines.get(sLC[0]);
            String before = line.substring(0, sLC[1]);
            String after = line.substring(eLC[1]);
            this.lines.set(sLC[0], before + after);
        } else {
            String firstPart = this.lines.get(sLC[0]).substring(0, sLC[1]);
            String lastPart = this.lines.get(eLC[0]).substring(eLC[1]);
            if (eLC[0] >= sLC[0] + 1) {
                this.lines.subList(sLC[0] + 1, eLC[0] + 1).clear();
            }
            this.lines.set(sLC[0], firstPart + lastPart);
        }
        this.setCursorFromAbsolute(startAbsolute);
        this.clearSelection();
    }

    public void _insertTextInternal(int startAbsolute, String textToInsert) {
        this.setCursorFromAbsolute(startAbsolute);
        String[] parts = textToInsert.split("\n", -1);
        String currentLine = this.lines.get(this.cursorY);
        String beforeCursor = currentLine.substring(0, this.cursorX);
        String afterCursor = currentLine.substring(this.cursorX);
        if (parts.length == 1) {
            this.lines.set(this.cursorY, beforeCursor + parts[0] + afterCursor);
            this.setCursor(beforeCursor.length() + parts[0].length(), this.cursorY);
        } else {
            this.lines.set(this.cursorY, beforeCursor + parts[0]);
            int insertAt = this.cursorY + 1;
            for (int i = 1; i < parts.length - 1 && this.lines.size() < this.maxLines; ++i) {
                this.lines.add(insertAt, parts[i]);
                ++insertAt;
            }
            if (this.lines.size() < this.maxLines) {
                this.lines.add(insertAt, parts[parts.length - 1] + afterCursor);
                this.setCursor(parts[parts.length - 1].length(), insertAt);
            } else {
                String last = this.lines.get(this.lines.size() - 1);
                this.lines.set(this.lines.size() - 1, last + afterCursor);
                this.setCursor(this.lines.get(this.lines.size() - 1).length(), this.lines.size() - 1);
            }
        }
        this.ensureCursorVisible();
    }

    public class_6379.class_6380 method_37018() {
        return this.focused ? class_6379.class_6380.field_33786 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }
}

