/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.interrupts;

import com.abadon.minecontrollers.ServerConfig;
import com.abadon.minecontrollers.api.MinecontrollersAPI;
import com.abadon.minecontrollers.entityblocks.microcontroller.MicrocontrollerBlockEntity;
import com.google.common.collect.Lists;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MinecontrollersInterrupts {
    public static void getGameTimeInt(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return;
        }
        long gameTime = level.m_46467_();
        microcontrollerBlockEntity.registerA = (short)(gameTime >>> 48 & 0xFFFFL);
        microcontrollerBlockEntity.registerB = (short)(gameTime >>> 32 & 0xFFFFL);
        microcontrollerBlockEntity.registerC = (short)(gameTime >>> 16 & 0xFFFFL);
        microcontrollerBlockEntity.registerD = (short)(gameTime & 0xFFFFL);
    }

    public static void getDayTimeInt(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return;
        }
        long gameTime = level.m_46468_();
        microcontrollerBlockEntity.registerA = (short)(gameTime >>> 48 & 0xFFFFL);
        microcontrollerBlockEntity.registerB = (short)(gameTime >>> 32 & 0xFFFFL);
        microcontrollerBlockEntity.registerC = (short)(gameTime >>> 16 & 0xFFFFL);
        microcontrollerBlockEntity.registerD = (short)(gameTime & 0xFFFFL);
    }

    public static void getSinCos(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        double sin = Math.sin(Math.toRadians(microcontrollerBlockEntity.registerA));
        double cos = Math.cos(Math.toRadians(microcontrollerBlockEntity.registerA));
        microcontrollerBlockEntity.registerA = (short)(sin * 1000.0);
        microcontrollerBlockEntity.registerB = (short)(cos * 1000.0);
    }

    public static void getLogn(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        microcontrollerBlockEntity.registerA = (short)(Math.log(microcontrollerBlockEntity.registerA) * 1000.0);
    }

    public static void getPow(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        short a = microcontrollerBlockEntity.registerA;
        short b = microcontrollerBlockEntity.registerB;
        microcontrollerBlockEntity.registerA = (short)Math.pow(a, (double)b / 1000.0);
    }

    public static void getDayStatus(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return;
        }
        microcontrollerBlockEntity.registerA = (short)(level.m_46461_() ? 1 : 0);
    }

    public static void getRainingStatus(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return;
        }
        microcontrollerBlockEntity.registerA = (short)(level.m_46471_() ? 1 : 0);
    }

    public static void getThunderingStatus(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return;
        }
        microcontrollerBlockEntity.registerA = (short)(level.m_46470_() ? 1 : 0);
    }

    public static void getRandomNumber(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return;
        }
        microcontrollerBlockEntity.registerA = (short)level.m_213780_().m_188502_();
    }

    public static void getSelfCoordinates(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            BlockPos blockPos = microcontrollerBlockEntity.m_58899_();
            if (level == null || level.m_7702_(blockPos) == null || !level.m_7702_(blockPos).equals((Object)microcontrollerBlockEntity)) {
                return;
            }
            microcontrollerBlockEntity.pushStack(blockPos.m_123341_() >>> 16 & 0xFFFF);
            microcontrollerBlockEntity.pushStack(blockPos.m_123341_() & 0xFFFF);
            microcontrollerBlockEntity.pushStack(blockPos.m_123342_() >>> 16 & 0xFFFF);
            microcontrollerBlockEntity.pushStack(blockPos.m_123342_() & 0xFFFF);
            microcontrollerBlockEntity.pushStack(blockPos.m_123343_() >>> 16 & 0xFFFF);
            microcontrollerBlockEntity.pushStack(blockPos.m_123343_() & 0xFFFF);
        }
    }

    public static void getWatchCoordinates(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            BlockPos blockPos = microcontrollerBlockEntity.m_58899_();
            if (level == null || level.m_7702_(blockPos) == null || !level.m_7702_(blockPos).equals((Object)microcontrollerBlockEntity)) {
                return;
            }
            BlockState blockState = level.m_8055_(blockPos);
            Direction direction = ((Direction)blockState.m_61143_((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION)).m_122424_();
            int observeDistance = (Integer)ServerConfig.MAX_OBS_RANGE.get();
            for (int i = 1; i < observeDistance; ++i) {
                BlockPos foundBlockPos = blockPos.m_5484_(direction, i);
                Block foundBlock = level.m_8055_(foundBlockPos).m_60734_();
                if (foundBlock.m_7705_().equals("block.minecraft.air")) continue;
                microcontrollerBlockEntity.registerA = 1;
                microcontrollerBlockEntity.registerB = (short)(foundBlockPos.m_123341_() - blockPos.m_123341_());
                microcontrollerBlockEntity.registerC = (short)(foundBlockPos.m_123342_() - blockPos.m_123342_());
                microcontrollerBlockEntity.registerD = (short)(foundBlockPos.m_123343_() - blockPos.m_123343_());
                return;
            }
            microcontrollerBlockEntity.registerA = 0;
        }
    }

    public static void getNearbyEntitiesCount(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            BlockPos blockPos = microcontrollerBlockEntity.m_58899_();
            if (level == null || level.m_7702_(blockPos) == null || !level.m_7702_(blockPos).equals((Object)microcontrollerBlockEntity)) {
                return;
            }
            int cubeRadius = microcontrollerBlockEntity.registerA;
            int maxCubeRadius = (Integer)ServerConfig.MAX_ENTITY_FIND_RANGE.get();
            cubeRadius = (cubeRadius = Math.abs(cubeRadius)) > maxCubeRadius ? maxCubeRadius : cubeRadius;
            BlockPos firstPos = blockPos.m_7918_(-cubeRadius, -cubeRadius, -cubeRadius);
            BlockPos secondPos = blockPos.m_7918_(cubeRadius, cubeRadius, cubeRadius);
            List nearbyEntities = level.m_45976_(LivingEntity.class, new AABB(firstPos, secondPos));
            microcontrollerBlockEntity.registerA = (short)nearbyEntities.size();
        }
    }

    public static void getNearbyPlayers(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            BlockPos blockPos = microcontrollerBlockEntity.m_58899_();
            if (level == null || level.m_7702_(blockPos) == null || !level.m_7702_(blockPos).equals((Object)microcontrollerBlockEntity)) {
                return;
            }
            int cubeRadius = microcontrollerBlockEntity.registerA;
            int maxCubeRadius = (Integer)ServerConfig.MAX_PLAYER_FIND_RANGE.get();
            cubeRadius = (cubeRadius = Math.abs(cubeRadius)) > maxCubeRadius ? maxCubeRadius : cubeRadius;
            BlockPos firstPos = blockPos.m_7918_(-cubeRadius, -cubeRadius, -cubeRadius);
            BlockPos secondPos = blockPos.m_7918_(cubeRadius, cubeRadius, cubeRadius);
            ArrayList nearbyPlayers = Lists.newArrayList();
            for (Player player : level.m_6907_()) {
                if (!new AABB(firstPos, secondPos).m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
                nearbyPlayers.add(player);
            }
            microcontrollerBlockEntity.registerA = (short)nearbyPlayers.size();
        }
    }

    public static void playSound(MicrocontrollerBlockEntity microcontrollerBlockEntity) {
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            BlockPos blockPos = microcontrollerBlockEntity.m_58899_();
            if (level == null || level.m_7702_(blockPos) == null || !level.m_7702_(blockPos).equals((Object)microcontrollerBlockEntity)) {
                return;
            }
            int cubeRadius = microcontrollerBlockEntity.registerA;
            int maxCubeRadius = (Integer)ServerConfig.MAX_MC_SOUNDING_RANGE.get();
            cubeRadius = (cubeRadius = Math.abs(cubeRadius)) > maxCubeRadius ? maxCubeRadius : cubeRadius;
            BlockPos firstPos = blockPos.m_7918_(-cubeRadius, -cubeRadius, -cubeRadius);
            BlockPos secondPos = blockPos.m_7918_(cubeRadius, cubeRadius, cubeRadius);
            SoundEvent sound = MinecontrollersAPI.formatNumberToSound(microcontrollerBlockEntity.registerB);
            for (Player player : level.m_6907_()) {
                if (!new AABB(firstPos, secondPos).m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, (double)(microcontrollerBlockEntity.registerB + microcontrollerBlockEntity.registerC));
                level.m_5594_(null, blockPos, sound, SoundSource.BLOCKS, 1.0f, (float)microcontrollerBlockEntity.registerC / 1000.0f);
            }
        }
    }

    public static void register() {
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getGameTimeInt, 0);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getDayTimeInt, 1);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getDayStatus, 2);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getRainingStatus, 3);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getThunderingStatus, 4);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getSinCos, 5);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getLogn, 6);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getPow, 7);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getRandomNumber, 8);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getSelfCoordinates, 9);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getWatchCoordinates, 10);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getNearbyEntitiesCount, 11);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::getNearbyPlayers, 12);
        MinecontrollersAPI.registerInterrupt(MinecontrollersInterrupts::playSound, 13);
    }
}

