/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.items.debugger;

import com.abadon.minecontrollers.entityblocks.microcontroller.MicrocontrollerBlockEntity;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class DebugDisplay
extends Item {
    private static final String PROTOCOL_VERSION = "1.0";
    private static final SimpleChannel SYNC_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecontrollers", (String)"debug_display_channel"), () -> "1.0", versionFromServer -> PROTOCOL_VERSION.equals(versionFromServer), versionFromClient -> PROTOCOL_VERSION.equals(versionFromClient));
    protected DebugSettingsMode settingsMode = DebugSettingsMode.ONE;
    public int memoryStep = 1;
    public int dumpSize = 32;
    public int memoryDumpStartAddress = 0;
    public String sectionDelimiter = "=================================================";

    public void sendDataToServer(int msg) {
        SYNC_CHANNEL.sendToServer((Object)msg);
    }

    public DebugDisplay(Item.Properties p_41383_) {
        super(p_41383_);
        SYNC_CHANNEL.registerMessage(0, Integer.class, (msg, buffer) -> buffer.writeInt(msg.intValue()), buffer -> buffer.getInt(1), (msg, context) -> {
            this.memoryDumpStartAddress = msg;
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public void addAddressDumpStartPoint() {
        this.memoryDumpStartAddress += this.memoryStep;
        if (this.memoryDumpStartAddress > 65535) {
            this.memoryDumpStartAddress = 65535;
        }
    }

    public void subAddressDumpStartPoint() {
        this.memoryDumpStartAddress -= this.memoryStep;
        if (this.memoryDumpStartAddress < 0) {
            this.memoryDumpStartAddress = 0;
        }
    }

    public void changeWorkingMode() {
        switch (this.settingsMode) {
            case ONE: {
                this.settingsMode = DebugSettingsMode.TEN;
                this.memoryStep = 10;
                break;
            }
            case TEN: {
                this.settingsMode = DebugSettingsMode.HUNDRED;
                this.memoryStep = 100;
                break;
            }
            case HUNDRED: {
                this.settingsMode = DebugSettingsMode.THOUSAND;
                this.memoryStep = 1000;
                break;
            }
            case THOUSAND: {
                this.settingsMode = DebugSettingsMode.ONE;
                this.memoryStep = 1;
            }
        }
    }

    protected ArrayList<MutableComponent> getRegistersSegment(MicrocontrollerBlockEntity microcontroller) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        StringBuilder defaultRegisters = new StringBuilder();
        StringBuilder highBitRegisters = new StringBuilder();
        StringBuilder lowBitRegisters = new StringBuilder();
        StringBuilder segmentRegisters = new StringBuilder();
        defaultRegisters.append("registers:    ").append(microcontroller.getRegistersNames().stream().map(r -> {
            try {
                return r + ": " + String.valueOf(((Object)((Object)microcontroller)).getClass().getField((String)r).getShort((Object)microcontroller));
            }
            catch (Exception exception) {
                defaultRegisters.append(" FATAL ERROR: ").append(exception);
                return "";
            }
        }).collect(Collectors.joining("; ")));
        highBitRegisters.append("high registers:    ").append(microcontroller.getHighBitRegistersNames().stream().map(r -> {
            try {
                return r + ": " + String.valueOf(((Object)((Object)microcontroller)).getClass().getField((String)r).getShort((Object)microcontroller) >>> 8);
            }
            catch (Exception exception) {
                highBitRegisters.append(" FATAL ERROR: ").append(exception);
                return "";
            }
        }).collect(Collectors.joining("; ")));
        lowBitRegisters.append("low registers:    ").append(microcontroller.getLowBitRegistersNames().stream().map(r -> {
            try {
                return r + ": " + String.valueOf(((Object)((Object)microcontroller)).getClass().getField((String)r).getShort((Object)microcontroller) & 0xFF);
            }
            catch (Exception exception) {
                lowBitRegisters.append(" FATAL ERROR: ").append(exception);
                return "";
            }
        }).collect(Collectors.joining("; ")));
        segmentRegisters.append("segment registers:    ").append(microcontroller.getSegmentRegistersNames().stream().map(r -> {
            try {
                return r + ": " + String.valueOf(((Object)((Object)microcontroller)).getClass().getField((String)r).getShort((Object)microcontroller));
            }
            catch (Exception exception) {
                segmentRegisters.append(" FATAL ERROR: ").append(exception);
                return "";
            }
        }).collect(Collectors.joining("; ")));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.sectionDelimiter)).m_6270_(Style.f_131099_.m_178520_(1798620)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(defaultRegisters.toString())).m_6270_(Style.f_131099_.m_178520_(14243864)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.sectionDelimiter)).m_6270_(Style.f_131099_.m_178520_(1798620)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(highBitRegisters.toString())).m_6270_(Style.f_131099_.m_178520_(14227665)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.sectionDelimiter)).m_6270_(Style.f_131099_.m_178520_(1798620)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(lowBitRegisters.toString())).m_6270_(Style.f_131099_.m_178520_(1624793)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.sectionDelimiter)).m_6270_(Style.f_131099_.m_178520_(1798620)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(segmentRegisters.toString())).m_6270_(Style.f_131099_.m_178520_(15985175)));
        components.add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.sectionDelimiter)).m_6270_(Style.f_131099_.m_178520_(1798620)));
        return components;
    }

    protected MutableComponent getMemoryDumpInfo(MicrocontrollerBlockEntity microcontroller) {
        StringBuilder dumpInfoBuilder = new StringBuilder();
        dumpInfoBuilder.append("memory dump: ");
        for (int i = this.memoryDumpStartAddress; i < this.memoryDumpStartAddress + this.dumpSize && i <= 65535; ++i) {
            dumpInfoBuilder.append(Integer.toString(i, 16)).append(':').append(Integer.toString(microcontroller.getValueByAddress(i) & 0xFF, 16)).append(' ');
        }
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(dumpInfoBuilder.toString())).m_6270_(Style.f_131099_.m_178520_(2619179));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Player player = context.m_43723_();
        if (player != null) {
            if (player.m_6144_()) {
                this.changeWorkingMode();
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.settingsMode.name())), true);
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof MicrocontrollerBlockEntity) {
                MicrocontrollerBlockEntity microcontroller = (MicrocontrollerBlockEntity)blockEntity;
                ArrayList<MutableComponent> debugInfo = new ArrayList<MutableComponent>();
                debugInfo.addAll(this.getRegistersSegment(microcontroller));
                debugInfo.add(this.getMemoryDumpInfo(microcontroller));
                for (MutableComponent component : debugInfo) {
                    player.m_5661_((Component)component, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public static enum DebugSettingsMode {
        ONE,
        TEN,
        HUNDRED,
        THOUSAND;

    }
}

