/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.entityblocks.programmer;

import com.abadon.minecontrollers.entityblocks.MinecontrollersBlocks;
import com.abadon.minecontrollers.entityblocks.programmer.Programmer;
import com.abadon.minecontrollers.inventory.ProgrammerMenu;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgrammerBlockEntity
extends BaseContainerBlockEntity
implements ChanneledPowerSupplier {
    protected int page = 0;
    protected int line = 0;
    protected byte[] power = new byte[16];
    protected LazyOptional<ChanneledPowerSupplier> powerHolder = LazyOptional.of(() -> this);
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    protected boolean exitFlag = false;

    public ProgrammerBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public boolean getWorkStatus() {
        return this.exitFlag;
    }

    public void invokeSeeker(Level level, BlockState blockState, BlockPos blockPos) {
        if (((ItemStack)this.items.get(0)).m_41783_() != null && ((ItemStack)this.items.get(0)).m_41783_().m_128441_("pages")) {
            ListTag pages = ((ItemStack)this.items.get(0)).m_41783_().m_128437_("pages", 8);
            Object[] pagesArr = new StringTag[pages.size()];
            pages.toArray(pagesArr);
            String[] lines = pagesArr[this.page].m_7916_().split("\n");
            if (this.line >= lines.length) {
                ++this.page;
                this.line = 0;
            }
            if (this.page >= pagesArr.length) {
                this.page = 0;
                this.exitFlag = true;
                return;
            }
            this.exitFlag = false;
            char[] data = pagesArr[this.page].m_7916_().split("\n")[this.line].toCharArray();
            if (data.length <= 16) {
                for (int i = 0; i < 16; ++i) {
                    if (data.length > i) {
                        char chanelData = data[i];
                        try {
                            this.power[i] = (byte)Integer.parseInt(String.valueOf(chanelData), 32);
                        }
                        catch (NumberFormatException exception) {
                            this.power[i] = 0;
                        }
                        continue;
                    }
                    this.power[i] = 0;
                }
            }
            ++this.line;
            this.m_6596_();
        } else {
            this.page = 0;
            this.line = 0;
        }
    }

    public ProgrammerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)MinecontrollersBlocks.PROGRAMMER_BE.get(), pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == MoreRedAPI.CHANNELED_POWER_CAPABILITY) {
            return side == PlateBlockStateProperties.getOutputDirection((BlockState)this.m_58900_()) ? this.powerHolder : LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("page", this.page);
        compound.m_128382_("power", this.power);
        compound.m_128473_("textbook");
        compound.m_128365_("textbook", (Tag)((ItemStack)this.items.get(0)).serializeNBT());
        compound.m_128405_("line", this.line);
        compound.m_128379_("exitFlag", this.exitFlag);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.minecontrollers.bundled_programmer");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        if (this.m_7525_(inventory.f_35978_)) {
            return new ProgrammerMenu(i, inventory, (Container)this);
        }
        return null;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.page = compound.m_128451_("page");
        this.power = (byte[])compound.m_128463_("power").clone();
        this.line = compound.m_128451_("line");
        if (compound.m_128441_("textbook")) {
            this.items.set(0, (Object)ItemStack.m_41712_((CompoundTag)compound.m_128469_("textbook")));
        }
        this.exitFlag = compound.m_128471_("exitFlag");
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return ((ItemStack)this.items.get(0)).equals(ItemStack.f_41583_);
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int i1) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)i, (int)i1);
        if (!itemstack.m_41619_()) {
            BlockState blockState = this.m_58900_();
            RedStoneWireBlock.m_49902_((BlockState)blockState, (BlockState)((BlockState)blockState.m_61124_((Property)Programmer.HAS_BOOK, (Comparable)Boolean.valueOf(false))), (LevelAccessor)this.m_58904_(), (BlockPos)this.m_58899_(), (int)3);
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.items, (int)i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        if (itemStack.m_41720_().m_7968_().m_41720_().equals(Items.f_42614_) || itemStack.m_41720_().m_7968_().m_41720_().equals(Items.f_42615_)) {
            this.items.set(i, (Object)itemStack);
            BlockState blockState = this.m_58900_();
            RedStoneWireBlock.m_49902_((BlockState)blockState, (BlockState)((BlockState)blockState.m_61124_((Property)Programmer.HAS_BOOK, (Comparable)Boolean.valueOf(true))), (LevelAccessor)this.m_58904_(), (BlockPos)this.m_58899_(), (int)3);
        } else {
            BlockState blockState = this.m_58900_();
            RedStoneWireBlock.m_49902_((BlockState)blockState, (BlockState)((BlockState)blockState.m_61124_((Property)Programmer.HAS_BOOK, (Comparable)Boolean.valueOf(false))), (LevelAccessor)this.m_58904_(), (BlockPos)this.m_58899_(), (int)3);
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
    }

    public int getPowerOnChannel(@NotNull Level world, @NotNull BlockPos wirePos, @NotNull BlockState wireState, @Nullable Direction wireFace, int channel) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof Programmer) {
            Programmer programmer = (Programmer)block;
            if (this.m_58899_().m_121945_(programmer.getLookDirection(this.m_58900_())).equals((Object)wirePos)) {
                return this.power[channel];
            }
        }
        return 0;
    }
}

