/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.utils;

import com.abadon.minecontrollers.utils.AbstractMathToken;
import com.abadon.minecontrollers.utils.BracketToken;
import com.abadon.minecontrollers.utils.ContextToken;
import com.abadon.minecontrollers.utils.MathContext;
import com.abadon.minecontrollers.utils.MathToken;
import com.abadon.minecontrollers.utils.NumberParser;
import com.abadon.minecontrollers.utils.OperatorToken;
import com.abadon.minecontrollers.utils.SignedValueToken;
import com.abadon.minecontrollers.utils.Tokenizer;
import com.abadon.minecontrollers.utils.TokensTree;
import com.abadon.minecontrollers.utils.ValueToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class MathParser {
    private static int mathOperation(OperatorToken token, int a, int b) {
        switch (token.getValue()) {
            case "+": {
                return a + b;
            }
            case "-": {
                return a - b;
            }
            case "*": {
                return a * b;
            }
            case "/": {
                return a / b;
            }
            case "^": {
                return (int)Math.pow(a, b);
            }
            case "&": {
                return a & b;
            }
            case "|": {
                return a | b;
            }
        }
        return 0;
    }

    public static void parseTree(TokensTree tree) {
        block22: {
            while (true) {
                OperatorToken operatorToken;
                Iterator iterator;
                TokensTree subtree = null;
                subtree = tree.hasTrees() ? tree.next() : tree;
                LinkedList<AbstractMathToken> tokens = new LinkedList<AbstractMathToken>();
                ArrayList<OperatorToken> operatorTokens = new ArrayList<OperatorToken>();
                while (subtree.context.getTokens().size() == 1 && (iterator = subtree.context.getTokens().stream().toArray()[0]) instanceof ContextToken) {
                    ContextToken ct = (ContextToken)((Object)iterator);
                    subtree.context.setTokens(ct.getContext().getTokens());
                }
                if (subtree.context.getTokens().size() == 1 && (iterator = subtree.context.getTokens().stream().toArray()[0]) instanceof ValueToken) {
                    ValueToken vt = (ValueToken)((Object)iterator);
                    subtree.context.result = Integer.parseInt(vt.getValue());
                    if (subtree != tree) {
                        continue;
                    }
                    break block22;
                }
                for (AbstractMathToken token : subtree.context.getTokens()) {
                    if (token instanceof OperatorToken) {
                        operatorToken = (OperatorToken)token;
                        operatorTokens.add(operatorToken);
                    }
                    tokens.add(token);
                }
                operatorTokens.sort((a, b) -> b.getPriority() - a.getPriority());
                int output = 0;
                iterator = operatorTokens.iterator();
                while (iterator.hasNext()) {
                    Object token;
                    MathToken token2;
                    operatorToken = (OperatorToken)iterator.next();
                    int firstValue = 0;
                    int secondValue = 0;
                    MathToken firstToken = null;
                    MathToken secondToken = null;
                    if (tokens.indexOf(operatorToken) - 1 >= 0) {
                        Object e = tokens.get(tokens.indexOf(operatorToken) - 1);
                        if (e instanceof ValueToken) {
                            token2 = (ValueToken)e;
                            firstToken = token2;
                            firstValue = NumberParser.getUnsignedNumber(token2.getValue());
                        } else {
                            e = tokens.get(tokens.indexOf(operatorToken) - 1);
                            if (e instanceof SignedValueToken) {
                                token = (SignedValueToken)e;
                                firstToken = token;
                                firstValue = NumberParser.getSignedNumber(((AbstractMathToken)token).getValue());
                            } else {
                                e = tokens.get(tokens.indexOf(operatorToken) - 1);
                                if (e instanceof ContextToken) {
                                    ContextToken ctx = (ContextToken)e;
                                    firstToken = ctx;
                                    firstValue = ctx.getContext().result;
                                } else if (operatorToken.getValue().equals("-")) {
                                    firstValue = 0;
                                }
                            }
                        }
                    }
                    if (tokens.indexOf(operatorToken) + 1 < tokens.size()) {
                        Object e;
                        token = tokens.get(tokens.indexOf(operatorToken) + 1);
                        if (token instanceof ValueToken) {
                            token2 = (ValueToken)token;
                            secondToken = token2;
                            secondValue = NumberParser.getUnsignedNumber(token2.getValue());
                        }
                        if ((e = tokens.get(tokens.indexOf(operatorToken) + 1)) instanceof SignedValueToken) {
                            token2 = (SignedValueToken)e;
                            secondToken = token2;
                            secondValue = NumberParser.getSignedNumber(token2.getValue());
                        } else {
                            e = tokens.get(tokens.indexOf(operatorToken) + 1);
                            if (e instanceof ContextToken) {
                                ContextToken ctx = (ContextToken)e;
                                secondToken = ctx;
                                secondValue = ctx.getContext().result;
                            }
                        }
                    }
                    int result = MathParser.mathOperation(operatorToken, firstValue, secondValue);
                    tokens.set(tokens.indexOf(operatorToken), new SignedValueToken().getToken(String.valueOf(result)));
                    if (firstToken != null) {
                        tokens.remove(firstToken);
                    }
                    if (secondToken != null) {
                        tokens.remove(secondToken);
                    }
                    output = result;
                }
                subtree.context.result = output;
                if (subtree == tree) break;
            }
            return;
        }
    }

    public static String parse(String expression) {
        expression = expression.replaceAll("\\s+", "");
        Tokenizer tokenizer = new Tokenizer(expression);
        Stack<MathContext> contextStack = new Stack<MathContext>();
        Stack<TokensTree> treeStack = new Stack<TokensTree>();
        TokensTree tree = new TokensTree();
        MathContext context = new MathContext();
        tree.setContext(context);
        ArrayList<MathToken> tokens = tokenizer.getTokens();
        if (tokens.size() < 3) {
            return expression;
        }
        for (AbstractMathToken abstractMathToken : tokens) {
            if (abstractMathToken == null) {
                return expression;
            }
            if (abstractMathToken instanceof BracketToken) {
                BracketToken bracket = (BracketToken)abstractMathToken;
                if (bracket.isOpen()) {
                    contextStack.add(context);
                    MathContext newContext = new MathContext();
                    ContextToken ctx = new ContextToken();
                    ctx.setContext(newContext);
                    context.addToken(ctx);
                    context = newContext;
                    TokensTree newTree = new TokensTree();
                    tree.addTree(newTree);
                    treeStack.add(tree);
                    tree = newTree;
                    continue;
                }
                tree.setContext(context);
                context = (MathContext)contextStack.pop();
                tree = (TokensTree)treeStack.pop();
                continue;
            }
            context.addToken(abstractMathToken);
        }
        MathParser.parseTree(tree);
        return String.valueOf(tree.context.result);
    }
}

