/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.utils;

import java.util.HashMap;
import java.util.HashSet;

public class MicrocontrollerMemory {
    protected HashMap<Integer, Byte> memory = new HashMap();
    protected HashSet<Integer> usedAddresses = new HashSet();

    public HashSet<Integer> getUsedAddresses() {
        return this.usedAddresses;
    }

    protected boolean checkForZeroValue(Byte value) {
        return value == 0;
    }

    public byte[] getMemorySequence(int from, int to) {
        byte[] sequence = new byte[to];
        to &= 0xFFFF;
        for (int i = from &= 0xFFFF; i < from + to; ++i) {
            sequence[i - from] = this.readValue(i);
        }
        return sequence;
    }

    public boolean setValue(Integer address, Byte value) {
        if (!this.memory.containsKey(address = Integer.valueOf(address & 0xFFFF))) {
            if (this.checkForZeroValue(value)) {
                return false;
            }
            this.memory.put(address, value);
            this.usedAddresses.add(address);
            return true;
        }
        if (!this.memory.get(address).equals(value)) {
            this.memory.remove(address);
            this.usedAddresses.remove(address);
            if (this.checkForZeroValue(value)) {
                return true;
            }
            this.memory.put(address, value);
            this.usedAddresses.add(address);
            return true;
        }
        return false;
    }

    public boolean setValue(Integer address, byte value) {
        return this.setValue(address, (Byte)value);
    }

    public byte readValue(Integer address) {
        if (this.memory.containsKey(address = Integer.valueOf(address & 0xFFFF))) {
            return this.memory.get(address);
        }
        return 0;
    }
}

