/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.entityblocks.microcontroller;

import com.abadon.minecontrollers.blockstates.ControllersSide;
import com.abadon.minecontrollers.entityblocks.MinecontrollersBlocks;
import com.abadon.minecontrollers.entityblocks.microcontroller.MicrocontrollerBlockEntity;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.bitwise_logic.BitwiseLogicPlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.ArrayUtils;

public class MicrocontrollerBlock
extends BitwiseLogicPlateBlock {
    public MicrocontrollerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MinecontrollersBlocks.MICROCONTROLLER_BE.get()).m_155264_(pos, state);
    }

    protected void updatePower(Level world, BlockPos thisPos, BlockState thisState) {
        BlockEntity te = world.m_7702_(thisPos);
        if (te instanceof MicrocontrollerBlockEntity) {
            MicrocontrollerBlockEntity logicTE = (MicrocontrollerBlockEntity)te;
            Direction attachmentDir = (Direction)thisState.m_61143_((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)thisState.m_61143_((Property)PlateBlockStateProperties.ROTATION);
            Direction inputSideA = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.A.rotationsFromOutput);
            Direction inputSideB = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.B.rotationsFromOutput);
            Direction inputSideC = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.C.rotationsFromOutput);
            Direction inputSideD = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.D.rotationsFromOutput);
            BlockEntity inputTileA = world.m_7702_(thisPos.m_121945_(inputSideA));
            BlockEntity inputTileB = world.m_7702_(thisPos.m_121945_(inputSideB));
            BlockEntity inputTileC = world.m_7702_(thisPos.m_121945_(inputSideC));
            BlockEntity inputTileD = world.m_7702_(thisPos.m_121945_(inputSideD));
            ChanneledPowerSupplier inputA = inputTileA == null ? BitwiseLogicPlateBlock.NO_POWER_SUPPLIER : (ChanneledPowerSupplier)inputTileA.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, inputSideA.m_122424_()).orElse((Object)NO_POWER_SUPPLIER);
            ChanneledPowerSupplier inputB = inputTileB == null ? BitwiseLogicPlateBlock.NO_POWER_SUPPLIER : (ChanneledPowerSupplier)inputTileB.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, inputSideB.m_122424_()).orElse((Object)NO_POWER_SUPPLIER);
            ChanneledPowerSupplier inputC = inputTileC == null ? BitwiseLogicPlateBlock.NO_POWER_SUPPLIER : (ChanneledPowerSupplier)inputTileC.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, inputSideC.m_122424_()).orElse((Object)NO_POWER_SUPPLIER);
            ChanneledPowerSupplier inputD = inputTileD == null ? BitwiseLogicPlateBlock.NO_POWER_SUPPLIER : (ChanneledPowerSupplier)inputTileD.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, inputSideD.m_122424_()).orElse((Object)NO_POWER_SUPPLIER);
            ArrayList<Byte> cabbleA = new ArrayList<Byte>();
            ArrayList<Byte> cabbleB = new ArrayList<Byte>();
            ArrayList<Byte> cabbleC = new ArrayList<Byte>();
            ArrayList<Byte> cabbleD = new ArrayList<Byte>();
            for (int i = 0; i < 16; ++i) {
                cabbleA.add((byte)inputA.getPowerOnChannel(world, thisPos, thisState, attachmentDir, i));
                cabbleB.add((byte)inputB.getPowerOnChannel(world, thisPos, thisState, attachmentDir, i));
                cabbleC.add((byte)inputC.getPowerOnChannel(world, thisPos, thisState, attachmentDir, i));
                cabbleD.add((byte)inputD.getPowerOnChannel(world, thisPos, thisState, attachmentDir, i));
            }
            ArrayList<Byte> power = new ArrayList<Byte>();
            power.addAll(cabbleD);
            power.addAll(cabbleA);
            power.addAll(cabbleB);
            power.addAll(cabbleC);
            Byte[] bytes = new Byte[power.size()];
            power.toArray(bytes);
            logicTE.setPower((byte[])ArrayUtils.toPrimitive((Byte[])bytes).clone());
            logicTE.applySettings();
        }
    }

    public boolean canConnectToAdjacentCable(@Nonnull BlockGetter var1, @Nonnull BlockPos var2, @Nonnull BlockState var3, @Nonnull BlockPos var4, @Nonnull BlockState var5, @Nonnull Direction var6, @Nonnull Direction var7) {
        return true;
    }
}

