/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers;

import com.abadon.minecontrollers.MinecontrollersBlocks;
import com.abadon.minecontrollers.ServerConfig;
import com.abadon.minecontrollers.interrupts.MinecontrollersInterrupts;
import com.abadon.minecontrollers.inventory.DumperMenu;
import com.abadon.minecontrollers.inventory.ModMenu;
import com.abadon.minecontrollers.items.MinecontrollersItems;
import com.abadon.minecontrollers.items.debugger.PlayerInputCatcher;
import com.abadon.minecontrollers.tabs.ModTab;
import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="minecontrollers")
public class Minecontrollers {
    public static final String MODID = "minecontrollers";
    private static final Logger LOGGER = LogUtils.getLogger();

    protected void register(IEventBus modEventBus) {
        MinecontrollersBlocks.register(modEventBus);
        MinecontrollersItems.register(modEventBus);
        ModTab.register(modEventBus);
        ModMenu.register(modEventBus);
    }

    public Minecontrollers(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        ModLoadingContext modContext = ModLoadingContext.get();
        modContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        LOGGER.info("registration custom blocks/items");
        this.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecontrollersInterrupts.register();
        DumperMenu.registerNetworkChannel();
    }

    @Mod.EventBusSubscriber(modid="minecontrollers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MinecraftForge.EVENT_BUS.addListener(PlayerInputCatcher::debuggerDisplayDumpScroll);
            ModMenu.registerScreens();
            MinecontrollersBlocks.registerSkullBlocks();
        }
    }
}

