/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers;

import com.abadon.minecontrollers.blocks.assembler.Assembler;
import com.abadon.minecontrollers.blocks.disassembler.Disassembler;
import com.abadon.minecontrollers.blocks.dumper.Dumper;
import com.abadon.minecontrollers.blocks.formatter.Formatter;
import com.abadon.minecontrollers.entityblocks.microcontroller.MicrocontrollerBlock;
import com.abadon.minecontrollers.entityblocks.microcontroller.MicrocontrollerBlockEntity;
import com.abadon.minecontrollers.entityblocks.programmer.Programmer;
import com.abadon.minecontrollers.entityblocks.programmer.ProgrammerBlockEntity;
import com.mojang.logging.LogUtils;
import commoble.morered.api.MoreRedAPI;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.PlayerWallHeadBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class MinecontrollersBlocks {
    public static HashMap<String, RegistryObject<? extends Item>> blockItems = new HashMap();
    public static HashSet<RegistryObject<? extends Block>> skullBlocks = new HashSet();
    public static DeferredRegister<Item> items = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"minecontrollers");
    public static DeferredRegister<BlockEntityType<?>> blockEntities = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"minecontrollers");
    public static DeferredRegister<Block> blocks = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"minecontrollers");
    public static final String MICROCONTROLLER_ID = "microcontroller";
    public static final String PROGRAMMER_ID = "bundled_programmer";
    public static final String FORMATTER_ID = "formatter";
    public static final String ASSEMBLER_ID = "assembler";
    public static final String DUMPER_ID = "dumper";
    public static final String DISASSEMBLER_ID = "disassembler";
    public static final SoundType defaultComponentSound = SoundType.f_56736_;
    public static final int defaultDestroyTime = 2;
    public static final int defaultStrength = 3;
    public static RegistryObject<MicrocontrollerBlock> MICROCONTROLLER_BLOCK = MinecontrollersBlocks.registerBlockItem("microcontroller", items, blocks, b -> new BlockItem((Block)b, new Item.Properties()), () -> new MicrocontrollerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60978_(0.0f).m_60918_(SoundType.f_56736_)));
    public static RegistryObject<BlockEntityType<MicrocontrollerBlockEntity>> MICROCONTROLLER_BE = blockEntities.register("microcontroller", () -> BlockEntityType.Builder.m_155273_(MicrocontrollerBlockEntity::new, (Block[])new Block[]{(Block)MICROCONTROLLER_BLOCK.get()}).m_58966_(null));
    public static RegistryObject<Programmer> PROGRAMMER = MinecontrollersBlocks.registerBlockItem("bundled_programmer", items, blocks, b -> new BlockItem((Block)b, new Item.Properties()), () -> new Programmer(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_284180_(MapColor.f_283825_)));
    public static RegistryObject<BlockEntityType<ProgrammerBlockEntity>> PROGRAMMER_BE = blockEntities.register("bundled_programmer", () -> BlockEntityType.Builder.m_155273_(ProgrammerBlockEntity::new, (Block[])new Block[]{(Block)PROGRAMMER.get()}).m_58966_(null));
    public static RegistryObject<Formatter> FORMATTER_BLOCK = MinecontrollersBlocks.registerBlockItem("formatter", items, blocks, b -> new BlockItem((Block)b, new Item.Properties()), () -> new Formatter(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(defaultComponentSound)));
    public static RegistryObject<Assembler> ASSEMBLER_BLOCK = MinecontrollersBlocks.registerBlockItem("assembler", items, blocks, b -> new BlockItem((Block)b, new Item.Properties()), () -> new Assembler(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(defaultComponentSound)));
    public static final String REDSTONE_CORE_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODg0ZTkyNDg3YzY3NDk5OTViNzk3MzdiOGE5ZWI0YzQzOTU0Nzk3YTZkZDZjZDliNGVmY2UxN2NmNDc1ODQ2In19fQ==";
    public static final String REDSTONE_CONTROLLER_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWFlNTY0MWY3YmI5ZTg3NWNkNDEyZDRiYTIwYjIyZjg3NjczYTZmMWJlMzI3OGE2MzFjODgxZDg0YzA0NDZmYiJ9fX0=";
    public static RegistryObject<PlayerHeadBlock> REDSTONE_CORE = MinecontrollersBlocks.registerSkullBlockItem("redstone_core", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODg0ZTkyNDg3YzY3NDk5OTViNzk3MzdiOGE5ZWI0YzQzOTU0Nzk3YTZkZDZjZDliNGVmY2UxN2NmNDc1ODQ2In19fQ==", items, blocks);
    public static RegistryObject<PlayerHeadBlock> REDSTONE_CONTROLLER = MinecontrollersBlocks.registerSkullBlockItem("redstone_controller", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWFlNTY0MWY3YmI5ZTg3NWNkNDEyZDRiYTIwYjIyZjg3NjczYTZmMWJlMzI3OGE2MzFjODgxZDg0YzA0NDZmYiJ9fX0=", items, blocks);
    public static RegistryObject<Dumper> DUMPER_BLOCK = MinecontrollersBlocks.registerBlockItem("dumper", items, blocks, b -> new BlockItem((Block)b, new Item.Properties()), () -> new Dumper(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(defaultComponentSound)));
    public static RegistryObject<Disassembler> DISASSEMBLER_BLOCK = MinecontrollersBlocks.registerBlockItem("disassembler", items, blocks, b -> new BlockItem((Block)b, new Item.Properties()), () -> new Disassembler(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(defaultComponentSound)));

    public static <B extends Block, I extends BlockItem> RegistryObject<B> registerBlockItem(String blockId, DeferredRegister<Item> items, DeferredRegister<Block> blocks, Function<? super B, ? extends I> itemFactory, Supplier<? extends B> blockFactory) {
        RegistryObject regb = blocks.register(blockId, blockFactory);
        RegistryObject item = items.register(blockId, () -> (BlockItem)itemFactory.apply((Object)regb.get()));
        blockItems.put(blockId, (RegistryObject<? extends Item>)item);
        return regb;
    }

    public static RegistryObject<PlayerHeadBlock> registerSkullBlockItem(String blockId, final String texture, DeferredRegister<Item> items, DeferredRegister<Block> blocks) {
        final RegistryObject skullBlock = blocks.register(blockId, () -> new PlayerHeadBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_278166_(PushReaction.DESTROY)));
        RegistryObject skullBlockWall = blocks.register(blockId + "_wall", () -> new PlayerWallHeadBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60916_((Block)skullBlock.get())){

            public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
                ((PlayerHeadBlock)skullBlock.get()).m_6402_(level, blockPos, blockState, livingEntity, itemStack);
            }

            public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
                return ((PlayerHeadBlock)skullBlock.get()).m_49635_(blockState, builder);
            }
        });
        RegistryObject item = items.register(blockId, () -> new PlayerHeadItem((Block)skullBlock.get(), (Block)skullBlockWall.get(), new Item.Properties()){

            public String getCreatorModId(ItemStack itemStack) {
                MinecontrollersBlocks.applySkullTexture(itemStack, texture);
                return super.getCreatorModId(itemStack);
            }

            public ItemStack m_7968_() {
                ItemStack itemStack = super.m_7968_();
                MinecontrollersBlocks.applySkullTexture(itemStack, texture);
                return itemStack;
            }

            public int getMaxStackSize(ItemStack stack) {
                MinecontrollersBlocks.applySkullTexture(stack, texture);
                return super.getMaxStackSize(stack);
            }
        });
        blockItems.put(blockId, (RegistryObject<? extends Item>)item);
        skullBlocks.add((RegistryObject<? extends Block>)skullBlock);
        skullBlocks.add((RegistryObject<? extends Block>)skullBlockWall);
        return skullBlock;
    }

    private static void applySkullTexture(ItemStack itemStack, String texture_data) {
        CompoundTag skullOwnerTag = new CompoundTag();
        IntArrayTag skullOwnerId = new IntArrayTag(new int[]{2080793942, -524468218, -1541115779, 1949756395});
        CompoundTag skullOwnerProperties = new CompoundTag();
        ListTag textures = new ListTag();
        CompoundTag texture = new CompoundTag();
        texture.m_128365_("Value", (Tag)StringTag.m_129297_((String)texture_data));
        textures.add((Object)texture);
        skullOwnerProperties.m_128365_("textures", (Tag)textures);
        skullOwnerTag.m_128365_("Id", (Tag)skullOwnerId);
        skullOwnerTag.m_128365_("Properties", (Tag)skullOwnerProperties);
        itemStack.m_41700_("SkullOwner", (Tag)skullOwnerTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSkullBlocks() {
        for (Field validBlocksField : BlockEntityType.f_58931_.getClass().getDeclaredFields()) {
            boolean acces = validBlocksField.isAccessible();
            boolean wasRegistered = false;
            try {
                Set validBlocks;
                validBlocksField.setAccessible(true);
                Object object = validBlocksField.get(BlockEntityType.f_58931_);
                if (object instanceof Set && (validBlocks = (Set)object).contains(Blocks.f_50316_)) {
                    HashSet<Block> newValidBlocks = new HashSet<Block>();
                    newValidBlocks.addAll(validBlocks);
                    for (RegistryObject<? extends Block> skull : skullBlocks) {
                        newValidBlocks.add((Block)skull.get());
                    }
                    validBlocksField.set(BlockEntityType.f_58931_, newValidBlocks);
                    wasRegistered = true;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                validBlocksField.setAccessible(acces);
            }
            if (wasRegistered) continue;
            LogUtils.getLogger().error("Minecontrollers: registerSkullBlocks error");
        }
    }

    public static void register(IEventBus eventBus) {
        eventBus.addListener(EventPriority.HIGH, MinecontrollersBlocks::HighPriorityCommonSetup);
        items.register(eventBus);
        blocks.register(eventBus);
        blockEntities.register(eventBus);
    }

    public static void HighPriorityCommonSetup(FMLCommonSetupEvent event) {
        MicrocontrollerBlock microcontrollerBlock = (MicrocontrollerBlock)((Object)MICROCONTROLLER_BLOCK.get());
        Programmer programmer = (Programmer)((Object)PROGRAMMER.get());
        MoreRedAPI.getCableConnectabilityRegistry().put(microcontrollerBlock, (world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire) -> microcontrollerBlock.canConnectToAdjacentCable(world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire));
        MoreRedAPI.getCableConnectabilityRegistry().put(programmer, (world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire) -> programmer.canConnectToAdjacentCable(world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire));
    }
}

