/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.blocks.assembler;

import com.abadon.minecontrollers.utils.CommandAction;
import com.abadon.minecontrollers.utils.MathParser;
import com.abadon.minecontrollers.utils.NumberParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeAssembler {
    protected HashMap<String, String> hashTable;
    protected HashMap<String, String> opcodesTable;
    protected HashMap<String, Integer> labels = new HashMap();
    protected HashMap<String, Integer> sectionLabels = new HashMap();
    private String sectionTemplate = "section\\s+(?<section>\\S+)";
    protected HashMap<String, SpecialCommand> specialCommands = new HashMap();

    protected int getCombinedMetaInfo(int firstMeta, int secondMeta) {
        String rawFirstStringMeta = String.valueOf(firstMeta);
        String rawSecondStringMeta = String.valueOf(secondMeta);
        String firstStringMeta = new StringBuilder().append(rawFirstStringMeta).reverse().append(new String("0").repeat(4 - rawFirstStringMeta.length())).toString();
        String secondStringMeta = new StringBuilder().append(rawSecondStringMeta).reverse().append(new String("0").repeat(4 - rawSecondStringMeta.length())).toString();
        StringBuilder resultMetaBuilder = new StringBuilder();
        resultMetaBuilder.append(firstStringMeta.substring(0, 2) + secondStringMeta.substring(0, 2));
        resultMetaBuilder.append(firstStringMeta.substring(2, 3) + secondStringMeta.substring(2, 3));
        resultMetaBuilder.append(firstStringMeta.substring(3, 4) + secondStringMeta.substring(3, 4));
        return Integer.valueOf(resultMetaBuilder.toString(), 2);
    }

    protected void initOpcodes() {
        for (CommandAction opcode : CommandAction.values()) {
            Object code = Integer.toString(opcode.ordinal(), 16);
            if (((String)code).length() == 1) {
                code = "0" + (String)code;
            }
            this.opcodesTable.put(opcode.name(), (String)code);
        }
    }

    public CodeAssembler() {
        this.hashTable = new HashMap();
        this.opcodesTable = new HashMap();
        this.specialCommands.put(CommandAction.LEA.name(), new LeaCommand());
        this.initOpcodes();
    }

    private String compileRawData(String dataType, String data) {
        Object result = null;
        ArgumentParser argumentParser = new ArgumentParser(data);
        switch (dataType) {
            case "db": {
                argumentParser.analyze();
                result = Integer.toUnsignedString((char)argumentParser.getParsedNumber() & 0xFFFF, 16);
                result = "0".repeat(2 - ((String)result).length()) + (String)result + "\n";
                break;
            }
            case "dw": {
                argumentParser.analyze();
                result = Integer.toUnsignedString((short)argumentParser.getParsedNumber() & 0xFFFF, 16);
                result = "0".repeat(4 - ((String)result).length()) + (String)result;
                result = ((String)result).substring(0, ((String)result).length() / 2) + "\n" + ((String)result).substring(((String)result).length() / 2, ((String)result).length()) + "\n";
            }
        }
        return result;
    }

    protected String initLabels(String code) {
        Pattern sectionPattern = Pattern.compile(this.sectionTemplate);
        Pattern labelPattern = Pattern.compile("((?<label>\\S+)\\s*:)?(\\s*(?<type>(db|dw))\\s+(?<data>\\S+))?(\\s+dup\\s*\\(\\s*(?<dup>\\d+)\\s*\\))?\\s*");
        int index = 0;
        int commandSize = 6;
        int prevSection = 0;
        int actualSegmentOffset = 0;
        for (String line : code.split("\n+")) {
            String[] keys = line.split("\\s+");
            if (keys[0].equalsIgnoreCase("ORG") && keys.length > 1) {
                ArgumentParser offsetParser = new ArgumentParser("0x" + keys[1]);
                offsetParser.analyze();
                actualSegmentOffset += offsetParser.getParsedNumber();
                continue;
            }
            Matcher labelSearcher = sectionPattern.matcher(line);
            if (labelSearcher.matches()) {
                this.sectionLabels.put(labelSearcher.group("section"), index + actualSegmentOffset);
                prevSection = index + actualSegmentOffset;
                code = code.replace(labelSearcher.group(0), "\n");
                continue;
            }
            labelSearcher = labelPattern.matcher(line);
            if (labelSearcher.matches()) {
                if (labelSearcher.group("label") != null) {
                    String label = labelSearcher.group("label");
                    this.labels.put(label, index - prevSection + actualSegmentOffset);
                }
                if (labelSearcher.group("data") != null) {
                    String type = labelSearcher.group("type");
                    String data = labelSearcher.group("data");
                    String compiledData = this.compileRawData(type, data);
                    if (labelSearcher.group("dup") != null) {
                        compiledData = compiledData.repeat(Integer.parseInt(labelSearcher.group("dup")));
                    }
                    index += compiledData.split("\n").length;
                    code = code.replace(labelSearcher.group(0), compiledData);
                    continue;
                }
                code = code.replace(labelSearcher.group(0), "");
                continue;
            }
            index += 6;
        }
        return code;
    }

    public String defaultCommand(String command) {
        String[] keys = command.split(",?\\s+", 3);
        if (keys.length == 1) {
            try {
                Integer.parseInt(keys[0], 16);
                return keys[0];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (keys[0].toUpperCase().equals("ORG")) {
            if (keys.length > 1) {
                return "OFFSET: " + keys[1];
            }
            return "\n";
        }
        if (!this.opcodesTable.containsKey(keys[0].toUpperCase())) {
            return command + " <- unknown command";
        }
        Object firstValue = "0000";
        Object secondValue = "0000";
        String opcodeName = keys[0].toUpperCase();
        String opcode = this.opcodesTable.get(opcodeName);
        try {
            ArgumentParser argumentParser;
            if (this.specialCommands.containsKey(opcodeName)) {
                SpecialCommand specialCommand = this.specialCommands.get(opcodeName).getDefaultInstance();
                String compilationResult = "";
                if (keys.length > 2) {
                    compilationResult = specialCommand.analyze(opcode, keys[1], keys[2]);
                } else if (keys.length > 1) {
                    compilationResult = specialCommand.analyze(opcode, keys[1], "");
                }
                return compilationResult;
            }
            int firstMeta = 0;
            int secondMeta = 0;
            if (keys.length > 1) {
                argumentParser = new ArgumentParser(keys[1]);
                argumentParser.analyze();
                if (argumentParser.isValid()) {
                    firstValue = Integer.toUnsignedString(argumentParser.getParsedNumber() & 0xFFFF, 16);
                    if (((String)firstValue).length() < 4) {
                        firstValue = new String("0").repeat(4 - ((String)firstValue).length()) + (String)firstValue;
                    }
                    firstMeta = argumentParser.getMetaInfo();
                } else {
                    return command + " <- incorrect first argument";
                }
            }
            if (keys.length > 2) {
                argumentParser = new ArgumentParser(keys[2]);
                argumentParser.analyze();
                if (argumentParser.isValid()) {
                    secondValue = Integer.toUnsignedString(argumentParser.getParsedNumber() & 0xFFFF, 16);
                    if (((String)secondValue).length() < 4) {
                        secondValue = new String("0").repeat(4 - ((String)secondValue).length()) + (String)secondValue;
                    }
                    secondMeta = argumentParser.getMetaInfo();
                } else {
                    return command + " <- incorrect second argument";
                }
            }
            Object meta = Integer.toString(this.getCombinedMetaInfo(firstMeta, secondMeta), 16);
            meta = "0".repeat(2 - ((String)meta).length()) + (String)meta;
            String compiledCommand = opcode + (String)meta + (String)firstValue + (String)secondValue;
            return compiledCommand;
        }
        catch (Exception exception) {
            return command + " <- fatal error";
        }
    }

    public String assembly(String assemblerCode) {
        assemblerCode = (String)assemblerCode + "\n";
        Preprocessor preprocessor = new Preprocessor((String)assemblerCode);
        preprocessor.start();
        assemblerCode = preprocessor.getCode();
        assemblerCode = ((String)assemblerCode).replaceAll("\n+", "\n").replaceAll("^\n", "").replaceAll("(\\s|\t)+\n", "\n");
        assemblerCode = this.initLabels((String)assemblerCode);
        assemblerCode = ((String)assemblerCode).replaceAll("\n+", "\n").replaceAll("^\n", "");
        StringBuilder mashineCodesBuilder = new StringBuilder();
        for (String codeline : ((String)assemblerCode).split("\\n+")) {
            mashineCodesBuilder.append(this.defaultCommand(codeline.replaceAll("\t+", " ").replaceAll("^\\s+", "").replaceAll("\\s+$", ""))).append("\n");
        }
        return mashineCodesBuilder.toString().replaceAll("\n+", "\n").replaceAll("^\n", "").toUpperCase();
    }

    protected class LeaCommand
    extends SpecialCommand {
        private int size;
        private boolean sumIndex;
        private boolean sumDisp;
        private int base;
        private int disp;
        private int index;

        public LeaCommand() {
            this.size = 0;
            this.sumIndex = false;
            this.sumDisp = false;
            this.base = 0;
            this.disp = 0;
            this.index = 0;
            this.opcode = CommandAction.LEA.ordinal();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void tokenize(String addressEval, boolean baseFound) {
            int reservedIndexTokens = -1000;
            int indexTokenSequenseSize = 2;
            int baseTokenIndex = -1;
            ArrayList<String> tokens = new ArrayList<String>();
            Object buffer = "";
            for (char c : addressEval.toCharArray()) {
                if (c == '+' || c == '*' || c == '-') {
                    tokens.add((String)buffer);
                    buffer = "";
                    tokens.add(String.valueOf(c));
                    continue;
                }
                if (c == ' ') continue;
                buffer = (String)buffer + c;
            }
            tokens.add((String)buffer);
            for (int i = 0; i < tokens.size(); ++i) {
                if (((String)tokens.get(i)).equals("*") && tokens.size() > i + 1 && i > 0) {
                    if (((String)tokens.get(i - 1)).matches("0x[a-fA-F0-9]+") || ((String)tokens.get(i - 1)).matches("[0-9]+") || ((String)tokens.get(i - 1)).matches("[01]+b")) {
                        sizeParser = new ArgumentParser((String)tokens.get(i - 1));
                        sizeParser.analyze();
                        this.size = sizeParser.getParsedNumber();
                        indexRegisterParser = new ArgumentParser((String)tokens.get(i + 1));
                        indexRegisterParser.analyze();
                        this.index = indexRegisterParser.getParsedNumber();
                        if (i + 1 == baseTokenIndex) {
                            baseFound = false;
                        }
                    } else {
                        sizeParser = new ArgumentParser((String)tokens.get(i + 1));
                        sizeParser.analyze();
                        this.size = sizeParser.getParsedNumber();
                        indexRegisterParser = new ArgumentParser((String)tokens.get(i - 1));
                        indexRegisterParser.analyze();
                        this.index = indexRegisterParser.getParsedNumber() + 1;
                        if (i - 1 == baseTokenIndex) {
                            baseFound = false;
                        }
                    }
                    if (i > 1) {
                        if (((String)tokens.get(i - 2)).equals("+")) {
                            this.sumIndex = true;
                        } else {
                            if (!((String)tokens.get(i - 2)).equals("-")) return;
                            this.sumIndex = false;
                        }
                    } else {
                        this.sumIndex = true;
                    }
                    reservedIndexTokens = i - 1;
                }
                if ((((String)tokens.get(i)).matches("0x[a-fA-F0-9]+") || ((String)tokens.get(i)).matches("[0-9]+") || ((String)tokens.get(i)).matches("[01]+b")) && (i < reservedIndexTokens || i > reservedIndexTokens + 2)) {
                    ArgumentParser ap = new ArgumentParser((String)tokens.get(i));
                    ap.analyze();
                    this.disp = ap.getParsedNumber();
                    if (i > 0) {
                        if (((String)tokens.get(i - 1)).equals("+")) {
                            this.sumDisp = true;
                        } else {
                            if (!((String)tokens.get(i - 1)).equals("-")) return;
                            this.sumDisp = false;
                        }
                    } else {
                        this.sumDisp = true;
                    }
                }
                if (!((String)tokens.get(i)).matches("[a-zA-Z]+") || i >= reservedIndexTokens && i <= reservedIndexTokens + 2) continue;
                if (!baseFound) {
                    ArgumentParser ap = new ArgumentParser((String)tokens.get(i));
                    ap.analyze();
                    this.base = ap.getParsedNumber() + 1;
                    baseTokenIndex = i;
                    baseFound = true;
                    continue;
                }
                ArgumentParser ap = new ArgumentParser((String)tokens.get(i));
                ap.analyze();
                this.index = ap.getParsedNumber() + 1;
                reservedIndexTokens = i - 1;
                if (i > 0) {
                    if (((String)tokens.get(i - 1)).equals("+")) {
                        this.sumIndex = true;
                        continue;
                    }
                    if (!((String)tokens.get(i - 1)).equals("-")) return;
                    this.sumIndex = false;
                    continue;
                }
                this.sumIndex = true;
            }
        }

        private void loadAddress(String effectiveAddress) {
            if (!effectiveAddress.matches("(\\w*)\\[(.*?)\\]")) {
                return;
            }
            Pattern effectiveAddressPattern = Pattern.compile("(\\w*)\\s*\\[(.*?)\\]");
            Matcher matcher = effectiveAddressPattern.matcher(effectiveAddress);
            matcher.find();
            if (matcher.groupCount() < 2 && matcher.group(2) == "") {
                return;
            }
            if (matcher.group(1) != "") {
                ArgumentParser ap = new ArgumentParser(matcher.group(1));
                ap.analyze();
                this.base = ap.getParsedNumber() + 1;
            }
            this.tokenize(matcher.group(2), this.base != 0);
        }

        @Override
        public String analyze(String opcode, String firstArg, String secondArg) {
            ArgumentParser sourceRegisterParser = new ArgumentParser(firstArg);
            sourceRegisterParser.analyze();
            int sourceRegister = sourceRegisterParser.getParsedNumber();
            this.loadAddress(secondArg);
            StringBuilder commandArgsBuilder = new StringBuilder();
            int infoData = (sourceRegister << 4) + ((this.sumIndex ? 1 : 0) << 3) + ((this.sumDisp ? 1 : 0) << 2) + (int)Math.round(Math.log(this.size) / Math.log(2.0)) % 4;
            int baseIndexData = (this.base << 4) + this.index;
            Object stringInfoData = Integer.toString(infoData, 16);
            Object stringBaseIndexData = Integer.toString(baseIndexData, 16);
            Object stringDispData = Integer.toString(this.disp, 16);
            stringInfoData = "0".repeat(2 - ((String)stringInfoData).length()) + (String)stringInfoData;
            stringBaseIndexData = "0".repeat(2 - ((String)stringBaseIndexData).length()) + (String)stringBaseIndexData;
            stringDispData = "0".repeat(4 - ((String)stringDispData).length()) + (String)stringDispData;
            commandArgsBuilder.append((String)stringInfoData).append((String)stringBaseIndexData).append((String)stringDispData);
            return opcode + "03" + commandArgsBuilder.toString();
        }

        @Override
        public SpecialCommand getDefaultInstance() {
            return new LeaCommand();
        }
    }

    protected class ArgumentParser {
        protected boolean valid = false;
        protected int metaInfo = 0;
        protected HashMap<String, Integer> registersTable = new HashMap();
        String argument;
        int argumentNum = 0;

        protected boolean checkKeyForNumber(String key) {
            return NumberParser.checkForSignedNumber(key);
        }

        protected boolean checkKeyForRegister(String key) {
            return this.registersTable.containsKey(key.toLowerCase());
        }

        protected boolean hasOffset(String key) {
            return key.matches("\\w{2}:.*");
        }

        protected boolean isKeyAddress(String key) {
            return key.matches("^\\[.*\\]$");
        }

        protected String getAddress(String key) throws StringIndexOutOfBoundsException {
            return key.substring(1, key.length() - 1);
        }

        protected int getNumberFromKey(String key) {
            return NumberParser.getSignedNumber(key);
        }

        protected boolean isValid() {
            return this.valid;
        }

        protected void initRegisters() {
            this.registersTable.put("ax", 0);
            this.registersTable.put("ah", 1);
            this.registersTable.put("al", 2);
            this.registersTable.put("bx", 3);
            this.registersTable.put("bh", 4);
            this.registersTable.put("bl", 5);
            this.registersTable.put("cx", 6);
            this.registersTable.put("ch", 7);
            this.registersTable.put("cl", 8);
            this.registersTable.put("dx", 9);
            this.registersTable.put("dh", 10);
            this.registersTable.put("dl", 11);
            this.registersTable.put("di", 12);
            this.registersTable.put("si", 13);
            this.registersTable.put("bp", 14);
            this.registersTable.put("sp", 15);
            this.registersTable.put("ip", 16);
            this.registersTable.put("flags", 17);
            this.registersTable.put("ds", 18);
            this.registersTable.put("ss", 19);
            this.registersTable.put("cs", 20);
            this.registersTable.put("es", 21);
            for (int i = 0; i < 64; ++i) {
                this.registersTable.put("r" + i, 22 + i);
            }
            this.registersTable.put("it", 86);
        }

        protected int getMetaInfo() {
            return this.metaInfo;
        }

        ArgumentParser(String argument) {
            this.argument = argument;
            this.initRegisters();
        }

        public void analyze() {
            String argument = this.argument;
            boolean hasOffsetFlag = false;
            if (this.hasOffset(argument)) {
                hasOffsetFlag = true;
                String offset = argument.substring(0, 2);
                argument = argument.substring(3);
                switch (offset.toUpperCase()) {
                    case "DS": {
                        this.metaInfo = 10;
                        break;
                    }
                    case "SS": {
                        this.metaInfo = 1;
                        break;
                    }
                    case "ES": {
                        this.metaInfo = 11;
                    }
                }
            }
            if (this.isKeyAddress(argument)) {
                this.metaInfo += 100;
                argument = this.getAddress(argument);
            }
            if (this.checkKeyForNumber(argument)) {
                this.valid = true;
                this.metaInfo += 1000;
                this.argumentNum = this.getNumberFromKey(argument);
            } else if (this.checkKeyForRegister(argument)) {
                this.valid = true;
                this.argumentNum = this.registersTable.get(argument.toLowerCase());
            } else if (CodeAssembler.this.sectionLabels.containsKey(argument)) {
                this.valid = true;
                this.argumentNum = CodeAssembler.this.sectionLabels.get(argument);
                this.metaInfo += 1000;
            } else {
                Pattern sectionPattern = Pattern.compile("[^0-9][a-zA-Z0-9]+");
                Matcher matcher = sectionPattern.matcher(argument);
                boolean hasLabels = false;
                while (matcher.find()) {
                    hasLabels = true;
                    String label = matcher.group(0);
                    if (!CodeAssembler.this.labels.containsKey(label)) continue;
                    argument = argument.replaceAll(label, String.valueOf(CodeAssembler.this.labels.get(label)));
                }
                if (this.checkKeyForNumber(argument = MathParser.parse(argument))) {
                    this.valid = true;
                    this.metaInfo = !hasOffsetFlag && hasLabels ? (this.metaInfo += 1010) : (this.metaInfo += 1000);
                    this.argumentNum = this.getNumberFromKey(argument);
                }
            }
        }

        public int getParsedNumber() {
            return this.argumentNum;
        }
    }

    protected abstract class SpecialCommand {
        protected int opcode = 0;

        protected SpecialCommand() {
        }

        public boolean getCommandOpcode(int opcode) {
            return this.opcode == opcode;
        }

        public abstract String analyze(String var1, String var2, String var3);

        public abstract SpecialCommand getDefaultInstance();
    }

    protected class Preprocessor {
        protected String source;
        public LinkedList<Macros> macroses = new LinkedList();
        public HashMap<String, String> macroTable = new HashMap();

        public Preprocessor(String sourceCode) {
            this.source = sourceCode;
            this.macroses.add(new oneLineMacro(this));
            this.macroses.add(new MultiLineMacro(this));
            this.macroses.add(new ConditionMacros(this));
            this.macroses.add(new RetWithoutParamsMacros(this));
            this.macroses.add(new ProcedureMacro(this));
        }

        private String[] getLineKeys(String line) {
            return line.split("\\s+");
        }

        protected void initMacroTable() {
            String macroKey = "";
            Macros macroInstance = null;
            int recheckCount = 1;
            while (recheckCount-- != 0) {
                for (Macros macros : this.macroses) {
                    for (String line : this.source.split("\n")) {
                        if (macroInstance == null && macros.isMacro(line)) {
                            macroInstance = macros.getNewMacro();
                            macroKey = macroInstance.getMacroKey(line);
                        }
                        if (macroInstance == null) continue;
                        macroInstance.applyMacroValue(line);
                        if (!macroInstance.isClosed(line)) continue;
                        int index = this.source.indexOf(line);
                        String sourceBackup = this.source;
                        this.source = this.source.substring(0, index + line.length());
                        this.source = macroInstance.removeMacroPattern(this.source);
                        if (this.macroTable.containsKey(macroKey)) {
                            if (this.applyMacroses()) {
                                ++recheckCount;
                            }
                            this.macroTable.remove(macroKey);
                        }
                        this.macroTable.put(macroKey, macroInstance.getMacroValue());
                        macroKey = "";
                        this.source = this.source + sourceBackup.substring(index + line.length());
                        this.source = macroInstance.removeGlobalMacroPattern(this.source);
                        macroInstance = null;
                    }
                }
            }
        }

        public String getCode() {
            return this.source;
        }

        protected boolean applyMacroses() {
            boolean applied = false;
            for (String macroKey : this.macroTable.keySet()) {
                if (macroKey.equals("")) continue;
                Pattern macrosUsages = Pattern.compile(macroKey + "(\\(\\s*(.*)\\s*\\))?");
                Matcher sourceLines = macrosUsages.matcher(this.source);
                while (sourceLines.find()) {
                    applied = true;
                    if (sourceLines.groupCount() > 1 && sourceLines.group(2) != null) {
                        String argString;
                        String macroString = this.macroTable.get(macroKey);
                        String sourceArgs = argString = sourceLines.group(2);
                        String wholeGroup = sourceLines.group(0);
                        int openBrackets = 0;
                        for (int i = 0; i < argString.length(); ++i) {
                            if (argString.charAt(i) == '(') {
                                ++openBrackets;
                                continue;
                            }
                            if (argString.charAt(i) != ')') continue;
                            if (openBrackets <= 0) {
                                argString = argString.substring(0, i);
                                break;
                            }
                            --openBrackets;
                        }
                        wholeGroup = wholeGroup.replace(sourceArgs, argString);
                        ArrayList<String> macroParams = new ArrayList<String>();
                        openBrackets = 0;
                        StringBuilder bufferBuilder = new StringBuilder();
                        for (int i = 0; i < argString.length(); ++i) {
                            if (argString.charAt(i) == '(') {
                                ++openBrackets;
                            } else if (argString.charAt(i) == ')') {
                                --openBrackets;
                            }
                            if (argString.charAt(i) == ',' && openBrackets == 0) {
                                macroParams.add(bufferBuilder.toString());
                                bufferBuilder = new StringBuilder();
                            } else {
                                bufferBuilder.append(argString.charAt(i));
                            }
                            if (i != argString.length() - 1) continue;
                            macroParams.add(bufferBuilder.toString());
                            bufferBuilder = new StringBuilder();
                        }
                        int paramsCount = macroParams.size();
                        for (int i = 0; i < paramsCount; ++i) {
                            macroString = macroString.replaceAll("\\$" + i, (String)macroParams.get(i));
                        }
                        macroString = macroString.replaceAll("\\$#", String.valueOf(paramsCount));
                        macroString = macroString.replaceAll("\\$\\*", argString);
                        this.source = this.source.replace(wholeGroup, macroString);
                        continue;
                    }
                    this.source = this.source.replace(macroKey, this.macroTable.get(macroKey).replace("$#", "0").replace("$*", ""));
                }
            }
            return applied;
        }

        public void start() {
            this.source = this.source.replaceAll(";.*?\n", "\n").replaceAll("\\\\.*\n", "");
            for (int i = 0; i < 128; ++i) {
                this.initMacroTable();
                if (!this.applyMacroses()) break;
            }
        }
    }

    protected class ProcedureMacro
    extends Macros {
        public String procedureName;
        public String procedurePrologue;
        public String procedureEpilogue;

        public ProcedureMacro(Preprocessor preprocessor) {
            super(preprocessor);
            this.procedureName = "";
            this.procedurePrologue = "";
            this.procedureEpilogue = "";
        }

        @Override
        public Macros getNewMacro() {
            return new ProcedureMacro(this.preprocessor);
        }

        @Override
        public boolean isMacro(String line) {
            return line.matches("\\S+\\s+proc");
        }

        @Override
        public String getMacroKey(String line) {
            return "";
        }

        @Override
        public boolean applyMacroValue(String line) {
            if (this.isMacro(line)) {
                this.procedurePrologue = line;
                this.procedureName = this.procedurePrologue.split("\\s+")[0];
                return true;
            }
            if (super.applyMacroValue(line)) {
                this.value.append("\n");
                return true;
            }
            return false;
        }

        @Override
        public boolean isClosed(String line) {
            if (line.matches("\\S+\\s+endp")) {
                this.procedureEpilogue = line;
                return true;
            }
            return false;
        }

        @Override
        public String removeMacroPattern(String code) {
            return code;
        }

        @Override
        public String removeGlobalMacroPattern(String code) {
            String[] lines = code.split("\n");
            boolean canFindNextSection = false;
            for (int i = 0; i < lines.length; ++i) {
                if (!canFindNextSection) {
                    if (!lines[i].equals(this.procedureEpilogue)) continue;
                    canFindNextSection = true;
                    continue;
                }
                if (!lines[i].matches(CodeAssembler.this.sectionTemplate)) continue;
                return code.replace(this.procedurePrologue, "").replace(this.procedureEpilogue, "").replace(this.value, "").replace(lines[i], "\n" + this.procedureName + ":\n" + this.value + "\n" + lines[i]);
            }
            return code.replace(this.procedurePrologue, "").replace(this.procedureEpilogue, "").replace(this.value, "") + "\n" + this.procedureName + ":\n" + this.value;
        }
    }

    protected class RetWithoutParamsMacros
    extends Macros {
        public RetWithoutParamsMacros(Preprocessor preprocessor) {
            super(preprocessor);
        }

        @Override
        public Macros getNewMacro() {
            return new RetWithoutParamsMacros(this.preprocessor);
        }

        @Override
        public boolean isMacro(String line) {
            return line.matches("^ret\\s*$");
        }

        @Override
        public String getMacroKey(String line) {
            return "";
        }

        @Override
        public boolean isClosed(String line) {
            return true;
        }

        @Override
        public String removeMacroPattern(String code) {
            return code.replaceAll("ret\\s*\n", "ret 0\n");
        }
    }

    protected class ConditionMacros
    extends Macros {
        boolean canPaste;
        public String key;
        private boolean isDefCondition;
        private boolean skipMacros;

        public ConditionMacros(Preprocessor preprocessor) {
            super(preprocessor);
            this.canPaste = false;
            this.key = "";
            this.isDefCondition = false;
            this.skipMacros = false;
        }

        public boolean isElseStatement(String line) {
            return line.matches("^\\s*%else\\s*");
        }

        @Override
        public Macros getNewMacro() {
            return new ConditionMacros(this.preprocessor);
        }

        @Override
        public String getMacroValue() {
            return "";
        }

        @Override
        public boolean applyMacroValue(String line) {
            this.key = this.key + line + "\n";
            if (this.isElseStatement(line)) {
                this.canPaste = !this.canPaste;
                return false;
            }
            if (!this.isMacro(line) && this.canPaste) {
                boolean returnValue = super.applyMacroValue(line);
                this.value.append("\n");
                return returnValue;
            }
            return false;
        }

        @Override
        public boolean isMacro(String line) {
            return line.matches("^\\s*(%if|%ifdef)\\s+.*");
        }

        @Override
        public String getMacroKey(String line) {
            String[] params = line.split("\\s+");
            if (params[0].equals("%ifdef")) {
                this.canPaste = this.preprocessor.macroTable.containsKey(params[1]);
            } else {
                try {
                    this.canPaste = Integer.parseInt(params[1]) > 0;
                }
                catch (RuntimeException exception) {
                    this.skipMacros = true;
                }
            }
            return "";
        }

        @Override
        public boolean isClosed(String line) {
            return line.matches("^\\s*%endif.*");
        }

        @Override
        public String removeMacroPattern(String code) {
            if (this.skipMacros) {
                return code;
            }
            return code.replaceAll(this.key.replaceAll("\n+$", ""), this.value.toString());
        }
    }

    protected class MultiLineMacro
    extends Macros {
        private String key;

        public MultiLineMacro(Preprocessor preprocessor) {
            super(preprocessor);
            this.key = "";
        }

        @Override
        public boolean applyMacroValue(String line) {
            if (!this.isMacro(line) || !this.getMacroKey(line).equals(this.key)) {
                boolean returnValue = super.applyMacroValue(line);
                this.value.append("\n");
                return returnValue;
            }
            return false;
        }

        @Override
        public Macros getNewMacro() {
            return new MultiLineMacro(this.preprocessor);
        }

        @Override
        public boolean isMacro(String line) {
            return line.matches("^\\s*%macro.*") && line.split("\\s+").length == 2;
        }

        @Override
        public String getMacroKey(String line) {
            this.key = line.split("\\s+")[1];
            return this.key;
        }

        @Override
        public boolean isClosed(String line) {
            return line.matches("^\\s*%endmacro.*");
        }

        @Override
        public String removeMacroPattern(String code) {
            boolean removing = false;
            StringBuilder newCode = new StringBuilder();
            for (String line : code.split("\n")) {
                if (this.isMacro(line)) {
                    removing = true;
                }
                if (this.isClosed(line)) {
                    removing = false;
                    continue;
                }
                if (removing) continue;
                newCode.append(line).append("\n");
            }
            return newCode.toString();
        }
    }

    protected class oneLineMacro
    extends Macros {
        public oneLineMacro(Preprocessor preprocessor) {
            super(preprocessor);
        }

        @Override
        public Macros getNewMacro() {
            return new oneLineMacro(this.preprocessor);
        }

        @Override
        public boolean isMacro(String line) {
            return line.matches("^\\s*%define.*");
        }

        @Override
        public String getMacroKey(String line) {
            return line.split("\\s+")[1];
        }

        @Override
        public boolean applyMacroValue(String line) {
            if (line.split("\\s+").length > 2) {
                this.value.append(line.replaceAll("^(\\S+\\s+){2}", ""));
            }
            return !this.isClosed(line);
        }

        @Override
        public boolean isClosed(String line) {
            return true;
        }

        @Override
        public String removeMacroPattern(String code) {
            StringBuilder newCode = new StringBuilder();
            for (String line : code.split("\n")) {
                if (this.isMacro(line)) continue;
                newCode.append(line).append("\n");
            }
            return newCode.toString();
        }
    }

    protected abstract class Macros {
        protected StringBuilder value = new StringBuilder();
        public Preprocessor preprocessor;

        public abstract Macros getNewMacro();

        public abstract boolean isMacro(String var1);

        public abstract String getMacroKey(String var1);

        public abstract boolean isClosed(String var1);

        public abstract String removeMacroPattern(String var1);

        public String removeGlobalMacroPattern(String code) {
            return code;
        }

        public Macros(Preprocessor preprocessor) {
            this.preprocessor = preprocessor;
        }

        public boolean applyMacroValue(String line) {
            if (!this.isClosed(line)) {
                this.value.append(line);
                return true;
            }
            return false;
        }

        public String getMacroValue() {
            return this.value.toString();
        }
    }
}

