/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.blocks.disassembler;

import com.abadon.minecontrollers.utils.CommandAction;
import java.util.HashMap;
import java.util.Iterator;

public class CodeDisassembler {
    protected StringBuilder asmCodeBuilder = new StringBuilder();
    protected HashMap<Integer, String> registersTable = new HashMap();
    protected HashMap<String, String> opcodesTable = new HashMap();
    protected HashMap<Integer, String> generatedLabels = new HashMap();
    protected HashMap<String, String> generatedSections = new HashMap();
    protected int actualDSIndex = 0;
    protected int actualESIndex = 0;
    protected int actualSSIndex = 0;
    private int labelsCounter = 0;
    private int sectionsCounter = 0;
    private int linesAddressCount = 0;
    private int linesCount = 0;

    protected void initOpcodes() {
        for (CommandAction opcode : CommandAction.values()) {
            Object code = Integer.toString(opcode.ordinal(), 16);
            if (((String)code).length() == 1) {
                code = "0" + (String)code;
            }
            this.opcodesTable.put((String)code, opcode.name().toLowerCase());
        }
    }

    protected void initRegisters() {
        this.registersTable.put(0, "ax");
        this.registersTable.put(1, "ah");
        this.registersTable.put(2, "al");
        this.registersTable.put(3, "bx");
        this.registersTable.put(4, "bh");
        this.registersTable.put(5, "bl");
        this.registersTable.put(6, "cx");
        this.registersTable.put(7, "ch");
        this.registersTable.put(8, "cl");
        this.registersTable.put(9, "dx");
        this.registersTable.put(10, "dh");
        this.registersTable.put(11, "dl");
        this.registersTable.put(12, "di");
        this.registersTable.put(13, "si");
        this.registersTable.put(14, "bp");
        this.registersTable.put(15, "sp");
        this.registersTable.put(16, "ip");
        this.registersTable.put(17, "flags");
        this.registersTable.put(18, "ds");
        this.registersTable.put(19, "ss");
        this.registersTable.put(20, "cs");
        this.registersTable.put(21, "es");
        for (int i = 0; i < 64; ++i) {
            this.registersTable.put(22 + i, "r" + i);
        }
        this.registersTable.put(86, "it");
    }

    protected void init() {
        this.initOpcodes();
        this.initRegisters();
    }

    protected String getOffsetPrefix(int offsetMod) {
        switch (offsetMod) {
            case 1: {
                return "ds:";
            }
            case 2: {
                return "ss:";
            }
            case 3: {
                return "es:";
            }
        }
        return "";
    }

    protected boolean isValueSegmentRegister(String value) {
        return value.equals("ds") || value.equals("ss") || value.equals("es") || value.equals("cs");
    }

    protected boolean isOpcodeJumpCommand(String opcode) {
        return opcode.equals("jmp") || opcode.equals("jz") || opcode.equals("jnz") || opcode.equals("jg") || opcode.equals("jge") || opcode.equals("jl") || opcode.equals("jle") || opcode.equals("jc") || opcode.equals("jnc") || opcode.equals("loop") || opcode.equals("call");
    }

    protected boolean isOpcodeHasSoloOperand(String opcode) {
        return this.isOpcodeJumpCommand(opcode) || opcode.equals("inc") || opcode.equals("dec") || opcode.equals("int") || opcode.equals("push") || opcode.equals("pop");
    }

    protected boolean isOpcodeHasZeroOperands(String opcode) {
        return opcode.equals("pusha") || opcode.equals("popa");
    }

    protected int getPolishedIndexOfLabel(String offset, String label) {
        switch (offset) {
            case "ds:": {
                return Integer.parseInt(label) + this.actualDSIndex;
            }
            case "es:": {
                return Integer.parseInt(label) + this.actualESIndex;
            }
            case "ss:": {
                return Integer.parseInt(label) + this.actualSSIndex;
            }
        }
        return Integer.parseInt(label);
    }

    public String lineTranslator(String line) {
        Object commentAddress = Integer.toString(this.linesAddressCount, 16);
        commentAddress = "0".repeat(4 - ((String)commentAddress).length()) + (String)commentAddress;
        this.linesAddressCount += line.length() / 2;
        ++this.linesCount;
        commentAddress = "; " + ((String)commentAddress).toUpperCase() + ":" + this.linesCount + "\n";
        if (line.length() < 12) {
            return line + (String)commentAddress;
        }
        StringBuilder decompiledLineBuilder = new StringBuilder();
        String opcode = line.substring(0, 2).toLowerCase();
        String mod = line.substring(2, 4).toLowerCase();
        int imod = Integer.valueOf(mod, 16);
        String firstOffset = this.getOffsetPrefix(imod >>> 6);
        String secondOffset = this.getOffsetPrefix(imod >>> 4 & 3);
        int firstOperand = Integer.valueOf(line.substring(4, 8).toLowerCase(), 16);
        int secondOperand = Integer.valueOf(line.substring(8, 12).toLowerCase(), 16);
        boolean firstOperandIsValue = false;
        boolean secondOperandIsValue = false;
        Object parsedFirstOperand = "";
        Object parsedSecondOperand = "";
        if ((imod >>> 1 & 1) == 1) {
            parsedFirstOperand = String.valueOf(firstOperand);
            firstOperandIsValue = true;
        } else if (this.registersTable.containsKey(firstOperand)) {
            parsedFirstOperand = this.registersTable.get(firstOperand);
        }
        if ((imod & 1) == 1) {
            secondOperandIsValue = true;
            parsedSecondOperand = String.valueOf(secondOperand);
        } else if (this.registersTable.containsKey(secondOperand)) {
            parsedSecondOperand = this.registersTable.get(secondOperand);
        }
        if (this.isOpcodeJumpCommand(this.opcodesTable.get(opcode)) && firstOffset.equals("ds:")) {
            firstOffset = "cs:";
        }
        String labelPrefix = "l";
        if (this.opcodesTable.get(opcode).equals("call")) {
            labelPrefix = "p";
        }
        if ((imod >>> 3 & 1) == 1) {
            if (firstOperandIsValue) {
                if (!this.generatedLabels.containsKey(this.getPolishedIndexOfLabel(firstOffset, (String)parsedFirstOperand))) {
                    this.generatedLabels.put(this.getPolishedIndexOfLabel(firstOffset, (String)parsedFirstOperand), labelPrefix + this.labelsCounter++);
                }
                parsedFirstOperand = "[" + this.generatedLabels.get(this.getPolishedIndexOfLabel(firstOffset, (String)parsedFirstOperand)) + "]";
            } else {
                parsedFirstOperand = "[" + (String)parsedFirstOperand + "]";
            }
        } else if (!firstOffset.isEmpty() && firstOperandIsValue) {
            if (!this.generatedLabels.containsKey(this.getPolishedIndexOfLabel(firstOffset, (String)parsedFirstOperand))) {
                this.generatedLabels.put(this.getPolishedIndexOfLabel(firstOffset, (String)parsedFirstOperand), labelPrefix + this.labelsCounter++);
            }
            parsedFirstOperand = this.generatedLabels.get(this.getPolishedIndexOfLabel(firstOffset, (String)parsedFirstOperand));
        }
        if ((imod >>> 2 & 1) == 1) {
            if (secondOperandIsValue) {
                if (!this.generatedLabels.containsKey(this.getPolishedIndexOfLabel(secondOffset, (String)parsedSecondOperand))) {
                    this.generatedLabels.put(this.getPolishedIndexOfLabel(secondOffset, (String)parsedSecondOperand), labelPrefix + this.labelsCounter++);
                }
                parsedSecondOperand = "[" + this.generatedLabels.get(this.getPolishedIndexOfLabel(secondOffset, (String)parsedSecondOperand)) + "]";
            } else {
                parsedSecondOperand = "[" + (String)parsedSecondOperand + "]";
            }
        } else if (!secondOffset.isEmpty() && secondOperandIsValue) {
            if (!this.generatedLabels.containsKey(this.getPolishedIndexOfLabel(secondOffset, (String)parsedSecondOperand))) {
                this.generatedLabels.put(this.getPolishedIndexOfLabel(secondOffset, (String)parsedSecondOperand), labelPrefix + this.labelsCounter++);
            }
            parsedSecondOperand = this.generatedLabels.get(this.getPolishedIndexOfLabel(secondOffset, (String)parsedSecondOperand));
        }
        if (this.isOpcodeJumpCommand(this.opcodesTable.get(opcode)) && firstOffset.equals("cs:")) {
            firstOffset = "";
        }
        if (this.opcodesTable.containsKey(opcode)) {
            if (this.opcodesTable.get(opcode).equals("mov") && this.isValueSegmentRegister((String)parsedFirstOperand)) {
                if (!this.generatedSections.containsKey(parsedSecondOperand)) {
                    this.generatedSections.put((String)parsedSecondOperand, "s" + this.sectionsCounter++);
                    switch (parsedFirstOperand) {
                        case "ds": {
                            this.actualDSIndex = Integer.parseInt((String)parsedSecondOperand);
                            break;
                        }
                        case "es": {
                            this.actualESIndex = Integer.parseInt((String)parsedSecondOperand);
                            break;
                        }
                        case "ss": {
                            this.actualSSIndex = Integer.parseInt((String)parsedSecondOperand);
                        }
                    }
                }
                parsedSecondOperand = this.generatedSections.get(parsedSecondOperand);
            }
            decompiledLineBuilder.append(this.opcodesTable.get(opcode));
            if (this.isOpcodeHasZeroOperands(this.opcodesTable.get(opcode))) {
                return decompiledLineBuilder.append((String)commentAddress).toString();
            }
            if (this.isOpcodeHasSoloOperand(this.opcodesTable.get(opcode))) {
                return decompiledLineBuilder.append(' ').append(firstOffset).append((String)parsedFirstOperand).append((String)commentAddress).toString();
            }
            return decompiledLineBuilder.append(' ').append(firstOffset).append((String)parsedFirstOperand).append(", ").append(secondOffset).append((String)parsedSecondOperand).append((String)commentAddress).toString();
        }
        return "";
    }

    public CodeDisassembler() {
        this.init();
    }

    protected String insertLabels(String code) {
        StringBuilder newCode = new StringBuilder();
        int lineCounter = 0;
        for (String line : code.split("\n")) {
            int index;
            for (String sectionIndex : this.generatedSections.keySet()) {
                index = Integer.parseInt(sectionIndex) / 6 + Integer.parseInt(sectionIndex) % 6;
                if (index != lineCounter) continue;
                newCode.append("section ").append(this.generatedSections.get(sectionIndex)).append("\n");
            }
            Iterator<Object> iterator = this.generatedLabels.keySet().iterator();
            while (iterator.hasNext()) {
                int labelIndex = (Integer)iterator.next();
                index = labelIndex / 6 + labelIndex % 6;
                if (index != lineCounter) continue;
                newCode.append(this.generatedLabels.get(labelIndex)).append(":\n");
            }
            newCode.append(line).append("\n");
            ++lineCounter;
        }
        return newCode.toString();
    }

    public String disassembly(String mashineCodes) {
        for (String codeline : mashineCodes.split("\\n+")) {
            this.asmCodeBuilder.append(this.lineTranslator(codeline));
        }
        return this.insertLabels(this.asmCodeBuilder.toString());
    }
}

