/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.blocks.formatter;

import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class BookFormatter {
    private final String OFFSET_PARAMETER = "^OFFSET:.*";
    private final String GLOBAL_OFFSET_PARAMETER = "^GLOFFSET:.*";

    public ItemStack format(ItemStack book) {
        ItemStack newbook = book.m_41777_();
        ListTag pages = book.m_41783_().m_128437_("pages", 8);
        Object[] pagesArr = new StringTag[pages.size()];
        pages.toArray(pagesArr);
        ListTag formattedPages = new ListTag();
        int address = 0;
        StringBuilder formattedPageBuilder = new StringBuilder();
        for (Object page : pagesArr) {
            String[] lines = page.m_7916_().split("\n");
            int compiledLines = 0;
            for (int l = 0; l < lines.length; ++l) {
                if (lines[l].matches("^OFFSET:.*")) {
                    address += Integer.valueOf(lines[l].split(":\\s*")[1], 16).intValue();
                    continue;
                }
                if (lines[l].matches("^GLOFFSET:.*")) {
                    address = Integer.valueOf(lines[l].split(":\\s*")[1], 16);
                    continue;
                }
                int addressMask = 15;
                char[] chars = lines[l].toCharArray();
                for (int i = 0; i < chars.length; i += 2) {
                    String memoryAddressPattern = (Integer.toString(address >>> 12, 16) + Integer.toString(address >>> 8 & addressMask, 16) + Integer.toString(address >>> 4 & addressMask, 16) + Integer.toString(address & addressMask, 16)).toUpperCase();
                    String value = ("" + chars[i] + chars[i + 1]).toUpperCase();
                    String blockOutput = memoryAddressPattern + value + "F00F\n";
                    formattedPageBuilder.append(blockOutput);
                    ++address;
                    ++compiledLines;
                }
                if (compiledLines % 12 != 0 && l != lines.length - 1) continue;
                compiledLines = 0;
                formattedPages.add((Object)StringTag.m_129297_((String)formattedPageBuilder.toString()));
                formattedPageBuilder = new StringBuilder();
            }
        }
        newbook.m_41783_().m_128473_("pages");
        newbook.m_41700_("pages", (Tag)formattedPages);
        return newbook;
    }
}

