/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.entityblocks.microcontroller;

import com.abadon.minecontrollers.MinecontrollersBlocks;
import com.abadon.minecontrollers.api.MinecontrollersAPI;
import com.abadon.minecontrollers.blockstates.ControllersSide;
import com.abadon.minecontrollers.utils.AddressingVariants;
import com.abadon.minecontrollers.utils.CommandHandler;
import com.abadon.minecontrollers.utils.ControllerMath;
import com.abadon.minecontrollers.utils.MicrocontrollerMemory;
import com.mojang.logging.LogUtils;
import commoble.morered.bitwise_logic.ChanneledPowerStorageBlockEntity;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class MicrocontrollerBlockEntity
extends ChanneledPowerStorageBlockEntity {
    public static final int powerPinsCount = 64;
    protected MicrocontrollerMemory memory = new MicrocontrollerMemory();
    public short registerA = 0;
    public short registerB = 0;
    public short registerC = 0;
    public short registerD = 0;
    public short registerIp = 0;
    public short registerSp = 0;
    public short registerBp = 0;
    public short registerDi = 0;
    public short registerSi = 0;
    public short registerI = 0;
    public static final byte instructionSize = 6;
    public static final byte commandletSize = 1;
    public short dataSegment = 0;
    public short codeSegment = 0;
    public short stackSegment = 0;
    public short extraSegment = 0;
    public short flags = 0;
    private boolean startFlag = false;
    protected byte[] outputPins = new byte[64];
    private HashMap<Byte, String> registers = new HashMap();
    private HashMap<Byte, String> lowBitRegisters = new HashMap();
    private HashMap<Byte, String> highBitRegisters = new HashMap();
    private HashMap<Byte, String> segmentRegisters = new HashMap();
    private HashMap<Byte, String> redstonePins = new HashMap();
    private int registerInc = 0;

    public int getValueByAddress(Integer address) {
        return this.memory.readValue(address);
    }

    public Collection<String> getRegistersNames() {
        return this.registers.values();
    }

    public Collection<String> getLowBitRegistersNames() {
        return this.lowBitRegisters.values();
    }

    public Collection<String> getHighBitRegistersNames() {
        return this.highBitRegisters.values();
    }

    public Collection<String> getSegmentRegistersNames() {
        return this.segmentRegisters.values();
    }

    protected void registerNewRegister(String register) {
        this.registers.put((byte)this.registerInc++, register);
    }

    protected void registerLowBitRegister(String register) {
        this.lowBitRegisters.put((byte)this.registerInc++, register);
    }

    protected void registerHighBitRegister(String register) {
        this.highBitRegisters.put((byte)this.registerInc++, register);
    }

    protected void registerSegmentRegister(String register) {
        this.segmentRegisters.put((byte)this.registerInc++, register);
    }

    protected void registerRedstonePin(String register) {
        this.redstonePins.put((byte)this.registerInc++, register);
    }

    public MicrocontrollerBlockEntity(BlockEntityType<? extends MicrocontrollerBlockEntity> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.power = new byte[64];
        this.registerNewRegister("registerA");
        this.registerHighBitRegister("registerA");
        this.registerLowBitRegister("registerA");
        this.registerNewRegister("registerB");
        this.registerHighBitRegister("registerB");
        this.registerLowBitRegister("registerB");
        this.registerNewRegister("registerC");
        this.registerHighBitRegister("registerC");
        this.registerLowBitRegister("registerC");
        this.registerNewRegister("registerD");
        this.registerHighBitRegister("registerD");
        this.registerLowBitRegister("registerD");
        this.registerNewRegister("registerDi");
        this.registerNewRegister("registerSi");
        this.registerNewRegister("registerBp");
        this.registerNewRegister("registerSp");
        this.registerNewRegister("registerIp");
        this.registerNewRegister("flags");
        this.registerSegmentRegister("dataSegment");
        this.registerSegmentRegister("stackSegment");
        this.registerSegmentRegister("codeSegment");
        this.registerSegmentRegister("extraSegment");
        for (int i = 0; i < 64; ++i) {
            this.registerRedstonePin("r" + i);
        }
        this.registerNewRegister("registerI");
    }

    public MicrocontrollerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends MicrocontrollerBlockEntity>)((BlockEntityType)MinecontrollersBlocks.MICROCONTROLLER_BE.get()), pos, state);
    }

    public static MicrocontrollerBlockEntity create(BlockPos pos, BlockState state) {
        return new MicrocontrollerBlockEntity((BlockEntityType<? extends MicrocontrollerBlockEntity>)((BlockEntityType)MinecontrollersBlocks.MICROCONTROLLER_BE.get()), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return this.powerHolder;
    }

    public void changeIOState() {
        for (int i = 0; i < 64; ++i) {
            if (this.outputPins[i] <= 0) continue;
            this.power[i] = 0;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public int getPowerOnChannel(Level level, BlockPos wirePos, BlockState wireState, Direction wireFace, int channel) {
        BlockState thisState = this.m_58900_();
        BlockPos thisPosition = this.m_58899_();
        int rotationIndex = (Integer)thisState.m_61143_((Property)PlateBlockStateProperties.ROTATION);
        Direction attachmentDir = (Direction)thisState.m_61143_((Property)PlateBlock.ATTACHMENT_DIRECTION);
        Direction inputSideA = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.A.rotationsFromOutput);
        Direction inputSideB = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.B.rotationsFromOutput);
        Direction inputSideC = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.C.rotationsFromOutput);
        Direction inputSideD = BlockStateUtil.getInputDirection((Direction)attachmentDir, (int)rotationIndex, (int)ControllersSide.D.rotationsFromOutput);
        int offset = 0;
        int channels = 16;
        if (wireFace == null) {
            return 0;
        }
        if (thisPosition.m_121945_(inputSideA).equals((Object)wirePos)) {
            offset = 1;
        } else if (thisPosition.m_121945_(inputSideB).equals((Object)wirePos)) {
            offset = 2;
        } else if (thisPosition.m_121945_(inputSideC).equals((Object)wirePos)) {
            offset = 3;
        } else if (thisPosition.m_121945_(inputSideD).equals((Object)wirePos)) {
            offset = 0;
        }
        return this.getOutputPower(channel + offset * channels);
    }

    public byte getOutputPower(int channel) {
        return this.outputPins[channel];
    }

    public void callInterrupt(int pin) {
        int interruptionAddress = this.registerI + pin * 2;
        Address address = new Address();
        address.IsAddress16bit = true;
        address.addressVariant = AddressingVariants.VALUE;
        address.offset = 0;
        address.useValueAsAddress = true;
        address.address = interruptionAddress;
        AddressIO addressIO = new AddressIO(this);
        int interruptionPoint = addressIO.getValueFromAddress(address);
        if (interruptionPoint != 0) {
            short oldES = this.extraSegment;
            this.extraSegment = (short)interruptionPoint;
            Address callAddress = new Address();
            callAddress.IsAddress16bit = true;
            callAddress.addressVariant = AddressingVariants.REGISTERS;
            callAddress.offset = 3;
            callAddress.useValueAsAddress = true;
            callAddress.address = 6;
            this.call(callAddress);
            this.extraSegment = oldES;
            this.pushAllRegisters();
        }
    }

    public boolean setPower(byte[] newPowers) {
        boolean updated = false;
        for (int i = 0; i < 64; ++i) {
            byte newPower = newPowers[i];
            byte oldPower = this.power[i];
            if (newPower == oldPower) continue;
            this.power[i] = newPower;
            if ((this.flags & 1) == 1) {
                this.callInterrupt(i);
            }
            updated = true;
        }
        if (updated && !this.f_58857_.f_46443_) {
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void applySettings() {
        boolean forwardSideOffset = false;
        boolean rightSideOffset = true;
        int backwardSideOffset = 2;
        int leftSideOffset = 3;
        int maxCableSignal = 31;
        int channelBits = 4;
        int address = 0;
        int value = 0;
        int chanelSideCount = 16;
        address = ((short)this.power[32] << 12) + ((short)this.power[33] << 8) + ((short)this.power[34] << 4) + (short)this.power[35];
        value = (this.power[36] << 4) + this.power[37];
        if (this.power[41] == 0) {
            this.outputPins = new byte[64];
            this.registerA = 0;
            this.registerB = 0;
            this.registerC = 0;
            this.registerD = 0;
            this.registerSp = 0;
            this.registerBp = 0;
            this.registerDi = 0;
            this.registerSi = 0;
            this.registerIp = 0;
            this.codeSegment = 0;
            this.dataSegment = 0;
            this.stackSegment = 0;
            this.extraSegment = 0;
            this.registerI = 0;
            this.startFlag = false;
            this.flags = 0;
            if (!this.f_58857_.f_46443_) {
                this.m_6596_();
            }
            return;
        }
        if (!this.startFlag) {
            this.codeSegment = (short)address;
        }
        this.startFlag = true;
        if (ControllerMath.digitalize(this.power[39]) == 31) {
            this.outputPins[36] = (byte)(((this.memory.readValue(address) & 0xFF) >>> 4) + 2);
            this.outputPins[37] = (byte)((this.memory.readValue(address) & 0xF) + 2);
        } else {
            this.outputPins[36] = 0;
            this.outputPins[37] = 0;
        }
        if (ControllerMath.digitalize(this.power[38]) == 31) {
            this.memory.setValue((Integer)address, (Byte)((byte)value));
        }
        this.changeIOState();
        if (ControllerMath.digitalize(this.power[40]) == 31) {
            this.executeInstruction((short)((this.codeSegment & 0xFFFF) + (this.registerIp & 0xFFFF)));
            this.registerIp = (short)((this.registerIp & 0xFFFF) + 6);
        }
    }

    private void applyFlags(int result, Address destinationAddress) {
        int newFlags = 0;
        if (result == 0) {
            newFlags = (short)(newFlags | 4);
        }
        if (result != (short)result) {
            newFlags = (short)(newFlags | 8);
        }
        if ((result & 0x8000) == 32768 && destinationAddress.IsAddress16bit || (result & 0x80) == 128 && !destinationAddress.IsAddress16bit) {
            newFlags = (short)(newFlags | 2);
        }
        newFlags = (short)(newFlags | this.flags & 1);
        this.flags = (short)newFlags;
    }

    public void jumpToAddress(Address address, int stepFix) {
        this.registerIp = (short)(address.address - stepFix);
        switch (address.offset) {
            case 2: {
                this.codeSegment = this.stackSegment;
                break;
            }
            case 3: {
                this.codeSegment = this.extraSegment;
            }
        }
    }

    public void pushStack(int value) {
        AddressIO addressIO = new AddressIO(this);
        this.registerSp = (short)(this.registerSp - 2);
        Address stackAddress = new Address();
        stackAddress.address = this.stackSegment + this.registerSp;
        stackAddress.useValueAsAddress = true;
        stackAddress.addressVariant = AddressingVariants.VALUE;
        stackAddress.IsAddress16bit = true;
        addressIO.setValueToAddress(stackAddress, value);
    }

    public int popStack() {
        AddressIO addressIO = new AddressIO(this);
        Address stackAddress = new Address();
        stackAddress.address = this.stackSegment + this.registerSp;
        stackAddress.useValueAsAddress = true;
        stackAddress.addressVariant = AddressingVariants.VALUE;
        stackAddress.IsAddress16bit = true;
        int value = addressIO.getValueFromAddress(stackAddress);
        addressIO.setValueToAddress(stackAddress, 0);
        this.registerSp = (short)(this.registerSp + 2);
        return value;
    }

    public void call(Address address) {
        this.pushStack(this.registerIp);
        if (address.offset != 0) {
            this.pushStack(this.codeSegment);
        }
        this.jumpToAddress(address, 6);
    }

    public void executeInstruction(short address) {
        Address firstAddress = new Address();
        Address secondAddress = new Address();
        AddressIO addressIO = new AddressIO(this);
        int chanelSideCount = 16;
        byte[] commandSeq = this.memory.getMemorySequence(address, 16);
        String byteinfo = "";
        for (byte b : commandSeq) {
            byteinfo = byteinfo.concat(String.valueOf(b));
        }
        CommandHandler commandHandler = new CommandHandler();
        AddressReader addreader = new AddressReader(this, 6, 1);
        addreader.calculateAddressTypes();
        firstAddress = addreader.firstAddress;
        secondAddress = addreader.secondAddress;
        switch (commandHandler.getAction(commandSeq[0])) {
            case MOV: {
                int secondValue = addressIO.getValueFromAddress(secondAddress);
                addressIO.setValueToAddress(firstAddress, secondValue);
                break;
            }
            case ADD: {
                int newValue = addressIO.getValueFromAddress(firstAddress) + addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case SUB: {
                int newValue = addressIO.getValueFromAddress(firstAddress) - addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case MUL: {
                int newValue = addressIO.getValueFromAddress(firstAddress) * addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case DIV: {
                int newValue = addressIO.getValueFromAddress(firstAddress) / addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case INC: {
                int newValue = addressIO.getValueFromAddress(firstAddress) + 1;
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case DEC: {
                int newValue = addressIO.getValueFromAddress(firstAddress) - 1;
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case AND: {
                int newValue = addressIO.getValueFromAddress(firstAddress) & addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case OR: {
                int newValue = addressIO.getValueFromAddress(firstAddress) | addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case XOR: {
                int newValue = addressIO.getValueFromAddress(firstAddress) ^ addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case NOT: {
                int newValue = ~addressIO.getValueFromAddress(firstAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case CMP: {
                int newValue = addressIO.getValueFromAddress(firstAddress) - addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                break;
            }
            case JMP: {
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JZ: {
                if ((this.flags & 4) != 4) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JNZ: {
                if ((this.flags & 4) == 4) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JG: {
                if ((this.flags & 6) != 0) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JL: {
                if ((this.flags & 2) != 2) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JGE: {
                if ((this.flags & 2) != 0 && (this.flags & 4) != 4) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JLE: {
                if ((this.flags & 2) != 2 && (this.flags & 4) != 4) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JC: {
                if ((this.flags & 8) != 8) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case JNC: {
                if ((this.flags & 8) == 8) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
            case SHL: {
                int newValue = addressIO.getValueFromAddress(firstAddress) << addressIO.getValueFromAddress(secondAddress);
                newValue = firstAddress.IsAddress16bit ? (newValue &= 0xFFFF) : (newValue &= 0xFF);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case SHR: {
                int firstAddressValue = addressIO.getValueFromAddress(firstAddress);
                firstAddressValue = firstAddress.IsAddress16bit ? (firstAddressValue &= 0xFFFF) : (firstAddressValue &= 0xFF);
                int newValue = firstAddressValue >>> addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case SAR: {
                int newValue = addressIO.getValueFromAddress(firstAddress) >> addressIO.getValueFromAddress(secondAddress);
                this.applyFlags(newValue, firstAddress);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case ROL: {
                int newValue = addressIO.getValueFromAddress(firstAddress);
                int roll = 0;
                int rollValue = 0;
                if (firstAddress.IsAddress16bit) {
                    rollValue = addressIO.getValueFromAddress(secondAddress) % 16;
                    roll = (newValue &= 0xFFFF) >>> 16 - rollValue;
                    this.flags = (short)(this.flags | (roll & 1) << 3);
                    newValue <<= rollValue;
                    newValue += roll;
                    newValue &= 0xFFFF;
                } else {
                    rollValue = addressIO.getValueFromAddress(secondAddress) % 8;
                    roll = (newValue &= 0xFF) >>> 8 - rollValue;
                    this.flags = (short)(this.flags | (roll & 1) << 3);
                    newValue <<= rollValue;
                    newValue += roll;
                    newValue &= 0xFF;
                }
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case ROR: {
                int newValue = addressIO.getValueFromAddress(firstAddress);
                int roll = 0;
                int rollValue = 0;
                if (firstAddress.IsAddress16bit) {
                    rollValue = addressIO.getValueFromAddress(secondAddress) % 16;
                    roll = ((newValue &= 0xFFFF) & (int)(Math.pow(2.0, rollValue) - 1.0)) << 16 - rollValue;
                    if (rollValue > 0) {
                        this.flags = (short)(this.flags | (newValue >>> rollValue - 1 & 1) << 3);
                    }
                    newValue >>>= rollValue;
                    newValue += roll;
                    newValue &= 0xFFFF;
                } else {
                    rollValue = addressIO.getValueFromAddress(secondAddress) % 8;
                    roll = ((newValue &= 0xFF) & (int)(Math.pow(2.0, rollValue) - 1.0)) << 8 - rollValue;
                    if (rollValue > 0) {
                        this.flags = (short)(this.flags | (newValue >>> rollValue - 1 & 1) << 3);
                    }
                    newValue >>>= rollValue;
                    newValue += roll;
                    newValue &= 0xFF;
                }
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case RCL: {
                int newValue = addressIO.getValueFromAddress(firstAddress);
                int cflag = (this.flags & 8) >>> 3;
                if (firstAddress.IsAddress16bit) {
                    newValue &= 0xFFFF;
                    for (int i = 0; i < addressIO.getValueFromAddress(secondAddress); ++i) {
                        int oldCFlag = cflag;
                        cflag = newValue >>> 15;
                        newValue <<= 1;
                        newValue += oldCFlag;
                    }
                } else {
                    newValue &= 0xFF;
                    for (int i = 0; i < addressIO.getValueFromAddress(secondAddress); ++i) {
                        int oldCFlag = cflag;
                        cflag = newValue >>> 7;
                        newValue <<= 1;
                        newValue += oldCFlag;
                    }
                }
                this.flags = (short)(this.flags | cflag << 3);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case RCR: {
                int newValue = addressIO.getValueFromAddress(firstAddress);
                int cflag = (this.flags & 8) >>> 3;
                newValue = firstAddress.IsAddress16bit ? (newValue &= 0xFFFF) : (newValue &= 0xFF);
                for (int i = 0; i < addressIO.getValueFromAddress(secondAddress); ++i) {
                    int oldCFlag = cflag;
                    cflag = newValue & 1;
                    newValue >>>= 1;
                    newValue += oldCFlag;
                }
                this.flags = (short)(this.flags | cflag << 3);
                addressIO.setValueToAddress(firstAddress, newValue);
                break;
            }
            case PUSH: {
                this.pushStack(addressIO.getValueFromAddress(firstAddress));
                break;
            }
            case POP: {
                addressIO.setValueToAddress(firstAddress, this.popStack());
                break;
            }
            case CALL: {
                this.call(firstAddress);
                break;
            }
            case RET: {
                int clearCount = addressIO.getValueFromAddress(firstAddress);
                for (int i = 0; i < clearCount; ++i) {
                    this.popStack();
                }
                if (addressIO.getValueFromAddress(secondAddress) == 255 || addressIO.getValueFromAddress(secondAddress) == 1) {
                    this.codeSegment = (short)this.popStack();
                }
                this.registerIp = (short)this.popStack();
                if (addressIO.getValueFromAddress(secondAddress) != 255) break;
                this.registerIp = (short)((this.registerIp & 0xFFFF) - 6);
                break;
            }
            case INT: {
                MinecontrollersAPI.invokeInterrupt(this, addressIO.getValueFromAddress(firstAddress));
                break;
            }
            case LEA: {
                boolean sumIndex = false;
                boolean sumDisp = false;
                int addressInfo = addressIO.getValueFromAddress(firstAddress);
                int disp = addressIO.getValueFromAddress(secondAddress);
                int sourceRegisterAddress = addressInfo >>> 12;
                sumIndex = (addressInfo >>> 11 & 1) == 1;
                sumDisp = (addressInfo >>> 10 & 1) == 1;
                int sizeMode = addressInfo >>> 8 & 3;
                int baseRegisterAddress = (addressInfo >>> 4 & 0xF) - 1;
                int indexRegisterAddress = (addressInfo & 0xF) - 1;
                Address baseRegister = new Address();
                Address indexRegister = new Address();
                baseRegister.IsAddress16bit = true;
                indexRegister.IsAddress16bit = true;
                baseRegister.address = baseRegisterAddress;
                indexRegister.address = indexRegisterAddress;
                int result = 0;
                result += addressIO.getValueFromAddress(baseRegister);
                result = sumIndex ? (result += addressIO.getValueFromAddress(indexRegister) * (int)Math.pow(2.0, sizeMode)) : (result -= addressIO.getValueFromAddress(indexRegister) * (int)Math.pow(2.0, sizeMode));
                result = sumDisp ? result + disp : result - disp;
                Address sourceRegister = new Address();
                sourceRegister.address = sourceRegisterAddress;
                sourceRegister.IsAddress16bit = true;
                addressIO.setValueToAddress(sourceRegister, result);
                break;
            }
            case PUSHA: {
                this.pushAllRegisters();
                break;
            }
            case POPA: {
                this.popAllRegisters();
                break;
            }
            case LOOP: {
                this.registerC = (short)(this.registerC - 1);
                if (this.registerC == 0) break;
                this.jumpToAddress(firstAddress, 6);
                break;
            }
        }
    }

    public void popAllRegisters() {
        this.extraSegment = (short)this.popStack();
        this.dataSegment = (short)this.popStack();
        this.flags = (short)this.popStack();
        this.registerSi = (short)this.popStack();
        this.registerDi = (short)this.popStack();
        this.registerD = (short)this.popStack();
        this.registerC = (short)this.popStack();
        this.registerB = (short)this.popStack();
        this.registerA = (short)this.popStack();
    }

    public void pushAllRegisters() {
        this.pushStack(this.registerA);
        this.pushStack(this.registerB);
        this.pushStack(this.registerC);
        this.pushStack(this.registerD);
        this.pushStack(this.registerDi);
        this.pushStack(this.registerSi);
        this.pushStack(this.flags);
        this.pushStack(this.dataSegment);
        this.pushStack(this.extraSegment);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128382_("power", (byte[])this.power.clone());
        compound.m_128382_("outputPins", (byte[])this.outputPins.clone());
        compound.m_128376_("AX", this.registerA);
        compound.m_128376_("BX", this.registerB);
        compound.m_128376_("CX", this.registerC);
        compound.m_128376_("DX", this.registerD);
        compound.m_128376_("IP", this.registerIp);
        compound.m_128376_("CS", this.codeSegment);
        compound.m_128376_("DS", this.dataSegment);
        compound.m_128376_("SS", this.stackSegment);
        compound.m_128376_("SP", this.registerSp);
        compound.m_128376_("BP", this.registerBp);
        compound.m_128376_("DI", this.registerDi);
        compound.m_128376_("SI", this.registerSi);
        compound.m_128376_("FLAGS", this.flags);
        compound.m_128376_("ES", this.extraSegment);
        compound.m_128379_("isActive", this.startFlag);
        compound.m_128376_("IT", this.registerI);
        CompoundTag memoryCompound = new CompoundTag();
        for (int address : this.memory.getUsedAddresses()) {
            memoryCompound.m_128344_(String.valueOf(address), this.memory.readValue(address));
        }
        compound.m_128365_("memory", (Tag)memoryCompound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        byte[] newPower = compound.m_128463_("power");
        byte[] newOutputPower = compound.m_128463_("outputPins");
        if (newPower.length == 64) {
            this.power = (byte[])newPower.clone();
        }
        if (newOutputPower.length == 64) {
            this.outputPins = (byte[])newOutputPower.clone();
        }
        this.registerA = compound.m_128448_("AX");
        this.registerB = compound.m_128448_("BX");
        this.registerC = compound.m_128448_("CX");
        this.registerD = compound.m_128448_("DX");
        this.registerIp = compound.m_128448_("IP");
        this.codeSegment = compound.m_128448_("CS");
        this.dataSegment = compound.m_128448_("DS");
        this.stackSegment = compound.m_128448_("SS");
        this.registerSp = compound.m_128448_("SP");
        this.registerBp = compound.m_128448_("BP");
        this.registerDi = compound.m_128448_("DI");
        this.registerSi = compound.m_128448_("SI");
        this.extraSegment = compound.m_128448_("ES");
        this.flags = compound.m_128448_("FLAGS");
        this.startFlag = compound.m_128471_("isActive");
        for (String address : compound.m_128469_("memory").m_128431_()) {
            this.memory.setValue(Integer.valueOf(address), compound.m_128469_("memory").m_128445_(address));
        }
        this.registerI = compound.m_128448_("IT");
    }

    public byte[] getStrongestNeighborPower() {
        return new byte[64];
    }

    protected class Address {
        public AddressingVariants addressVariant = AddressingVariants.REGISTERS;
        public boolean useValueAsAddress = false;
        public boolean IsAddress16bit = false;
        public int offset = 0;
        public int address = 0;

        protected Address() {
        }
    }

    protected class AddressIO {
        MicrocontrollerBlockEntity processor;
        public final int lowWordMask = 255;
        protected HashMap<Byte, Byte> sectionTable = new HashMap();
        protected HashMap<Byte, Integer> pinsTable = new HashMap();

        public AddressIO(MicrocontrollerBlockEntity processor) {
            this.processor = processor;
            int i = 1;
            for (Byte k : this.processor.segmentRegisters.keySet()) {
                if (this.processor.segmentRegisters.get(k) == "codeSegment") continue;
                this.sectionTable.put((byte)i++, k);
            }
            int pinIndex = 0;
            for (Byte pinRegister : this.processor.redstonePins.keySet()) {
                this.pinsTable.put(pinRegister, pinIndex++);
            }
        }

        public int getAbsoluteAdress(Address address) {
            try {
                if (this.sectionTable.containsKey((byte)address.offset) && this.processor.segmentRegisters.containsKey(this.sectionTable.get((byte)address.offset))) {
                    return address.address + ((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get(this.sectionTable.get((byte)address.offset))).getShort((Object)this.processor);
                }
                return address.address;
            }
            catch (Exception ex) {
                return address.address;
            }
        }

        public int getValueFromAddress(Address address) {
            block13: {
                if (address == null) {
                    return 0;
                }
                if (address.addressVariant == AddressingVariants.REGISTERS) {
                    try {
                        if (!address.useValueAsAddress) {
                            if (this.processor.registers.containsKey((byte)address.address)) {
                                return ((Object)((Object)this.processor)).getClass().getField(this.processor.registers.get((byte)address.address)).getShort((Object)this.processor) + (this.sectionTable.containsKey((byte)address.offset) ? ((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get(this.sectionTable.get((byte)address.offset))).getShort((Object)this.processor) : (short)0);
                            }
                            if (this.processor.lowBitRegisters.containsKey((byte)address.address)) {
                                return (((Object)((Object)this.processor)).getClass().getField(this.processor.lowBitRegisters.get((byte)address.address)).getShort((Object)this.processor) & 0xFF) + (this.sectionTable.containsKey((byte)address.offset) ? (int)((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get(this.sectionTable.get((byte)address.offset))).getShort((Object)this.processor) : 0);
                            }
                            if (this.processor.highBitRegisters.containsKey((byte)address.address)) {
                                return (((Object)((Object)this.processor)).getClass().getField(this.processor.highBitRegisters.get((byte)address.address)).getShort((Object)this.processor) >>> 8) + (this.sectionTable.containsKey((byte)address.offset) ? (int)((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get(this.sectionTable.get((byte)address.offset))).getShort((Object)this.processor) : 0);
                            }
                            if (this.processor.segmentRegisters.containsKey((byte)address.address)) {
                                return ((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get((byte)address.address)).getShort((Object)this.processor) + (this.sectionTable.containsKey((byte)address.offset) ? ((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get(this.sectionTable.get((byte)address.offset))).getShort((Object)this.processor) : (short)0);
                            }
                            if (this.processor.redstonePins.containsKey((byte)address.address) && this.pinsTable.containsKey((byte)address.address)) {
                                return this.processor.power[this.pinsTable.get((byte)address.address)] + (this.sectionTable.containsKey((byte)address.offset) ? ((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get(this.sectionTable.get((byte)address.offset))).getShort((Object)this.processor) : (short)0);
                            }
                            break block13;
                        }
                        int oldAddress = address.address;
                        address.useValueAsAddress = false;
                        int offset = address.offset;
                        address.offset = 0;
                        address.address = (short)this.getValueFromAddress(address);
                        address.offset = offset;
                        address.addressVariant = AddressingVariants.VALUE;
                        address.useValueAsAddress = true;
                        address.address = this.getAbsoluteAdress(address);
                        address.offset = 0;
                        int value = this.getValueFromAddress(address);
                        address.offset = offset;
                        address.addressVariant = AddressingVariants.REGISTERS;
                        address.address = oldAddress;
                        return value;
                    }
                    catch (Exception exception) {
                        LogUtils.getLogger().info("address getting failed: " + exception.toString());
                        return 0;
                    }
                }
                if (address.addressVariant == AddressingVariants.VALUE) {
                    if (!address.useValueAsAddress) {
                        return this.getAbsoluteAdress(address);
                    }
                    if (!address.IsAddress16bit) {
                        int oldAddress = address.address;
                        address.address = this.getAbsoluteAdress(address);
                        int offset = address.offset;
                        address.offset = 0;
                        Byte value = MicrocontrollerBlockEntity.this.memory.readValue(address.address);
                        address.address = oldAddress;
                        address.offset = offset;
                        return value.byteValue();
                    }
                    int oldAddress = address.address;
                    address.address = this.getAbsoluteAdress(address);
                    int offset = address.offset;
                    address.offset = 0;
                    Short value = (short)((Byte.toUnsignedInt(MicrocontrollerBlockEntity.this.memory.readValue(address.address)) << 8) + Byte.toUnsignedInt(MicrocontrollerBlockEntity.this.memory.readValue(address.address + 1)));
                    address.address = oldAddress;
                    address.offset = offset;
                    return value.shortValue();
                }
            }
            return 0;
        }

        public void setValueToAddress(Address address, int value) {
            block18: {
                if (address == null) {
                    return;
                }
                if (address.addressVariant == AddressingVariants.REGISTERS) {
                    try {
                        if (!address.useValueAsAddress) {
                            if (this.processor.registers.containsKey((byte)address.address)) {
                                ((Object)((Object)this.processor)).getClass().getField(this.processor.registers.get((byte)this.getAbsoluteAdress(address))).setShort((Object)this.processor, (short)value);
                            } else if (this.processor.lowBitRegisters.containsKey((byte)address.address)) {
                                ((Object)((Object)this.processor)).getClass().getField(this.processor.lowBitRegisters.get((byte)this.getAbsoluteAdress(address))).setByte((Object)this.processor, (byte)(value & 0xFF));
                            } else if (this.processor.highBitRegisters.containsKey((byte)address.address)) {
                                ((Object)((Object)this.processor)).getClass().getField(this.processor.highBitRegisters.get((byte)this.getAbsoluteAdress(address))).setShort((Object)this.processor, (short)(value << 8));
                            } else if (this.processor.segmentRegisters.containsKey((byte)address.address)) {
                                ((Object)((Object)this.processor)).getClass().getField(this.processor.segmentRegisters.get((byte)this.getAbsoluteAdress(address))).setShort((Object)this.processor, (short)value);
                            } else if (this.processor.redstonePins.containsKey((byte)address.address) && this.pinsTable.containsKey((byte)address.address)) {
                                this.processor.outputPins[this.pinsTable.get((Object)Byte.valueOf((byte)((byte)this.getAbsoluteAdress((Address)address)))).intValue()] = (byte)value;
                            }
                            break block18;
                        }
                        int oldAddress = address.address;
                        address.useValueAsAddress = false;
                        int offset = address.offset;
                        address.offset = 0;
                        address.address = (short)this.getValueFromAddress(address);
                        address.offset = offset;
                        address.addressVariant = AddressingVariants.VALUE;
                        address.useValueAsAddress = true;
                        address.address = this.getAbsoluteAdress(address);
                        address.offset = 0;
                        this.setValueToAddress(address, value);
                        address.offset = offset;
                        address.addressVariant = AddressingVariants.REGISTERS;
                        address.address = oldAddress;
                    }
                    catch (Exception exception) {
                        LogUtils.getLogger().info("address setting failed: " + exception.toString());
                    }
                } else if (address.addressVariant == AddressingVariants.VALUE && address.useValueAsAddress) {
                    int oldAddress = address.address;
                    address.useValueAsAddress = false;
                    address.address = this.getAbsoluteAdress(address);
                    int offset = address.offset;
                    address.offset = 0;
                    short memoryAddress = (short)this.getValueFromAddress(address);
                    address.offset = offset;
                    address.address = oldAddress;
                    address.useValueAsAddress = true;
                    if (!address.IsAddress16bit) {
                        MicrocontrollerBlockEntity.this.memory.setValue(Integer.valueOf(memoryAddress), (Byte)((byte)value));
                    } else {
                        MicrocontrollerBlockEntity.this.memory.setValue(Integer.valueOf(memoryAddress), (Byte)((byte)(value >>> 8)));
                        MicrocontrollerBlockEntity.this.memory.setValue((Integer)(memoryAddress + 1), (Byte)((byte)(value & 0xFF)));
                    }
                }
            }
        }
    }

    protected class AddressReader {
        private final int instructionSize;
        MicrocontrollerBlockEntity microprocessorBE;
        int addressInfoOffset;
        public Address firstAddress;
        public Address secondAddress;

        public AddressReader(MicrocontrollerBlockEntity microprocessorBE, int instructionSize, int addressInfoOffset) {
            this.firstAddress = new Address();
            this.secondAddress = new Address();
            this.microprocessorBE = microprocessorBE;
            this.instructionSize = instructionSize;
            this.addressInfoOffset = addressInfoOffset;
        }

        public void calculateAddressTypes() {
            byte[] memorySeq = this.microprocessorBE.memory.getMemorySequence((short)(this.microprocessorBE.registerIp + this.microprocessorBE.codeSegment), (short)this.instructionSize);
            if ((memorySeq[this.addressInfoOffset] >>> 1 & 1) == AddressingVariants.REGISTERS.getAddressType()) {
                this.firstAddress.addressVariant = AddressingVariants.REGISTERS;
            } else {
                this.firstAddress.addressVariant = AddressingVariants.VALUE;
                this.firstAddress.IsAddress16bit = true;
            }
            this.firstAddress.offset = memorySeq[this.addressInfoOffset] >>> 6 & 3;
            boolean bl = this.firstAddress.useValueAsAddress = (memorySeq[this.addressInfoOffset] >>> 3 & 1) == 1;
            if ((memorySeq[this.addressInfoOffset] & 1) == AddressingVariants.REGISTERS.getAddressType()) {
                this.secondAddress.addressVariant = AddressingVariants.REGISTERS;
            } else {
                this.secondAddress.addressVariant = AddressingVariants.VALUE;
                this.secondAddress.IsAddress16bit = true;
            }
            this.secondAddress.offset = memorySeq[this.addressInfoOffset] >>> 4 & 3;
            this.secondAddress.useValueAsAddress = (memorySeq[this.addressInfoOffset] >>> 2 & 1) == 1;
            this.firstAddress.address = (Byte.toUnsignedInt(memorySeq[this.addressInfoOffset + 1]) << 8) + Byte.toUnsignedInt(memorySeq[this.addressInfoOffset + 2]);
            this.secondAddress.address = (Byte.toUnsignedInt(memorySeq[this.addressInfoOffset + 3]) << 8) + Byte.toUnsignedInt(memorySeq[this.addressInfoOffset + 4]);
            if (this.firstAddress.addressVariant == AddressingVariants.REGISTERS) {
                boolean bl2 = this.firstAddress.IsAddress16bit = !MicrocontrollerBlockEntity.this.lowBitRegisters.containsKey((byte)this.firstAddress.address) && !MicrocontrollerBlockEntity.this.highBitRegisters.containsKey((byte)this.firstAddress.address);
            }
            if (this.secondAddress.addressVariant == AddressingVariants.REGISTERS) {
                this.secondAddress.IsAddress16bit = !MicrocontrollerBlockEntity.this.lowBitRegisters.containsKey((byte)this.secondAddress.address) && !MicrocontrollerBlockEntity.this.highBitRegisters.containsKey((byte)this.secondAddress.address);
            }
        }
    }
}

