/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.inventory;

import com.abadon.minecontrollers.MinecontrollersBlocks;
import com.abadon.minecontrollers.blocks.dumper.CodeDumper;
import com.abadon.minecontrollers.inventory.ModMenu;
import com.abadon.minecontrollers.network.packets.DumperPacket;
import com.abadon.minecontrollers.utils.BookMenuUtils;
import com.abadon.minecontrollers.utils.BookPagesWriter;
import com.abadon.minecontrollers.utils.MicrocontrollerMemory;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class DumperMenu
extends AbstractContainerMenu {
    protected Inventory inventory;
    protected CraftingContainer container;
    protected ContainerLevelAccess levelAccess;
    protected Slot controllerSlot;
    protected Slot bookSlot;
    protected Slot outputSlot;
    private static DumperMenu lastOpenedDumperMenu = null;
    private static final SimpleChannel BOOK_GETTER_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecontrollers", (String)"dumper_menu_getter_channel"), () -> "", versionFromServer -> true, versionFromClient -> true);

    public static void registerNetworkChannel() {
        BOOK_GETTER_CHANNEL.registerMessage(0, DumperPacket.class, (pack, buffer) -> buffer.writeInt(pack.from).writeInt(pack.to), buffer -> new DumperPacket(buffer.readInt(), buffer.readInt()), (pack, context) -> {
            if (lastOpenedDumperMenu != null) {
                lastOpenedDumperMenu.doDump(pack.from, pack.to);
            }
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    protected DumperMenu(@Nullable MenuType<?> p_38851_, int p_38852_) {
        super(p_38851_, p_38852_);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ItemStack controllerItem = ((Slot)this.f_38839_.get(0)).m_7993_();
        ItemStack bookItem = ((Slot)this.f_38839_.get(1)).m_7993_();
        ItemStack outputItem = ((Slot)this.f_38839_.get(2)).m_7993_();
        if (player.m_6084_()) {
            if (controllerItem != ItemStack.f_41583_) {
                player.m_150109_().m_150079_(controllerItem);
            }
            if (bookItem != ItemStack.f_41583_) {
                player.m_150109_().m_150079_(bookItem);
            }
            if (outputItem != ItemStack.f_41583_) {
                player.m_150109_().m_150079_(outputItem);
            }
        } else {
            if (controllerItem != ItemStack.f_41583_) {
                player.m_36176_(controllerItem, false);
            }
            if (bookItem != ItemStack.f_41583_) {
                player.m_36176_(bookItem, false);
            }
            if (outputItem != ItemStack.f_41583_) {
                player.m_36176_(outputItem, false);
            }
        }
    }

    public void doDump(int start, int bytes) {
        if (this.controllerSlot.m_6657_() && this.bookSlot.m_6657_() && !this.outputSlot.m_6657_()) {
            ItemStack dumpedBook = this.bookSlot.m_7993_().m_41777_();
            BookPagesWriter writer = new BookPagesWriter();
            CompoundTag tag = this.controllerSlot.m_7993_().m_41783_();
            try {
                CompoundTag beTag = tag.m_128469_("BlockEntityTag");
                CompoundTag memoryTag = beTag.m_128469_("memory");
                MicrocontrollerMemory memory = new MicrocontrollerMemory();
                for (String address : memoryTag.m_128431_()) {
                    memory.setValue(Integer.valueOf(address), memoryTag.m_128445_(address));
                }
                writer.writeBook(dumpedBook, new CodeDumper().build(memory.getMemorySequence(start, bytes)));
                this.container.m_6836_(1, ItemStack.f_41583_);
                this.container.m_6836_(2, dumpedBook);
            }
            catch (RuntimeException exception) {
                LogUtils.getLogger().info(exception.toString());
            }
        }
    }

    public void sendDumpPacket(DumperPacket pack) {
        BOOK_GETTER_CHANNEL.sendToServer((Object)pack);
    }

    public ItemStack m_7648_(Player player, int id) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(id);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (id < this.container.m_6643_() ? !this.m_38903_(itemstack1, this.container.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public DumperMenu(int value, Inventory inventory) {
        this(value, inventory, ContainerLevelAccess.f_39287_);
    }

    public DumperMenu(int value, Inventory inventory, ContainerLevelAccess levelAccess) {
        this(value, inventory, levelAccess, (MenuType)ModMenu.DUMPER_MENU_MENU_TYPE.get());
    }

    public DumperMenu(int value, Inventory inventory, ContainerLevelAccess levelAccess, MenuType<?> menuType) {
        this(menuType, value);
        int i;
        this.inventory = inventory;
        this.levelAccess = levelAccess;
        this.container = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 1);
        if (!inventory.f_35978_.m_9236_().f_46443_) {
            lastOpenedDumperMenu = this;
        }
        this.controllerSlot = new Slot((Container)this.container, 0, 44, 23){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_41720_().m_7968_().m_41720_().equals(MinecontrollersBlocks.blockItems.get("microcontroller").get());
            }
        };
        this.bookSlot = new Slot((Container)this.container, 1, 44, 49){

            public boolean m_5857_(ItemStack itemStack) {
                return BookMenuUtils.canPlaceBookIntoContainer(itemStack);
            }
        };
        this.outputSlot = new Slot((Container)this.container, 2, 116, 35){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }
        };
        this.m_38897_(this.controllerSlot);
        this.m_38897_(this.bookSlot);
        this.m_38897_(this.outputSlot);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }
}

