/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.utils;

import com.abadon.minecontrollers.utils.IncorrectTokenValueException;
import com.abadon.minecontrollers.utils.MathToken;

class OperatorToken
extends MathToken {
    private String availableOperators = "+-*/^&|";

    public OperatorToken() {
        super(null);
    }

    private OperatorToken(String value) {
        super(value);
        boolean isValid = false;
        for (char operator : this.availableOperators.toCharArray()) {
            if (!value.equals(String.valueOf(operator))) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            throw new IncorrectTokenValueException(value + "isn't an operator");
        }
    }

    public int getPriority() {
        switch (this.value) {
            case "&": {
                return 0;
            }
            case "|": {
                return 0;
            }
            case "+": {
                return 1;
            }
            case "-": {
                return 1;
            }
            case "*": {
                return 2;
            }
            case "/": {
                return 2;
            }
            case "^": {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public MathToken getToken(String value) {
        return new OperatorToken(value);
    }
}

