/*
 * Decompiled with CFR 0.152.
 */
package com.abadon.minecontrollers.utils;

import com.abadon.minecontrollers.utils.BracketToken;
import com.abadon.minecontrollers.utils.IncorrectTokenValueException;
import com.abadon.minecontrollers.utils.MathToken;
import com.abadon.minecontrollers.utils.OperatorToken;
import com.abadon.minecontrollers.utils.ValueToken;
import java.util.ArrayList;
import java.util.List;

class Tokenizer {
    private String source;
    public final ArrayList<MathToken> TOKENS = new ArrayList<MathToken>(List.of(new MathToken[]{new ValueToken(), new OperatorToken(), new BracketToken()}));

    public Tokenizer(String source) {
        this.source = source;
    }

    public ArrayList<MathToken> getTokens() {
        int begin = 0;
        MathToken parsedToken = null;
        ArrayList<MathToken> parsedTokens = new ArrayList<MathToken>();
        for (int i = begin + 1; i <= this.source.length(); ++i) {
            boolean succes = false;
            for (MathToken token : this.TOKENS) {
                try {
                    parsedToken = token.getToken(this.source.substring(begin, i));
                    succes = true;
                    break;
                }
                catch (IncorrectTokenValueException incorrectTokenValueException) {
                }
            }
            if (!succes) {
                if (parsedToken != null) {
                    begin = i - 1;
                    --i;
                    parsedTokens.add(parsedToken);
                }
                parsedToken = null;
            }
            if (i != this.source.length() || parsedToken == null) continue;
            parsedTokens.add(parsedToken);
        }
        return parsedTokens;
    }
}

