/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.mixin;

import net.minecraft.client.render.block.model.BlockModelBed;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicBed;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockModelBed.class})
public abstract class BlockModelBedMixin<T extends BlockLogic>
extends BlockModelStandard<T> {
    @Unique
    private static final IconCoordinate[][] bedTextures = new IconCoordinate[16][5];
    @Unique
    private static final IconCoordinate bottomTexture = TextureRegistry.getTexture((String)"minecraft:block/planks/oak");
    @Unique
    private static final IconCoordinate headFrontTexture = TextureRegistry.getTexture((String)"minecraft:block/bed/head_front");
    @Unique
    private static final int FOOT_FRONT = 0;
    @Unique
    private static final int FOOT_SIDE = 1;
    @Unique
    private static final int FOOT_TOP = 2;
    @Unique
    private static final int HEAD_SIDE = 3;
    @Unique
    private static final int HEAD_TOP = 4;

    public BlockModelBedMixin(Block<T> block) {
        super(block);
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.BOTTOM) {
            return bottomTexture;
        }
        DyeColor color = DyeColor.colorFromBlockMeta((int)(data >> 4 & 0xF));
        int k = BlockLogicBed.getDirection((int)data);
        int l = BlockLogicBed.bedDirection[k][side.getId()];
        if (BlockLogicBed.isBlockFootOfBed((int)data)) {
            if (l == 2) {
                return headFrontTexture;
            }
            return l != 5 && l != 4 ? bedTextures[color.blockMeta][4] : bedTextures[color.blockMeta][3];
        }
        if (l == 3) {
            return bedTextures[color.blockMeta][0];
        }
        return l != 5 && l != 4 ? bedTextures[color.blockMeta][2] : bedTextures[color.blockMeta][1];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelBedMixin.bedTextures[c.blockMeta] = new IconCoordinate[5];
            BlockModelBedMixin.bedTextures[c.blockMeta][0] = TextureRegistry.getTexture((String)(c == DyeColor.RED ? "minecraft:block/bed/foot_front" : "dyables:block/bed/" + c.colorID + "/foot_front"));
            BlockModelBedMixin.bedTextures[c.blockMeta][1] = TextureRegistry.getTexture((String)(c == DyeColor.RED ? "minecraft:block/bed/foot_side" : "dyables:block/bed/" + c.colorID + "/foot_side"));
            BlockModelBedMixin.bedTextures[c.blockMeta][2] = TextureRegistry.getTexture((String)(c == DyeColor.RED ? "minecraft:block/bed/foot_top" : "dyables:block/bed/" + c.colorID + "/foot_top"));
            BlockModelBedMixin.bedTextures[c.blockMeta][3] = TextureRegistry.getTexture((String)(c == DyeColor.RED ? "minecraft:block/bed/head_side" : "dyables:block/bed/" + c.colorID + "/head_side"));
            BlockModelBedMixin.bedTextures[c.blockMeta][4] = TextureRegistry.getTexture((String)(c == DyeColor.RED ? "minecraft:block/bed/head_top" : "dyables:block/bed/" + c.colorID + "/head_top"));
        }
    }
}

