/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.mixin;

import horiuchi.dyables.DyablesBlocks;
import horiuchi.dyables.DyablesItems;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.menu.MenuInventoryCreative;
import net.minecraft.core.util.helper.DyeColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MenuInventoryCreative.class}, remap=false)
public abstract class CreativeMenuMixin {
    @Shadow
    public static List<ItemStack> creativeItems;
    @Shadow
    public static int creativeItemsCount;

    @Unique
    private static int RemapCreativeId(int Id) {
        if (Id == DyablesBlocks.BOOKSHELF_PLANKS_OAK_PAINTED.id()) {
            return Blocks.BOOKSHELF_PLANKS_OAK.id();
        }
        if (Id == DyablesBlocks.GLASS_PAINTED.id()) {
            return Blocks.GLASS.id();
        }
        if (Id == DyablesBlocks.GLASS_TRAPDOOR_PAINTED.id()) {
            return Blocks.TRAPDOOR_GLASS.id();
        }
        if (Id == DyablesBlocks.WORKBENCH_PAINTED.id()) {
            return Blocks.WORKBENCH.id();
        }
        if (Id == DyablesItems.DOOR_GLASS_PAINTED.id) {
            return Items.DOOR_GLASS.id;
        }
        return Id;
    }

    @Unique
    private static void AddCreativeEntry(int Id, int metadata) {
        if (creativeItems.stream().anyMatch(ItemStack2 -> ItemStack2.getMetadata() == metadata && ItemStack2.getItem().id == Id)) {
            return;
        }
        creativeItems.add(new ItemStack(Id, 1, metadata));
        ++creativeItemsCount;
    }

    @Inject(method={"<clinit>()V"}, at={@At(value="TAIL")})
    private static void AddDyablesItems(CallbackInfo ci) {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            CreativeMenuMixin.AddCreativeEntry(DyablesBlocks.BOOKSHELF_PLANKS_OAK_PAINTED.id(), c.blockMeta);
            CreativeMenuMixin.AddCreativeEntry(DyablesBlocks.GLASS_PAINTED.id(), c.blockMeta);
            CreativeMenuMixin.AddCreativeEntry(DyablesBlocks.GLASS_TRAPDOOR_PAINTED.id(), c.blockMeta << 4);
            CreativeMenuMixin.AddCreativeEntry(DyablesBlocks.WORKBENCH_PAINTED.id(), c.blockMeta);
            CreativeMenuMixin.AddCreativeEntry(DyablesItems.DOOR_GLASS_PAINTED.id, c.itemMeta);
            CreativeMenuMixin.AddCreativeEntry(Items.BED.id, c.itemMeta);
            CreativeMenuMixin.AddCreativeEntry(Items.SEAT.id, c.itemMeta);
        }
        creativeItems.sort(Comparator.comparingInt(a -> CreativeMenuMixin.RemapCreativeId(a.getItem().id)).thenComparingInt(ItemStack::getMetadata));
    }
}

