/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.models;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.block.model.BlockModelDoor;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;

@Environment(value=EnvType.CLIENT)
public class BlockModelGlassDoorPainted<T extends BlockLogicDoor>
extends BlockModelDoor<T> {
    public static final IconCoordinate[] doorBottomTextures = new IconCoordinate[16];
    public static final IconCoordinate[] doorTopTextures = new IconCoordinate[16];
    public static final IconCoordinate[] frameTopTextures = new IconCoordinate[16];
    private final boolean isTop;

    public BlockModelGlassDoorPainted(Block<T> block, boolean isTop) {
        super(block);
        this.isTop = isTop;
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4 & 0xF;
        if (side.getAxis() == Axis.Y) {
            return frameTopTextures[color];
        }
        return this.isTop ? doorTopTextures[color] : doorBottomTextures[color];
    }

    protected boolean shouldFlipTexture(Side side, int meta) {
        return false;
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelGlassDoorPainted.doorTopTextures[c.blockMeta] = TextureRegistry.getTexture((String)("dyables:block/door/glass_" + c.colorID + "/top"));
            BlockModelGlassDoorPainted.doorBottomTextures[c.blockMeta] = TextureRegistry.getTexture((String)("dyables:block/door/glass_" + c.colorID + "/bottom"));
            BlockModelGlassDoorPainted.frameTopTextures[c.blockMeta] = TextureRegistry.getTexture((String)("dyables:block/glass/glass_" + c.colorID));
        }
    }
}

