/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.models;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ItemModelLeatherArmorPainted
extends ItemModelStandard {
    public static IconCoordinate[] armorIcons = new IconCoordinate[4];
    private final int armorType;
    private final DyeColor dyeColor;

    public ItemModelLeatherArmorPainted(Item item, int armorType, DyeColor dyeColor) {
        super(item, "dyables");
        this.armorType = armorType;
        this.dyeColor = dyeColor;
    }

    @NotNull
    public IconCoordinate getIcon(Entity entity, ItemStack itemStack) {
        return armorIcons[this.armorType];
    }

    public int getColor(ItemStack stack) {
        return this.dyeColor.color.getARGB();
    }

    static {
        ItemModelLeatherArmorPainted.armorIcons[0] = TextureRegistry.getTexture((String)"dyables:item/armor_boots_leather_painted");
        ItemModelLeatherArmorPainted.armorIcons[1] = TextureRegistry.getTexture((String)"dyables:item/armor_leggings_leather_painted");
        ItemModelLeatherArmorPainted.armorIcons[2] = TextureRegistry.getTexture((String)"dyables:item/armor_chestplate_leather_painted");
        ItemModelLeatherArmorPainted.armorIcons[3] = TextureRegistry.getTexture((String)"dyables:item/armor_helmet_leather_painted");
    }
}

