/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables;

import horiuchi.dyables.DyablesBlocks;
import horiuchi.dyables.DyablesItems;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryDyeing;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryUndyeing;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DyeColor;
import turniplabs.halplibe.helper.RecipeBuilder;

public class DyablesRecipies {
    private static void registerItemGroup(String groupName, List<ItemStack> groupList) {
        Registries.ITEM_GROUPS.register("dyables:" + groupName, groupList);
    }

    private static void registerBlockDyeRecipes(String recipeKey, String groupName, Block<?> blockDyed, Block<?> blockUndyed, boolean useUpperMeta) {
        Registries.RECIPES.addCustomRecipe("dyables:workbench/" + recipeKey + "_dyeing", (RecipeEntryBase)new RecipeEntryDyeing(new RecipeSymbol("dyables:" + groupName), blockDyed.getDefaultStack(), useUpperMeta, false));
        Registries.RECIPES.addCustomRecipe("dyables:workbench/" + recipeKey + "_undyeing", (RecipeEntryBase)new RecipeEntryUndyeing(new RecipeSymbol("dyables:" + groupName), blockUndyed.getDefaultStack()));
    }

    private static void registerItemDyeRecipes(String recipeKey, String groupName, Item itemDyed, Item itemUndyed, boolean useItemMeta) {
        Registries.RECIPES.addCustomRecipe("dyables:workbench/" + recipeKey + "_dyeing", (RecipeEntryBase)new RecipeEntryDyeing(new RecipeSymbol("dyables:" + groupName), itemDyed.getDefaultStack(), false, useItemMeta));
        Registries.RECIPES.addCustomRecipe("dyables:workbench/" + recipeKey + "_undyeing", (RecipeEntryBase)new RecipeEntryUndyeing(new RecipeSymbol("dyables:" + groupName), itemUndyed.getDefaultStack()));
    }

    public static void initializeNamespaces() {
        RecipeBuilder.initNameSpace((String)"dyables");
        List bookshelves = Registries.stackListOf((Object[])new Object[]{Blocks.BOOKSHELF_PLANKS_OAK});
        List workbenches = Registries.stackListOf((Object[])new Object[]{Blocks.WORKBENCH});
        List glass = Registries.stackListOf((Object[])new Object[]{Blocks.GLASS});
        List glassDoors = Registries.stackListOf((Object[])new Object[]{Items.DOOR_GLASS});
        List glassTrapdoors = Registries.stackListOf((Object[])new Object[]{Blocks.TRAPDOOR_GLASS});
        List beds = Registries.stackListOf((Object[])new Object[]{Items.BED});
        List seats = Registries.stackListOf((Object[])new Object[]{Items.SEAT});
        for (DyeColor c : DyeColor.values()) {
            bookshelves.add(new ItemStack(DyablesBlocks.BOOKSHELF_PLANKS_OAK_PAINTED, 1, c.blockMeta));
            workbenches.add(new ItemStack(DyablesBlocks.WORKBENCH_PAINTED, 1, c.blockMeta));
            glass.add(new ItemStack(DyablesBlocks.GLASS_PAINTED, 1, c.blockMeta));
            glassDoors.add(new ItemStack(DyablesItems.DOOR_GLASS_PAINTED, 1, c.itemMeta));
            glassTrapdoors.add(new ItemStack(DyablesBlocks.GLASS_TRAPDOOR_PAINTED, 1, c.blockMeta << 4));
            beds.add(new ItemStack(Items.BED, 1, c.itemMeta));
            seats.add(new ItemStack(Items.SEAT, 1, c.itemMeta));
        }
        DyablesRecipies.registerItemGroup("bookshelves", bookshelves);
        DyablesRecipies.registerItemGroup("workbench", workbenches);
        DyablesRecipies.registerItemGroup("glass", glass);
        DyablesRecipies.registerItemGroup("glass_doors", glassDoors);
        DyablesRecipies.registerItemGroup("glass_trapdoors", glassTrapdoors);
        DyablesRecipies.registerItemGroup("beds", beds);
        DyablesRecipies.registerItemGroup("seats", seats);
    }

    public static void initializeRecipes() {
        RecipeBuilder.ModifyWorkbench((String)"minecraft").removeRecipe("bookshelf");
        RecipeBuilder.ModifyWorkbench((String)"minecraft").removeRecipe("workbench");
        DyablesRecipies.registerBlockDyeRecipes("bookshelf", "bookshelves", DyablesBlocks.BOOKSHELF_PLANKS_OAK_PAINTED, Blocks.BOOKSHELF_PLANKS_OAK, false);
        DyablesRecipies.registerBlockDyeRecipes("workbench", "workbench", DyablesBlocks.WORKBENCH_PAINTED, Blocks.WORKBENCH, false);
        DyablesRecipies.registerBlockDyeRecipes("glass", "glass", DyablesBlocks.GLASS_PAINTED, Blocks.GLASS, false);
        DyablesRecipies.registerItemDyeRecipes("glass_door", "glass_doors", DyablesItems.DOOR_GLASS_PAINTED, Items.DOOR_GLASS, true);
        DyablesRecipies.registerBlockDyeRecipes("glass_trapdoor", "glass_trapdoors", DyablesBlocks.GLASS_TRAPDOOR_PAINTED, Blocks.TRAPDOOR_GLASS, true);
        DyablesRecipies.registerItemDyeRecipes("bed", "beds", Items.BED, Items.BED, false);
        DyablesRecipies.registerItemDyeRecipes("seat", "seats", Items.SEAT, Items.SEAT, false);
        RecipeBuilder.Shaped((String)"dyables").setShape(new String[]{"xx", "xx"}).addInput('x', (IItemConvertible)Blocks.PLANKS_OAK).create("workbench", new ItemStack(Blocks.WORKBENCH, 1));
        RecipeBuilder.Shaped((String)"dyables").setShape(new String[]{"xxx", "ppp", "xxx"}).addInput('x', (IItemConvertible)Blocks.PLANKS_OAK).addInput('p', (IItemConvertible)Items.BOOK).create("bookshelf", new ItemStack(Blocks.BOOKSHELF_PLANKS_OAK, 1));
        for (DyeColor c : DyeColor.itemOrderedColors()) {
            RecipeBuilder.Shaped((String)"dyables").setShape(new String[]{"xx", "xx"}).addInput('x', (IItemConvertible)Blocks.PLANKS_OAK_PAINTED, c.itemMeta).create(DyeColor.colorFromBlockMeta((int)c.itemMeta).colorID + "_workbench", new ItemStack(DyablesBlocks.WORKBENCH_PAINTED, 1, c.itemMeta));
            RecipeBuilder.Shaped((String)"dyables").setShape(new String[]{"xxx", "ppp", "xxx"}).addInput('x', (IItemConvertible)Blocks.PLANKS_OAK_PAINTED, c.itemMeta).addInput('p', (IItemConvertible)Items.BOOK).create(DyeColor.colorFromBlockMeta((int)c.itemMeta).colorID + "_bookshelf", new ItemStack(DyablesBlocks.BOOKSHELF_PLANKS_OAK_PAINTED, 1, c.itemMeta));
            RecipeBuilder.Shaped((String)"dyables").setShape(new String[]{"xx", "xx", "xx"}).addInput('x', DyablesBlocks.GLASS_PAINTED, c.blockMeta).create(DyeColor.colorFromItemMeta((int)c.itemMeta).colorID + "_glass_door", new ItemStack(DyablesItems.DOOR_GLASS_PAINTED, 1, c.itemMeta));
            RecipeBuilder.Shaped((String)"dyables").setShape(new String[]{"xxx"}).addInput('x', DyablesBlocks.GLASS_PAINTED, c.blockMeta).create(DyeColor.colorFromItemMeta((int)c.itemMeta).colorID + "_glass_trapdoor", new ItemStack(DyablesBlocks.GLASS_TRAPDOOR_PAINTED, 1, c.blockMeta << 4));
        }
    }
}

