/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.mixin;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicBed;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockLogicBed.class})
public abstract class BlockLogicBedMixin
extends BlockLogic
implements IPainted {
    @Unique
    private static final int MASK_COLOR = 240;
    @Unique
    private static final int SHIFT_COLOR = 4;

    public BlockLogicBedMixin(Block<?> block, Material material) {
        super(block, material);
    }

    public String getLanguageKey(int meta) {
        return super.getLanguageKey(meta) + "." + this.fromMetadata((int)meta).colorID;
    }

    @Unique
    protected void paintOtherHalf(World world, int x, int y, int z, DyeColor color) {
        int otherHalfZ;
        int metadata = world.getBlockMetadata(x, y, z);
        int direction = BlockLogicBed.getDirection((int)metadata);
        boolean footOfBed = BlockLogicBed.isBlockFootOfBed((int)metadata);
        int otherHalfX = footOfBed ? x - BlockLogicBed.headBlockToFootBlockMap[direction].getOffsetX() : x + BlockLogicBed.headBlockToFootBlockMap[direction].getOffsetX();
        int n = otherHalfZ = footOfBed ? z - BlockLogicBed.headBlockToFootBlockMap[direction].getOffsetZ() : z + BlockLogicBed.headBlockToFootBlockMap[direction].getOffsetZ();
        if (world.getBlockId(otherHalfX, y, otherHalfZ) == this.block.id()) {
            world.setBlockMetadataWithNotify(otherHalfX, y, otherHalfZ, world.getBlockMetadata(otherHalfX, y, otherHalfZ) & 0xFFFFFF0F | (color.blockMeta & 0xF) << 4);
        }
    }

    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return stack.getMetadata() & 0xF;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.BED, 1, this.fromMetadata((int)meta).blockMeta)};
    }

    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((int)(meta >> 4 & 0xF));
    }

    public int toMetadata(DyeColor color) {
        return (color.blockMeta & 0xF) << 4;
    }

    public int stripColorFromMetadata(int meta) {
        return meta & 0xF;
    }

    public void setColor(World world, int x, int y, int z, DyeColor color) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockMetadataWithNotify(x, y, z, meta & 0xFFFFFF0F | (color.blockMeta & 0xF) << 4);
        this.paintOtherHalf(world, x, y, z, color);
    }

    public void removeDye(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockMetadataWithNotify(x, y, z, meta & 0xF);
    }
}

