/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.mixin;

import horiuchi.dyables.DyablesItems;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.BlockLogicDoorPainted;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BlockLogicDoorPainted.class})
public abstract class BlockLogicDoorPaintedMixin
extends BlockLogicDoor
implements IPainted {
    public BlockLogicDoorPaintedMixin(Block<?> block, Material material, boolean isTop, boolean requireTool, @Nullable Supplier<Item> droppedItem) {
        super(block, material, isTop, requireTool, droppedItem);
    }

    public String getLanguageKey(int meta) {
        return super.getLanguageKey(meta) + "." + this.fromMetadata((int)meta).colorID;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this.block.getMaterial() == Material.wood ? Items.DOOR_OAK_PAINTED : DyablesItems.DOOR_GLASS_PAINTED, 1, 15 - (meta >> 4 & 0xF))};
    }

    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((int)(meta >> 4 & 0xF));
    }

    public int toMetadata(DyeColor color) {
        return color.blockMeta << 4;
    }

    public int stripColorFromMetadata(int meta) {
        return meta & 0xF;
    }

    public void removeDye(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        int top_block_id = this.block.getMaterial() == Material.wood ? Blocks.DOOR_PLANKS_OAK_TOP.id() : Blocks.DOOR_GLASS_TOP.id();
        int bottom_block_id = this.block.getMaterial() == Material.wood ? Blocks.DOOR_PLANKS_OAK_BOTTOM.id() : Blocks.DOOR_GLASS_BOTTOM.id();
        world.setBlockAndMetadataWithNotify(x, y, z, this.isTop ? top_block_id : bottom_block_id, meta & 0xF);
        if (this.isTop) {
            world.setBlockAndMetadataWithNotify(x, y - 1, z, bottom_block_id, meta & 0xF);
        } else {
            world.setBlockAndMetadataWithNotify(x, y + 1, z, top_block_id, meta & 0xF);
        }
    }
}

