/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.mixin;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSeat;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySeat;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BlockLogicSeat.class})
public abstract class BlockLogicSeatMixin
extends BlockLogic
implements IPainted {
    public BlockLogicSeatMixin(Block<?> block, Material material) {
        super(block, Material.wood);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
        block.withEntity(() -> new TileEntitySeat(block));
    }

    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return stack.getMetadata() & 0xF;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = new ItemStack(Items.SEAT, 1, meta);
        } else {
            itemStackArray = null;
        }
        return itemStackArray;
    }

    public String getLanguageKey(int meta) {
        return super.getLanguageKey(meta) + "." + this.fromMetadata((int)meta).colorID;
    }

    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((int)meta);
    }

    public int toMetadata(DyeColor color) {
        return color.blockMeta;
    }

    public int stripColorFromMetadata(int meta) {
        return 0;
    }

    public void removeDye(World world, int x, int y, int z) {
        world.setBlockMetadataWithNotify(x, y, z, 0);
    }
}

