/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.mixin;

import horiuchi.dyables.DyablesBlocks;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicTrapDoor;
import net.minecraft.core.block.BlockLogicTrapDoorPainted;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BlockLogicTrapDoorPainted.class})
public class BlockLogicTrapDoorPaintedMixin
extends BlockLogicTrapDoor
implements IPainted {
    public BlockLogicTrapDoorPaintedMixin(Block<?> block, Material material) {
        super(block, material);
    }

    public String getLanguageKey(int meta) {
        return super.getLanguageKey(meta) + "." + this.fromMetadata((int)meta).colorID;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this.block.getMaterial() == Material.wood ? Blocks.TRAPDOOR_PLANKS_PAINTED : DyablesBlocks.GLASS_TRAPDOOR_PAINTED, 1, (meta >> 4 & 0xF) << 4)};
    }

    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((int)(meta >> 4 & 0xF));
    }

    public int toMetadata(DyeColor color) {
        return color.blockMeta << 4;
    }

    public int stripColorFromMetadata(int meta) {
        return meta & 0xF;
    }

    public void removeDye(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadataWithNotify(x, y, z, this.block.getMaterial() == Material.wood ? Blocks.TRAPDOOR_PLANKS_OAK.id() : DyablesBlocks.GLASS_TRAPDOOR_PAINTED.id(), meta & 0xF);
    }
}

