/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.mixin;

import net.minecraft.client.render.block.model.BlockModelSeat;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockModelSeat.class})
public abstract class BlockModelSeatMixin<T extends BlockLogic>
extends BlockModelStandard<T> {
    @Unique
    private static final IconCoordinate[][] texCoords = new IconCoordinate[16][2];
    @Unique
    private static final IconCoordinate bottomCoordinate = TextureRegistry.getTexture((String)"minecraft:block/planks/oak");

    public BlockModelSeatMixin(Block<T> block) {
        super(block);
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.TOP) {
            return texCoords[data & 0xF][0];
        }
        if (side == Side.BOTTOM) {
            return bottomCoordinate;
        }
        return texCoords[data & 0xF][1];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelSeatMixin.texCoords[c.blockMeta] = new IconCoordinate[2];
            BlockModelSeatMixin.texCoords[c.blockMeta][0] = TextureRegistry.getTexture((String)(c == DyeColor.RED ? "minecraft:block/seat/top" : "dyables:block/seat/top_" + c.colorID));
            BlockModelSeatMixin.texCoords[c.blockMeta][1] = TextureRegistry.getTexture((String)(c == DyeColor.RED ? "minecraft:block/bed/foot_front" : "dyables:block/bed/" + c.colorID + "/foot_front"));
        }
    }
}

