/*
 * Decompiled with CFR 0.152.
 */
package horiuchi.dyables.models;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;

@Environment(value=EnvType.CLIENT)
public class BlockModelPaintedWorkbench<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static final IconCoordinate[][] texCoords = new IconCoordinate[16][4];

    public BlockModelPaintedWorkbench(Block<T> block) {
        super(block);
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        switch (side) {
            case TOP: {
                return texCoords[data & 0xF][2];
            }
            case BOTTOM: {
                return texCoords[data & 0xF][3];
            }
            case NORTH: 
            case SOUTH: {
                return texCoords[data & 0xF][0];
            }
        }
        return texCoords[data & 0xF][1];
    }

    static {
        for (DyeColor color : DyeColor.blockOrderedColors()) {
            BlockModelPaintedWorkbench.texCoords[color.blockMeta] = new IconCoordinate[4];
            BlockModelPaintedWorkbench.texCoords[color.blockMeta][0] = TextureRegistry.getTexture((String)("dyables:block/workbench/" + color.colorID + "/front"));
            BlockModelPaintedWorkbench.texCoords[color.blockMeta][1] = TextureRegistry.getTexture((String)("dyables:block/workbench/" + color.colorID + "/side"));
            BlockModelPaintedWorkbench.texCoords[color.blockMeta][2] = TextureRegistry.getTexture((String)("dyables:block/workbench/" + color.colorID + "/top"));
            BlockModelPaintedWorkbench.texCoords[color.blockMeta][3] = TextureRegistry.getTexture((String)("minecraft:block/planks/" + color.colorID));
        }
    }
}

