/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages;

import de.theidler.create_mobile_packages.RoboManagerSavedData;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RoboManager {
    public Map<UUID, RoboEntity> robos;
    private RoboManagerSavedData savedData;
    private Level level;

    public RoboManager() {
        this.cleanUp();
    }

    public void markDirty() {
        if (this.savedData != null) {
            this.savedData.setDirty();
        }
    }

    public void tick(Level level) {
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        this.tickRobos(level);
    }

    private synchronized void tickRobos(Level level) {
        Iterator<Map.Entry<UUID, RoboEntity>> it = this.robos.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, RoboEntity> entry = it.next();
            RoboEntity robo = entry.getValue();
            level.guardEntityTick(entity -> {}, (Entity)robo);
            robo.roboMangerTick();
            if (!robo.isRemoved()) continue;
            it.remove();
        }
    }

    public void addRobo(RoboEntity robo) {
        this.robos.put(robo.getUUID(), robo);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void levelLoaded(LevelAccessor level) {
        this.level = (Level)level;
        MinecraftServer server = level.getServer();
        if (server == null || server.overworld() != level) {
            return;
        }
        this.cleanUp();
        this.savedData = null;
        this.loadRoboData(server);
    }

    private void loadRoboData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = RoboManagerSavedData.load(server);
        this.robos = this.savedData.getRobos();
    }

    private void cleanUp() {
        this.robos = new ConcurrentHashMap<UUID, RoboEntity>();
    }
}

