/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import de.theidler.create_mobile_packages.entities.models.RoboBeeModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class DroneEntityRenderer
extends MobRenderer<RoboBeeEntity, RoboBeeModel<RoboBeeEntity>> {
    private static final ResourceLocation TEXTURE = CreateMobilePackages.asResource("textures/entity/robo_bee.png");

    public DroneEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new RoboBeeModel(pContext.bakeLayer(RoboBeeModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(RoboBeeEntity pEntity) {
        return TEXTURE;
    }

    public void render(RoboBeeEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        ItemStack stack = entity.getItemStack();
        PackageStyles.PackageStyle style = DroneEntityRenderer.getStyleFromStack(stack);
        if (style != null) {
            ResourceLocation riggingModel = style.getRiggingModel();
            float riggingOffset = style.riggingOffset();
            float heightScale = entity.getPackageHeightScale().floatValue();
            poseStack.pushPose();
            poseStack.translate(-0.5, (double)(0.0f - (riggingOffset - 5.0f) / 16.0f * heightScale), -0.5);
            poseStack.scale(1.0f, heightScale * 1.0f, 1.0f);
            ModelManager modelManager = Minecraft.getInstance().getModelManager();
            BakedModel bakedModel = modelManager.getModel(ModelResourceLocation.standalone((ResourceLocation)riggingModel));
            Minecraft.getInstance().getItemRenderer().renderModelLists(bakedModel, ItemStack.EMPTY, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer.getBuffer(ItemBlockRenderTypes.getRenderType((ItemStack)ItemStack.EMPTY, (boolean)true)));
            poseStack.popPose();
            if (!stack.isEmpty() && PackageItem.isPackage((ItemStack)stack)) {
                poseStack.pushPose();
                poseStack.translate(0.0, (double)(0.0f - (riggingOffset - 1.0f) / 16.0f * heightScale), 0.0);
                poseStack.scale(4.0f, heightScale * 4.0f, 4.0f);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
                poseStack.popPose();
            }
        }
    }

    public static PackageStyles.PackageStyle getStyleFromStack(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        for (PackageStyles.PackageStyle style : PackageStyles.STYLES) {
            if (!style.getItemId().equals((Object)itemId)) continue;
            return style;
        }
        return null;
    }
}

