/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.AdventureUtil;
import de.theidler.create_mobile_packages.index.CMPPackets;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTicker;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SendPackage
implements ServerboundPacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, SendPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)PackageOrderWithCrafts.STREAM_CODEC, packet -> packet.order, (StreamCodec)ByteBufCodecs.STRING_UTF8, packet -> packet.address, SendPackage::new);
    private final PackageOrderWithCrafts order;
    private final String address;

    public SendPackage(PackageOrderWithCrafts order, String address) {
        this.order = order;
        this.address = address;
    }

    protected void applySettings(ServerPlayer player) {
        PortableStockTicker portableStockTicker;
        if (!this.order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(player.level(), (Vec3i)player.blockPosition());
            AllAdvancements.STOCK_TICKER.awardTo((Player)player);
            WiFiEffectPacket.send((Level)player.level(), (BlockPos)player.blockPosition());
        }
        if ((portableStockTicker = PortableStockTicker.find(player.getInventory())) != null) {
            portableStockTicker.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, this.order, null, this.address, (Player)player);
        }
    }

    public void handle(ServerPlayer player) {
        if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
            return;
        }
        Level world = player.level();
        if (!world.isLoaded(player.blockPosition())) {
            return;
        }
        this.applySettings(player);
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return CMPPackets.LOGISTICS_PACKAGE_REQUEST;
    }
}

