/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.robo_bee;

import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RoboBeeItem
extends Item {
    public RoboBeeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext context) {
        RoboBeeEntity roboBee;
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack offhandItem = player.getOffhandItem();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        ItemStack packageItem = ItemStack.EMPTY;
        if (PackageItem.isPackage((ItemStack)offhandItem) && ((Boolean)CMPConfigs.server().allowRoboBeeSpawnPackageTransport.get()).booleanValue()) {
            packageItem = offhandItem.copy();
            player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
        if (!(roboBee = new RoboBeeEntity(level, packageItem, null, pos)).getItemStack().isEmpty()) {
            roboBee.setPackageHeightScale(1.0f);
        }
        level.addFreshEntity((Entity)roboBee);
        roboBee.setRequest(false);
        context.getItemInHand().shrink(1);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        return InteractionResultHolder.pass((Object)pPlayer.getItemInHand(pHand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.create_mobile_packages.robo_bee.robo_bee").withStyle(ChatFormatting.GRAY));
        if (((Boolean)CMPConfigs.server().allowRoboBeeSpawnPackageTransport.get()).booleanValue()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.create_mobile_packages.robo_bee.package_transport").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

