/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages;

import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.blocks.bee_port.ModCapabilities;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class CMPHelper {
    public static Vec3 readVec3FromTag(CompoundTag tag, String key) {
        double x = tag.m_128459_(key + "X");
        double y = tag.m_128459_(key + "Y");
        double z = tag.m_128459_(key + "Z");
        return new Vec3(x, y, z);
    }

    public static CompoundTag writeVec3ToTag(CompoundTag tag, String key, Vec3 vec) {
        tag.m_128347_(key + "X", vec.f_82479_);
        tag.m_128347_(key + "Y", vec.f_82480_);
        tag.m_128347_(key + "Z", vec.f_82481_);
        return tag;
    }

    public static boolean isWithinRange(BlockPos targetPos, BlockPos originPos) {
        int maxDistance = (Integer)CMPConfigs.server().beeMaxDistance.get();
        if (targetPos == null || originPos == null) {
            return false;
        }
        if (maxDistance == -1) {
            return true;
        }
        return targetPos.m_123331_((Vec3i)originPos) <= (double)(maxDistance * maxDistance);
    }

    public static BeePortBlockEntity getClosestBeePort(Level level, String address, BlockPos origin, VirtualRobo entity, UUID logisticsNetworkId) {
        BeePortBlockEntity[] closest = new BeePortBlockEntity[]{null};
        level.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> {
            ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAllByNetwork(logisticsNetworkId));
            if (allBEs.isEmpty()) {
                allBEs.addAll(tracker.getAll());
            }
            allBEs.removeIf(BlockEntity::m_58901_);
            allBEs.removeIf(dpbe -> !CMPHelper.isWithinRange(dpbe.m_58899_(), origin));
            if (address != null && !address.isEmpty()) {
                allBEs.removeIf(dpbe -> !PackageItem.matchAddress((String)address, (String)dpbe.addressFilter));
            }
            allBEs.removeIf(dpbe -> !dpbe.canAcceptEntity(entity, entity != null && !entity.getItemStack().m_41619_()));
            closest[0] = allBEs.stream().min(Comparator.comparingDouble(a -> a.m_58899_().m_123331_((Vec3i)origin))).orElse(null);
        });
        return closest[0];
    }

    public static int calcETA(Vec3 targetPosition, Vec3 currentPosition) {
        if (targetPosition == null || currentPosition == null) {
            return Integer.MAX_VALUE;
        }
        double distance = targetPosition.m_82554_(currentPosition);
        return (int)(distance / (double)((Integer)CMPConfigs.server().beeSpeed.get()).intValue()) + 1;
    }

    public static boolean doesAddressMatchPlayer(Player player, String address) {
        if (address == null) {
            return false;
        }
        String playerName = player.m_7755_().getString();
        int atIndex = address.lastIndexOf(64);
        if (atIndex == -1) {
            return address.equals(playerName);
        }
        return address.substring(atIndex + 1).equals(playerName);
    }
}

