/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.blocks.bee_port;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import de.theidler.create_mobile_packages.CMPHelper;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlock;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortMenu;
import de.theidler.create_mobile_packages.blocks.bee_port.ModCapabilities;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.items.robo_bee.RoboBeeItem;
import de.theidler.create_mobile_packages.robo.BeePortBlockEntityTarget;
import de.theidler.create_mobile_packages.robo.RoboManager;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BeePortBlockEntity
extends PackagePortBlockEntity {
    private final ContainerData data = new SimpleContainerData(2);
    private final ItemStackHandler roboBeeInventory = new ItemStackHandler(1);
    private final IItemHandler handler = new IItemHandler(){

        public int getSlots() {
            return BeePortBlockEntity.this.inventory.getSlots() + BeePortBlockEntity.this.roboBeeInventory.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.getStackInSlot(slot);
            }
            return BeePortBlockEntity.this.roboBeeInventory.getStackInSlot(slot - BeePortBlockEntity.this.inventory.getSlots());
        }

        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41720_() instanceof RoboBeeItem) {
                if (slot >= BeePortBlockEntity.this.inventory.getSlots()) {
                    return BeePortBlockEntity.this.roboBeeInventory.insertItem(slot - BeePortBlockEntity.this.inventory.getSlots(), stack, simulate);
                }
                return stack;
            }
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.extractItem(slot, amount, simulate);
            }
            return BeePortBlockEntity.this.roboBeeInventory.extractItem(slot - BeePortBlockEntity.this.inventory.getSlots(), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.getSlotLimit(slot);
            }
            return BeePortBlockEntity.this.roboBeeInventory.getSlotLimit(slot - BeePortBlockEntity.this.inventory.getSlots());
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.m_41720_() instanceof RoboBeeItem) {
                if (slot >= BeePortBlockEntity.this.inventory.getSlots()) {
                    return BeePortBlockEntity.this.roboBeeInventory.isItemValid(slot - BeePortBlockEntity.this.inventory.getSlots(), stack);
                }
                return false;
            }
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.isItemValid(slot, stack);
            }
            return false;
        }
    };
    public LogisticallyLinkedBehaviour behaviour;
    private int tickCounter = 0;
    private int sendItemThisTime = 0;
    private UUID entityOnTravelID;

    public BeePortBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.itemHandler = LazyOptional.of(() -> this.handler);
    }

    private static void requestRoboEntity(Level level, BlockPos blockPos, UUID logisticsNetworkId) {
        level.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> {
            ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAllByNetwork(logisticsNetworkId));
            allBEs.removeIf(BlockEntity::m_58901_);
            allBEs.removeIf(be -> be.m_58899_().equals((Object)blockPos));
            allBEs.removeIf(be -> be.getRoboBeeInventory().getStackInSlot(0).m_41613_() <= 0);
            allBEs.stream().min(Comparator.comparingDouble(a -> a.m_58899_().m_123331_((Vec3i)blockPos))).ifPresent(target -> target.requestRobo(blockPos));
        });
    }

    public static void setOpen(BeePortBlockEntity entity, boolean open) {
        if (entity == null || entity.f_58857_ == null) {
            return;
        }
        entity.f_58857_.m_46597_(entity.m_58899_(), (BlockState)entity.m_58900_().m_61124_((Property)BeePortBlock.IS_OPEN_TEXTURE, (Comparable)Boolean.valueOf(open)));
        entity.f_58857_.m_247517_(null, entity.m_58899_(), open ? SoundEvents.f_11725_ : SoundEvents.f_11724_, SoundSource.BLOCKS);
    }

    public static boolean isPlayerInventoryFull(Player player) {
        return player.m_150109_().f_35974_.stream().limit(player.m_150109_().m_6643_() - 5).noneMatch(ItemStack::m_41619_);
    }

    public static boolean sendPackageToPlayer(Player player, ItemStack itemStack) {
        if (player == null || itemStack.m_41619_()) {
            return false;
        }
        player.m_5661_((Component)Component.m_264568_((String)"create_mobile_packages.bee_port.send_items", (String)"Send Items to Player"), true);
        if (BeePortBlockEntity.isPlayerInventoryFull(player)) {
            return false;
        }
        player.m_150109_().m_36054_(itemStack);
        return true;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("RoboBeeInventory", (Tag)this.roboBeeInventory.serializeNBT());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("RoboBeeInventory")) {
            this.roboBeeInventory.deserializeNBT(tag.m_128469_("RoboBeeInventory"));
        }
    }

    public void tick() {
        super.tick();
        if (++this.tickCounter % 20 == 0) {
            this.processItems();
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            if (this.getRoboEntity() != null) {
                this.data.m_8050_(0, CMPHelper.calcETA(this.m_58899_().m_252807_(), this.getRoboEntity().getCurrentPos()));
            }
            this.data.m_8050_(1, this.getRoboEntity() != null ? 1 : 0);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.behaviour = new LogisticallyLinkedBehaviour((SmartBlockEntity)this, true);
        behaviours.add((BlockEntityBehaviour)this.behaviour);
        super.addBehaviours(behaviours);
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.f_58857_.m_276867_(this.f_58858_)) {
            this.tryPushingToAdjacentInventories();
        } else {
            this.tryPullingFromAdjacentInventories();
        }
    }

    private void tryPushingToAdjacentInventories() {
        boolean stackToPush = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            stackToPush = true;
        }
        if (!stackToPush) {
            return;
        }
        for (IItemHandler adjacentInventory : this.getAdjacentInventories()) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack remainder;
                ItemStack stackInSlot = this.inventory.extractItem(i, 1, true);
                if (stackInSlot.m_41619_() || !(remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)adjacentInventory, (ItemStack)stackInSlot, (boolean)false)).m_41619_() || this.f_58857_ == null) continue;
                this.inventory.extractItem(i, 1, false);
                this.f_58857_.m_151543_(this.f_58858_);
            }
        }
    }

    private void tryPullingFromAdjacentInventories() {
        VirtualRobo currentEntity = this.getRoboEntity();
        if (this.hasFullInventory(currentEntity != null ? 1 : 0)) {
            return;
        }
        this.getAdjacentInventories().forEach(inventory -> {
            if (inventory == null) {
                return;
            }
            if (this.hasFullInventory(currentEntity != null ? 1 : 0)) {
                return;
            }
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack itemStack = inventory.getStackInSlot(i);
                if (itemStack.m_41619_() || !PackageItem.isPackage((ItemStack)itemStack)) continue;
                this.addItemStack(inventory.extractItem(i, 1, false));
            }
        });
    }

    private List<IItemHandler> getAdjacentInventories() {
        ArrayList<IItemHandler> inventories = new ArrayList<IItemHandler>();
        for (Direction side : Direction.values()) {
            IItemHandler inventory = this.getAdjacentInventory(side);
            if (inventory == null) continue;
            inventories.add(inventory);
        }
        return inventories;
    }

    private IItemHandler getAdjacentInventory(Direction side) {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (blockEntity == null || blockEntity instanceof FrogportBlockEntity) {
            return null;
        }
        return (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_()).orElse(null);
    }

    private void processItems() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.sendItemThisTime-- > 0) {
                return;
            }
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            this.sendItem(itemStack, i);
        }
    }

    private void sendItem(ItemStack itemStack, int slot) {
        BeePortBlockEntity beePortBlockEntity;
        if (this.f_58857_ == null || !PackageItem.isPackage((ItemStack)itemStack)) {
            return;
        }
        String address = PackageItem.getAddress((ItemStack)itemStack);
        for (Player player : this.f_58857_.m_6907_()) {
            if (!CMPHelper.doesAddressMatchPlayer(player, address) || !CMPHelper.isWithinRange(player.m_20183_(), this.m_58899_())) continue;
            this.sendToPlayer(player, itemStack, slot);
            return;
        }
        if (((Boolean)CMPConfigs.server().portToPort.get()).booleanValue() && !PackageItem.matchAddress((String)address, (String)this.addressFilter) && (beePortBlockEntity = CMPHelper.getClosestBeePort(this.f_58857_, address, this.m_58899_(), null, this.getLogisticsNetworkId())) != null && !beePortBlockEntity.isFull()) {
            this.sendDrone(itemStack, slot);
        }
    }

    private void sendToPlayer(Player player, ItemStack itemStack, int slot) {
        if (this.roboBeeInventory.getStackInSlot(0).m_41613_() <= 0) {
            if (this.getRoboEntity() == null && this.f_58857_ != null) {
                BeePortBlockEntity.requestRoboEntity(this.f_58857_, this.m_58899_(), this.getLogisticsNetworkId());
                return;
            }
            return;
        }
        this.sendItemThisTime = 2;
        CreateMobilePackages.LOGGER.info("Sending package to player: {}", (Object)player.m_7755_().getString());
        this.sendDrone(itemStack, slot);
    }

    private void sendDrone(ItemStack itemStack, int slot) {
        if (!this.tryConsumeDrone()) {
            if (this.getRoboEntity() == null && this.f_58857_ != null) {
                BeePortBlockEntity.requestRoboEntity(this.f_58857_, this.m_58899_(), this.getLogisticsNetworkId());
                return;
            }
            return;
        }
        this.sendItemThisTime = 2;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RoboManager.get(serverLevel).newRobo(serverLevel, itemStack, this.m_58899_(), this.getLogisticsNetworkId());
        }
        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
    }

    private void requestRobo(BlockPos tagetPos) {
        if (!this.tryConsumeDrone()) {
            return;
        }
        this.sendItemThisTime = 2;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uuid = RoboManager.get(serverLevel).newRobo(serverLevel, ItemStack.f_41583_, this.m_58899_(), this.getLogisticsNetworkId());
            RoboManager.get(serverLevel).get(uuid).setTarget(new BeePortBlockEntityTarget((BeePortBlockEntity)serverLevel.m_7702_(tagetPos)));
        }
    }

    private boolean tryConsumeDrone() {
        ItemStack usedBee = this.roboBeeInventory.extractItem(0, 1, false);
        return !usedBee.m_41619_();
    }

    public boolean addItemStack(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            this.inventory.insertItem(i, itemStack, false);
            return true;
        }
        return false;
    }

    protected void onOpenChange(boolean open) {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_247517_(null, this.f_58858_, open ? SoundEvents.f_11725_ : SoundEvents.f_11724_, SoundSource.BLOCKS);
        BeePortBlockEntity.setOpen(this, open);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> tracker.add(this));
        }
    }

    private void invalidateTarget() {
        VirtualRobo currentEntity;
        if (this.f_58857_ != null) {
            this.f_58857_.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> tracker.remove(this));
        }
        if ((currentEntity = this.getRoboEntity()) != null) {
            currentEntity.setTargetVelocity(Vec3.f_82478_);
        }
    }

    private void dropBees() {
        ItemStack bees = this.roboBeeInventory.getStackInSlot(0);
        if (bees.m_41613_() > 0 && this.f_58857_ != null) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), bees));
        }
    }

    public void onChunkUnloaded() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.invalidateTarget();
        }
        super.onChunkUnloaded();
    }

    public void remove() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.invalidateTarget();
        }
        super.remove();
    }

    public void destroy() {
        this.dropBees();
        super.destroy();
    }

    public boolean hasFullInventory(int slotsToLeaveEmpty) {
        int emptySlots = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            ++emptySlots;
        }
        return emptySlots <= slotsToLeaveEmpty;
    }

    public boolean hasFullRoboSlot(int leaveEmpty) {
        return this.roboBeeInventory.getStackInSlot(0).m_41613_() >= this.roboBeeInventory.getSlotLimit(0) - leaveEmpty;
    }

    public boolean isFull() {
        return this.isFull(0);
    }

    public boolean isFull(int slotsToLeaveEmpty) {
        return this.hasFullInventory(slotsToLeaveEmpty) || this.hasFullRoboSlot(0);
    }

    public boolean canAcceptEntity(VirtualRobo entity, Boolean hasPackage) {
        if (this.m_58901_()) {
            return false;
        }
        if (entity == null) {
            return hasPackage.booleanValue() ? !this.isFull() : !this.hasFullRoboSlot(0);
        }
        VirtualRobo currentEntity = this.getRoboEntity();
        if (currentEntity != null && currentEntity != entity) {
            return false;
        }
        return hasPackage.booleanValue() ? !this.isFull() : !this.hasFullRoboSlot(0);
    }

    public synchronized boolean trySetEntityOnTravel(VirtualRobo entity, boolean set) {
        if (entity == null) {
            return false;
        }
        VirtualRobo currentEntity = this.getRoboEntity();
        if (currentEntity == null || currentEntity == entity) {
            this.setRoboEntityOnTravel(set ? entity : null);
            return true;
        }
        return false;
    }

    public ItemStackHandler getRoboBeeInventory() {
        return this.roboBeeInventory;
    }

    public void addBeeToRoboBeeInventory(int amount) {
        this.roboBeeInventory.insertItem(0, new ItemStack((ItemLike)CMPItems.ROBO_BEE.get(), amount), false);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return BeePortMenu.create(pContainerId, pPlayerInventory, this);
    }

    public VirtualRobo getRoboEntity() {
        if (this.f_58857_ == null || this.entityOnTravelID == null) {
            return null;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return RoboManager.get((ServerLevel)serverLevel).robos.get(this.entityOnTravelID);
        }
        return null;
    }

    public void setRoboEntityOnTravel(VirtualRobo entity) {
        this.entityOnTravelID = entity == null ? null : entity.getId();
    }

    public ContainerData getData() {
        return this.data;
    }

    public UUID getLogisticsNetworkId() {
        return this.behaviour.freqId;
    }

    public InteractionResult use(Player player) {
        if (!this.behaviour.mayInteractMessage(player)) {
            return InteractionResult.SUCCESS;
        }
        return super.use(player);
    }
}

