/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.compat;

import java.util.Optional;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public enum Mods {
    JEI;

    private final String id = Lang.asId((String)this.name());

    public String id() {
        return this.id;
    }

    public ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.id, (String)path);
    }

    public Block getBlock(String id) {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.rl(id));
    }

    public Item getItem(String id) {
        return (Item)ForgeRegistries.ITEMS.getValue(this.rl(id));
    }

    public boolean contains(ItemLike entry) {
        if (!this.isLoaded()) {
            return false;
        }
        Item asItem = entry.m_5456_();
        return CatnipServices.REGISTRIES.getKeyOrThrow(asItem).m_135827_().equals(this.id);
    }

    public boolean isLoaded() {
        return ModList.get().isLoaded(this.id);
    }

    public <T> Optional<T> runIfInstalled(Supplier<Supplier<T>> toRun) {
        if (this.isLoaded()) {
            return Optional.of(toRun.get().get());
        }
        return Optional.empty();
    }

    public void executeIfInstalled(Supplier<Runnable> toExecute) {
        if (this.isLoaded()) {
            toExecute.get().run();
        }
    }
}

