/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.robo_entity;

import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.CMPHelper;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboBeeState;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class RoboBeeBehaviorController {
    private RoboBeeState state = RoboBeeState.IDLE;
    private boolean init = true;

    public void tick(VirtualRobo robo) {
        switch (this.state) {
            case IDLE: {
                this.handleIdle(robo);
                break;
            }
            case TAKEOFF: {
                this.handleTakeoff(robo);
                break;
            }
            case NAVIGATE_TO_TARGET: {
                this.handleNavigateToTarget(robo);
                break;
            }
            case ALIGN_FOR_DELIVERY: {
                this.handleAlignForDelivery(robo);
                break;
            }
            case LAND: {
                this.handleLand(robo);
                break;
            }
            case DELIVER_PACKAGE: {
                this.handleDeliverPackage(robo);
                break;
            }
            case SHUTDOWN: {
                this.handleShutdown(robo);
            }
        }
    }

    private void handleIdle(VirtualRobo robo) {
        robo.setTargetVelocity(Vec3.f_82478_);
        if (robo.getTarget() != null && robo.getTarget().isValid()) {
            this.setState(RoboBeeState.TAKEOFF);
        }
    }

    private void handleTakeoff(VirtualRobo robo) {
        if (this.init) {
            this.openPort(robo.getStartBeePortBlockEntity(), true);
            this.init = false;
        }
        if (robo.getStartBeePortBlockEntity() == null) {
            this.setState(RoboBeeState.NAVIGATE_TO_TARGET);
            return;
        }
        Vec3 mid = this.getAbove((Object)robo.getStartBeePortBlockEntity(), 1.6);
        Vec3 end = this.getAbove((Object)robo.getStartBeePortBlockEntity(), 2.0);
        double y = robo.getCurrentPos().f_82480_;
        double speed = (double)robo.getSpeed() / 20.0 / 2.0;
        if (y < mid.f_82480_ - speed) {
            this.moveAndScale(robo, mid, speed, 0.0f, 1.0f);
        } else if (y < end.f_82480_ - speed) {
            this.moveTo(robo, end, speed);
            robo.setPackageHeightScale(1.0f);
        } else {
            robo.setPos(end);
            robo.setTargetVelocity(Vec3.f_82478_);
            this.openPort(robo.getStartBeePortBlockEntity(), false);
            this.setState(RoboBeeState.NAVIGATE_TO_TARGET);
        }
    }

    private void handleNavigateToTarget(VirtualRobo robo) {
        if (robo.getTargetPosition() == null) {
            this.setState(RoboBeeState.IDLE);
            return;
        }
        if (robo.getTarget() != null) {
            robo.getTarget().setETA(robo, CMPHelper.calcETA(robo.getTargetPosition(), robo.getCurrentPos()));
        }
        Vec3 target = this.getAbove(robo.getTargetPosition(), 2.0);
        double speed = (double)robo.getSpeed() / 20.0;
        this.moveTo(robo, target, speed);
        if (this.isAtTarget(robo, target, speed)) {
            if (robo.getTarget() != null) {
                robo.getTarget().setETA(robo, 0);
            }
            this.setState(RoboBeeState.ALIGN_FOR_DELIVERY);
            robo.setTargetVelocity(Vec3.f_82478_);
        }
    }

    private void handleAlignForDelivery(VirtualRobo robo) {
        if (this.init) {
            this.openPort(robo.getTarget() != null ? robo.getTarget().asBeePortBlockEntity() : null, true);
            this.init = false;
        }
        if (robo.rotateToSnap() == 0) {
            this.setState(RoboBeeState.LAND);
        }
    }

    private void handleLand(VirtualRobo robo) {
        double speed;
        double y;
        if (robo.getTarget() != null && robo.getTarget().asBeePortBlockEntity() == null) {
            this.setState(RoboBeeState.DELIVER_PACKAGE);
            return;
        }
        Vec3 end = this.getBelow((Object)(robo.getTarget() != null ? robo.getTarget().asBeePortBlockEntity() : null), 0.5);
        Vec3 mid = this.getAbove((Object)robo.getTarget().asBeePortBlockEntity(), 1.0);
        Vec3 start = this.getAbove((Object)robo.getTarget().asBeePortBlockEntity(), 2.0);
        if (this.init) {
            robo.setPos(start);
            robo.setPackageHeightScale(1.0f);
            this.init = false;
        }
        if ((y = robo.getCurrentPos().f_82480_) > mid.f_82480_ + (speed = (double)robo.getSpeed() / 20.0 / 2.0)) {
            this.moveTo(robo, mid, speed);
            robo.setPackageHeightScale(1.0f);
        } else if (y > end.f_82480_ + speed) {
            this.moveAndScale(robo, end, speed, 1.0f, 0.0f);
        } else {
            robo.setPos(end);
            robo.setTargetVelocity(Vec3.f_82478_);
            this.openPort(robo.getTarget().asBeePortBlockEntity(), false);
            this.setState(RoboBeeState.DELIVER_PACKAGE);
        }
    }

    private void handleDeliverPackage(VirtualRobo robo) {
        boolean delivered = false;
        if (robo.getTarget() != null && robo.getTarget().asPlayer() != null && !robo.getItemStack().m_41619_() && (delivered = BeePortBlockEntity.sendPackageToPlayer(robo.getTarget().asPlayer(), robo.getItemStack()))) {
            robo.setItemStack(ItemStack.f_41583_);
            robo.setTarget(null);
        }
        if (robo.getTarget() != null && !delivered && robo.getTarget().asBeePortBlockEntity() != null && !robo.getItemStack().m_41619_() && (delivered = robo.getTarget().asBeePortBlockEntity().addItemStack(robo.getItemStack()))) {
            robo.setItemStack(ItemStack.f_41583_);
            robo.setTarget(null);
        }
        robo.setTargetAddress(PackageItem.getAddress((ItemStack)robo.getItemStack()), true);
        if (robo.getTarget() != null && robo.getTarget().asBeePortBlockEntity() != null && BlockPos.m_274446_((Position)robo.getCurrentPos()).equals((Object)BlockPos.m_274446_((Position)robo.getTargetPosition()))) {
            this.setState(RoboBeeState.SHUTDOWN);
            return;
        }
        this.setState(RoboBeeState.TAKEOFF);
    }

    private void handleShutdown(VirtualRobo robo) {
        BlockEntity blockEntity = robo.getServerLevel().m_7702_(BlockPos.m_274446_((Position)robo.getCurrentPos()));
        if (blockEntity instanceof BeePortBlockEntity) {
            BeePortBlockEntity bpbe = (BeePortBlockEntity)blockEntity;
            bpbe.addBeeToRoboBeeInventory(1);
        }
        robo.setRemoved(robo.getServerLevel());
    }

    private void openPort(BeePortBlockEntity port, boolean open) {
        if (port != null) {
            BeePortBlockEntity.setOpen(port, open);
        }
    }

    private Vec3 getAbove(Object blockEntityOrPos, double y) {
        if (blockEntityOrPos instanceof BlockPos) {
            BlockPos pos = (BlockPos)blockEntityOrPos;
            return pos.m_252807_().m_82520_(0.0, y, 0.0);
        }
        if (blockEntityOrPos instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)blockEntityOrPos;
            return blockEntity.m_58899_().m_252807_().m_82520_(0.0, y, 0.0);
        }
        if (blockEntityOrPos instanceof Vec3) {
            Vec3 vec = (Vec3)blockEntityOrPos;
            return vec.m_82520_(0.0, y, 0.0);
        }
        return Vec3.f_82478_;
    }

    private Vec3 getBelow(Object blockEntityOrPos, double y) {
        if (blockEntityOrPos instanceof BlockPos) {
            BlockPos pos = (BlockPos)blockEntityOrPos;
            return pos.m_252807_().m_82492_(0.0, y, 0.0);
        }
        if (blockEntityOrPos instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)blockEntityOrPos;
            return blockEntity.m_58899_().m_252807_().m_82492_(0.0, y, 0.0);
        }
        if (blockEntityOrPos instanceof Vec3) {
            Vec3 vec = (Vec3)blockEntityOrPos;
            return vec.m_82492_(0.0, y, 0.0);
        }
        return Vec3.f_82478_;
    }

    private void moveTo(VirtualRobo robo, Vec3 target, double speed) {
        Vec3 dir = target.m_82546_(robo.getCurrentPos());
        double dist = dir.m_82553_();
        if (dist < 0.05) {
            robo.setPos(target);
            robo.setTargetVelocity(Vec3.f_82478_);
        } else {
            dir = dir.m_82541_();
            robo.setTargetVelocity(dir.m_82490_(speed));
        }
        robo.setYaw((float)Math.toDegrees(Math.atan2(-dir.f_82479_, dir.f_82481_)));
        robo.setPitch((float)Math.toDegrees(Math.asin(dir.f_82480_)));
    }

    private void moveAndScale(VirtualRobo robo, Vec3 target, double speed, float scaleStart, float scaleEnd) {
        Vec3 dir = target.m_82546_(robo.getCurrentPos());
        double dist = dir.m_82553_();
        double totalDist = 2.0;
        float progress = (float)Math.max(0.0, Math.min(1.0, 1.0 - dist / totalDist));
        float scale = scaleStart + (scaleEnd - scaleStart) * progress;
        robo.setPackageHeightScale(scale);
        this.moveTo(robo, target, speed);
    }

    private boolean isAtTarget(VirtualRobo robo, Vec3 target, double speed) {
        return robo.getCurrentPos().m_82554_(target) < speed;
    }

    public void setState(RoboBeeState newState) {
        this.state = newState;
        this.init = true;
    }
}

