/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.robo_entity;

import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.robo.RoboManager;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RoboEntity
extends Mob {
    private static final EntityDataAccessor<Float> ROT_YAW = SynchedEntityData.m_135353_(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> PACKAGE_HEIGHT_SCALE = SynchedEntityData.m_135353_(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public UUID linkedId;

    public RoboEntity(EntityType<? extends Mob> type, Level level, UUID linkedId) {
        super(type, level);
        this.linkedId = linkedId;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROT_YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        ServerLevel serverLevel;
        super.m_8119_();
        this.m_146922_(((Float)this.f_19804_.m_135370_(ROT_YAW)).floatValue());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && RoboManager.get(serverLevel = (ServerLevel)level).get(this.linkedId) == null) {
            this.m_146870_();
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_20223_(@Nonnull CompoundTag compound) {
        return false;
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
    }

    public boolean m_142391_() {
        return false;
    }

    private void updateNametag(VirtualRobo virtualRobo) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!((Boolean)CMPConfigs.server().displayNametag.get()).booleanValue()) {
            this.m_6593_(null);
            this.m_20340_(false);
        } else if (virtualRobo.getTargetAddress() != null && !virtualRobo.getTargetAddress().isBlank()) {
            this.m_6593_((Component)Component.m_237113_((String)("-> " + virtualRobo.getTargetAddress())));
            this.m_20340_(true);
        } else if (virtualRobo.getTarget() != null && virtualRobo.getTarget().asBeePortBlockEntity() != null) {
            BlockPos pos = virtualRobo.getTarget().asBeePortBlockEntity().m_58899_();
            this.m_6593_((Component)Component.m_237113_((String)("-> [" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + "]")));
            this.m_20340_(true);
        } else {
            this.m_6593_((Component)Component.m_237115_((String)"entity.create_mobile_packages.robo_bee.no_valid_target"));
            this.m_20340_(true);
        }
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM_STACK);
    }

    public float getPackageHeightScale() {
        return ((Float)this.f_19804_.m_135370_(PACKAGE_HEIGHT_SCALE)).floatValue();
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public void syncFromVirtual(VirtualRobo virtualRobo) {
        this.updateNametag(virtualRobo);
        this.m_146884_(virtualRobo.getCurrentPos());
        this.m_146926_(virtualRobo.getPitch());
        this.f_19804_.m_135381_(ROT_YAW, (Object)Float.valueOf(virtualRobo.getYaw()));
        this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)virtualRobo.getItemStack());
        this.f_19804_.m_135381_(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(virtualRobo.getPackageHeightScale()));
    }
}

