/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LogisticallyLinkedItem
extends Item {
    public static final String CMP_LLI_ITEM_TAG = "CMPLLIItemTag";

    public LogisticallyLinkedItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return LogisticallyLinkedItem.isTuned(stack);
    }

    public static boolean isTuned(ItemStack pStack) {
        return pStack.m_41782_() && pStack.m_41783_().m_128441_(CMP_LLI_ITEM_TAG);
    }

    @Nullable
    public static UUID networkFromStack(ItemStack pStack) {
        if (!LogisticallyLinkedItem.isTuned(pStack)) {
            return null;
        }
        CompoundTag tag = pStack.m_41783_().m_128469_(CMP_LLI_ITEM_TAG);
        if (!tag.m_128403_("Freq")) {
            return null;
        }
        return tag.m_128342_("Freq");
    }

    public void m_7373_(@NotNull ItemStack pStack, Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        if (!LogisticallyLinkedItem.isTuned(pStack)) {
            return;
        }
        CompoundTag tag = pStack.m_41783_().m_128469_(CMP_LLI_ITEM_TAG);
        if (!tag.m_128403_("Freq")) {
            return;
        }
        CreateLang.translate((String)"logistically_linked.tooltip", (Object[])new Object[0]).style(ChatFormatting.GOLD).addTo(pTooltip);
        CreateLang.translate((String)"logistically_linked.tooltip_clear", (Object[])new Object[0]).style(ChatFormatting.GRAY).addTo(pTooltip);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        LogisticallyLinkedBehaviour link = (LogisticallyLinkedBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)LogisticallyLinkedBehaviour.TYPE);
        boolean tuned = LogisticallyLinkedItem.isTuned(stack);
        if (link != null) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!link.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            LogisticallyLinkedItem.assignFrequency(stack, player, link.freqId);
            return InteractionResult.SUCCESS;
        }
        InteractionResult useOn = super.m_6225_(pContext);
        if (level.f_46443_ || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        player.m_5661_((Component)(tuned ? CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]) : CreateLang.translateDirect((String)"logistically_linked.new_network_started", (Object[])new Object[0])), true);
        return useOn;
    }

    public static void assignFrequency(ItemStack stack, Player player, UUID frequency) {
        CompoundTag stackTag = stack.m_41784_();
        CompoundTag teTag = new CompoundTag();
        teTag.m_128362_("Freq", frequency);
        stackTag.m_128365_(CMP_LLI_ITEM_TAG, (Tag)teTag);
        player.m_5661_((Component)CreateLang.translateDirect((String)"logistically_linked.tuned", (Object[])new Object[0]), true);
        stack.m_41751_(stackTag);
    }
}

