/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.AdventureUtil;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTicker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;

public class SendPackage
extends SimplePacketBase {
    private final GenericOrder order;
    private final String address;
    private final boolean encodeRequester;

    public SendPackage(GenericOrder order, String address, boolean encodeRequester) {
        this.order = order;
        this.address = address;
        this.encodeRequester = encodeRequester;
    }

    public SendPackage(FriendlyByteBuf buffer) {
        this.address = buffer.m_130277_();
        this.order = GenericOrder.read((FriendlyByteBuf)buffer);
        this.encodeRequester = buffer.readBoolean();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.address);
        this.order.write(buffer);
        buffer.writeBoolean(this.encodeRequester);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || player.m_5833_() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            Level world = player.m_9236_();
            if (!world.m_46749_(player.m_20183_())) {
                return;
            }
            this.applySettings(player);
        });
        return true;
    }

    protected void applySettings(ServerPlayer player) {
        ItemStack pstStack;
        PortableStockTicker pst;
        if (!this.order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_());
            AllAdvancements.STOCK_TICKER.awardTo((Player)player);
            WiFiEffectPacket.send((Level)player.m_9236_(), (BlockPos)player.m_20183_());
        }
        PortableStockTicker portableStockTicker = pst = (pstStack = PortableStockTicker.find(player.m_150109_())) != null ? (PortableStockTicker)pstStack.m_41720_() : null;
        if (pst != null) {
            pst.broadcastPackageRequest(pstStack, LogisticallyLinkedBehaviour.RequestType.PLAYER, this.order, null, this.address, (Player)player);
        }
    }
}

