/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.toast;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import de.theidler.create_mobile_packages.toast.CustomToast;
import de.theidler.create_mobile_packages.toast.ToastOverlayRenderer;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ShowToastOnClientPacket
extends SimplePacketBase {
    private final CustomToast toast;

    public ShowToastOnClientPacket(CustomToast toast) {
        this.toast = toast;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.toast.uuid);
        buffer.m_130070_(Component.Serializer.m_130703_((Component)this.toast.title));
        buffer.m_130070_(Component.Serializer.m_130703_((Component)this.toast.subtitle));
        buffer.writeInt(this.toast.timeout);
        buffer.m_130055_(this.toast.icon);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(this::handleClient);
        context.setPacketHandled(true);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        ToastOverlayRenderer.showToast(this.toast);
    }

    public static ShowToastOnClientPacket read(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        MutableComponent title = Component.Serializer.m_130701_((String)buffer.m_130277_());
        MutableComponent subtitle = Component.Serializer.m_130701_((String)buffer.m_130277_());
        int timeout = buffer.readInt();
        return new ShowToastOnClientPacket(new CustomToast(uuid, (Component)title, (Component)subtitle, buffer.m_130267_(), timeout));
    }
}

