/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.toast;

import de.theidler.create_mobile_packages.toast.CustomToast;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ToastOverlayRenderer {
    private static final List<CustomToast> TOASTS = new ArrayList<CustomToast>();

    public static void showToast(CustomToast toast) {
        for (int i = 0; i < TOASTS.size(); ++i) {
            if (!ToastOverlayRenderer.TOASTS.get((int)i).uuid.equals(toast.uuid)) continue;
            TOASTS.set(i, toast);
            return;
        }
        TOASTS.add(toast);
    }

    public static void removeToast(UUID uuid) {
        TOASTS.removeIf(t -> t.uuid.equals(uuid));
    }

    public static void removeAllToasts() {
        TOASTS.clear();
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Minecraft mc = Minecraft.m_91087_();
        int toastWidth = 160;
        int x = event.getWindow().m_85445_() - toastWidth - 10;
        int y = 10;
        TOASTS.removeIf(toast -> toast.lastUpdate < System.currentTimeMillis() - (long)toast.timeout);
        for (CustomToast toast2 : TOASTS) {
            guiGraphics.m_280509_(x, y, x + toastWidth, y + 32, -1442840576);
            guiGraphics.m_280480_(toast2.icon, x + 6, y + 6);
            guiGraphics.m_280614_(mc.f_91062_, toast2.title, x + 28, y + 6, 0xFFFFFF, false);
            guiGraphics.m_280614_(mc.f_91062_, toast2.subtitle, x + 28, y + 18, 0xAAAAAA, false);
            y += 36;
        }
    }
}

