/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.blocks.drone_port;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.blocks.drone_port.DronePortBlock;
import de.theidler.create_mobile_packages.blocks.drone_port.ModCapabilities;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import de.theidler.create_mobile_packages.index.CMPEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;

public class DronePortBlockEntity
extends PackagePortBlockEntity {
    private int tickCounter = 0;

    public DronePortBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.itemHandler = LazyOptional.of(() -> this.inventory);
    }

    public void tick() {
        super.tick();
        if (++this.tickCounter >= 20) {
            this.tickCounter = 0;
            this.processItems();
        }
    }

    private void processItems() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            this.sendItem(itemStack, i);
        }
    }

    private void sendItem(ItemStack itemStack, int slot) {
        if (this.f_58857_ == null || !PackageItem.isPackage((ItemStack)itemStack)) {
            return;
        }
        String address = PackageItem.getAddress((ItemStack)itemStack);
        for (Player player : this.f_58857_.m_6907_()) {
            if (!player.m_7755_().getString().equals(address)) continue;
            this.sendToPlayer(player, itemStack, slot);
            return;
        }
        this.f_58857_.getCapability(ModCapabilities.DRONE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> {
            List<DronePortBlockEntity> allBEs = tracker.getAll();
            if (allBEs.stream().anyMatch(dpbe -> PackageItem.matchAddress((String)address, (String)dpbe.addressFilter) && dpbe != this) && !PackageItem.matchAddress((String)address, (String)this.addressFilter)) {
                this.sendDrone(itemStack, slot);
            }
        });
    }

    private void sendToPlayer(Player player, ItemStack itemStack, int slot) {
        CreateMobilePackages.LOGGER.info("Sending package to player: {}", (Object)player.m_7755_().getString());
        this.sendDrone(itemStack, slot);
    }

    private void sendDrone(ItemStack itemStack, int slot) {
        RoboBeeEntity drone = new RoboBeeEntity((EntityType<? extends Mob>)((EntityType)CMPEntities.ROBO_BEE_ENTITY.get()), this.f_58857_, itemStack, this.m_58899_());
        this.f_58857_.m_7967_((Entity)drone);
        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
    }

    public static void setOpen(DronePortBlockEntity entity, boolean open) {
        if (entity == null || entity.f_58857_ == null) {
            return;
        }
        entity.f_58857_.m_46597_(entity.m_58899_(), (BlockState)entity.m_58900_().m_61124_((Property)DronePortBlock.IS_OPEN_TEXTURE, (Comparable)Boolean.valueOf(open)));
        entity.f_58857_.m_247517_(null, entity.m_58899_(), open ? SoundEvents.f_11725_ : SoundEvents.f_11724_, SoundSource.BLOCKS);
    }

    public boolean addItemStack(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            this.inventory.insertItem(i, itemStack, false);
            return true;
        }
        return false;
    }

    public static boolean isPlayerInventoryFull(Player player) {
        return player.m_150109_().f_35974_.stream().limit(player.m_150109_().m_6643_() - 5).noneMatch(ItemStack::m_41619_);
    }

    public static boolean sendPackageToPlayer(Player player, ItemStack itemStack) {
        if (player == null || itemStack.m_41619_()) {
            return false;
        }
        player.m_5661_((Component)Component.m_264568_((String)"create_mobile_packages.drone_port.send_items", (String)"Send Items to Player"), true);
        if (DronePortBlockEntity.isPlayerInventoryFull(player)) {
            return false;
        }
        player.m_150109_().m_36054_(itemStack);
        return true;
    }

    protected void onOpenChange(boolean open) {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_247517_(null, this.f_58858_, open ? SoundEvents.f_11725_ : SoundEvents.f_11724_, SoundSource.BLOCKS);
        DronePortBlockEntity.setOpen(this, open);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(ModCapabilities.DRONE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> tracker.add(this));
        }
    }

    public void remove() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(ModCapabilities.DRONE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> tracker.remove(this));
        }
        super.remove();
    }
}

