/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.robo_entity;

import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.blocks.drone_port.DronePortBlockEntity;
import de.theidler.create_mobile_packages.blocks.drone_port.ModCapabilities;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntityState;
import de.theidler.create_mobile_packages.entities.robo_entity.states.AdjustRotationToTarget;
import de.theidler.create_mobile_packages.entities.robo_entity.states.LandingDecendFinishState;
import de.theidler.create_mobile_packages.entities.robo_entity.states.LaunchPrepareState;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;

public class RoboEntity
extends Mob {
    private static final EntityDataAccessor<Float> ROT_YAW = SynchedEntityData.m_135353_(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private RoboEntityState state;
    private Vec3 targetVelocity = Vec3.f_82478_;
    private ItemStack itemStack;
    private Player targetPlayer;
    private DronePortBlockEntity targetBlockEntity;
    private DronePortBlockEntity startDronePortBlockEntity;
    private final List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();
    private PackageEntity packageEntity;
    public boolean doPackageEntity = false;

    public RoboEntity(EntityType<? extends Mob> type, Level level, ItemStack itemStack, BlockPos spawnPos) {
        super(type, level);
        this.setItemStack(itemStack);
        this.createPackageEntity(itemStack);
        this.setTargetFromItemStack(itemStack);
        this.m_146884_(spawnPos.m_252807_().m_82492_(0.0, 0.5, 0.0));
        BlockEntity blockEntity = this.m_9236_().m_7702_(spawnPos);
        if (blockEntity instanceof DronePortBlockEntity) {
            DronePortBlockEntity dpbe;
            this.startDronePortBlockEntity = dpbe = (DronePortBlockEntity)blockEntity;
        }
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(ROT_YAW, (Object)Float.valueOf(this.getSnapAngle(this.getAngleToTarget())));
        }
        if (this.targetBlockEntity != null && ((Object)((Object)this.targetBlockEntity)).equals((Object)this.startDronePortBlockEntity)) {
            this.setState(new LandingDecendFinishState());
        }
        if (this.startDronePortBlockEntity == null) {
            this.setState(new AdjustRotationToTarget());
        }
        this.setState(new LaunchPrepareState());
    }

    public void createPackageEntity(ItemStack itemStack) {
        if (itemStack == null || !PackageItem.isPackage((ItemStack)itemStack)) {
            return;
        }
        this.packageEntity = PackageEntity.fromItemStack((Level)this.m_9236_(), (Vec3)this.m_20182_(), (ItemStack)itemStack);
        this.packageEntity.f_19794_ = true;
        this.packageEntity.m_20242_(true);
        int randomAngle = new Random().nextInt(4) * 90;
        this.packageEntity.m_146922_((float)randomAngle);
        this.packageEntity.m_5616_((float)randomAngle);
        this.packageEntity.m_5618_((float)randomAngle);
        this.m_9236_().m_7967_((Entity)this.packageEntity);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROT_YAW, (Object)Float.valueOf(this.m_146908_()));
    }

    private void setTargetFromItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        if (!PackageItem.isPackage((ItemStack)itemStack)) {
            this.targetBlockEntity = this.getClosestDronePort();
            return;
        }
        this.m_9236_().m_6907_().stream().filter(player -> player.m_7755_().getString().equals(PackageItem.getAddress((ItemStack)itemStack))).findFirst().ifPresentOrElse(player -> {
            this.targetPlayer = player;
        }, () -> {
            this.targetBlockEntity = this.getClosestDronePort(PackageItem.getAddress((ItemStack)itemStack));
        });
    }

    public BlockPos getTargetPosition() {
        if (this.targetPlayer != null) {
            return this.targetPlayer.m_20183_().m_7494_();
        }
        if (this.targetBlockEntity != null) {
            return this.targetBlockEntity.m_58899_().m_7494_().m_7494_();
        }
        this.targetBlockEntity = this.getClosestDronePort();
        return this.targetBlockEntity != null ? this.targetBlockEntity.m_58899_().m_7494_().m_7494_() : null;
    }

    public DronePortBlockEntity getClosestDronePort() {
        return this.getClosestDronePort(null);
    }

    public DronePortBlockEntity getClosestDronePort(String address) {
        DronePortBlockEntity[] closestDronePort = new DronePortBlockEntity[]{null};
        this.m_9236_().getCapability(ModCapabilities.DRONE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> {
            List<DronePortBlockEntity> allBEs = tracker.getAll();
            closestDronePort[0] = allBEs.stream().filter(dpbe -> address == null || PackageItem.matchAddress((String)address, (String)dpbe.addressFilter)).min((dpbe1, dpbe2) -> Double.compare(dpbe1.m_58899_().m_123331_((Vec3i)this.m_20183_()), dpbe2.m_58899_().m_123331_((Vec3i)this.m_20183_()))).orElse(null);
        });
        return closestDronePort[0];
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickEntity(this.m_9236_(), this.m_20183_(), this.m_20185_(), this.m_20189_());
        this.state.tick(this);
        this.m_20256_(this.targetVelocity);
        this.m_6478_(MoverType.SELF, this.targetVelocity);
        float rotYaw = ((Float)this.f_19804_.m_135370_(ROT_YAW)).floatValue();
        this.m_146922_(rotYaw);
        this.m_5616_(rotYaw);
        this.f_20883_ = rotYaw;
        this.updatePackageEntity();
    }

    public void updatePackageEntity() {
        if (this.packageEntity == null) {
            return;
        }
        if (this.doPackageEntity) {
            this.packageEntity.m_6034_(this.m_20185_(), this.m_20186_() - 0.8, this.m_20189_());
        }
        if (this.packageEntity.m_213877_()) {
            this.packageDelivered();
        }
    }

    public void tickEntity(Level world, BlockPos ownerPos, double x, double z) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                if (!(world instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)world;
                if (ownerPos != null) break block3;
            }
            return;
        }
        ChunkPos currentChunk = new ChunkPos((int)x >> 4, (int)z >> 4);
        this.loadedChunks.removeIf(loadedChunk -> {
            boolean isOutsideCurrentArea;
            boolean bl = isOutsideCurrentArea = Math.abs(loadedChunk.f_45578_ - currentChunk.f_45578_) > 1 || Math.abs(loadedChunk.f_45579_ - currentChunk.f_45579_) > 1;
            if (isOutsideCurrentArea) {
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"create_mobile_packages", (BlockPos)ownerPos, (int)loadedChunk.f_45578_, (int)loadedChunk.f_45579_, (boolean)false, (boolean)false);
                return true;
            }
            return false;
        });
        this.forceArea(serverLevel, ownerPos, currentChunk.f_45578_, currentChunk.f_45579_);
    }

    private void forceArea(ServerLevel world, BlockPos owner, int cx, int cz) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                ChunkPos chunkPos = new ChunkPos(cx + dx, cz + dz);
                if (this.loadedChunks.contains(chunkPos)) continue;
                this.loadedChunks.add(chunkPos);
                ForgeChunkManager.forceChunk((ServerLevel)world, (String)"create_mobile_packages", (BlockPos)owner, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
            }
        }
    }

    public void setState(RoboEntityState state) {
        if (state == null) {
            return;
        }
        this.state = state;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.itemStack = itemStack;
    }

    public DronePortBlockEntity getStartDronePortBlockEntity() {
        return this.startDronePortBlockEntity;
    }

    public void setTargetVelocity(Vec3 targetVelocity) {
        if (targetVelocity == null) {
            return;
        }
        this.targetVelocity = targetVelocity;
    }

    public int getSnapAngle(double angle) {
        return (int)Math.abs(Math.round(angle / 90.0) * 90L - 45L);
    }

    public double getAngleToTarget() {
        BlockPos targetPos = this.getTargetPosition();
        return targetPos != null ? Math.atan2((double)targetPos.m_123343_() - this.m_20189_(), (double)targetPos.m_123341_() - this.m_20185_()) : 0.0;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (pReason == Entity.RemovalReason.KILLED && this.packageEntity != null && this.targetPlayer != null) {
            this.targetPlayer.m_5661_((Component)Component.m_237113_((String)("Robo Bee died at X " + Math.round(this.m_20185_()) + " Y " + Math.round(this.m_20186_()) + " Z " + Math.round(this.m_20189_()) + " with a Package for " + this.targetPlayer.m_7755_().getString())), false);
        }
        this.loadedChunks.forEach(chunkPos -> {
            Level patt11568$temp = this.m_9236_();
            if (patt11568$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt11568$temp;
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"create_mobile_packages", (BlockPos)this.m_20183_(), (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)false, (boolean)false);
            }
        });
        super.m_142687_(pReason);
    }

    public Player getTargetPlayer() {
        return this.targetPlayer;
    }

    public DronePortBlockEntity getTargetBlockEntity() {
        return this.targetBlockEntity;
    }

    public void setTargetPlayer(Player targetPlayer) {
        this.targetPlayer = targetPlayer;
    }

    public void setTargetBlockEntity(DronePortBlockEntity targetBlockEntity) {
        this.targetBlockEntity = targetBlockEntity;
    }

    public void updateDisplay(Player player) {
        if (player == null) {
            return;
        }
        player.m_5661_((Component)Component.m_237113_((String)("Package will arrive in " + this.calcETA(player) + "s")), true);
    }

    private int calcETA(Player player) {
        if (player == null) {
            return Integer.MAX_VALUE;
        }
        double distance = player.m_20182_().m_82554_(this.m_20182_());
        return (int)(distance / (double)((Integer)CMPConfigs.server().droneSpeed.get()).intValue()) + 1;
    }

    public void lookAtTarget() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        BlockPos targetPos = this.getTargetPosition();
        if (targetPos != null) {
            Vec3 direction = new Vec3((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_()).m_82546_(this.m_20182_()).m_82541_();
            this.f_19804_.m_135381_(ROT_YAW, (Object)Float.valueOf((float)Math.toDegrees(Math.atan2(direction.f_82481_, direction.f_82479_)) - 90.0f));
        }
    }

    public int rotateLookAtTarget() {
        return this.rotateToAngle((float)this.getAngleToTarget() + 90.0f);
    }

    public int rotateToSnap() {
        return this.rotateToAngle((float)this.getSnapAngle(this.getAngleToTarget()) + 90.0f);
    }

    private int rotateToAngle(float targetYaw) {
        if (this.m_9236_().m_5776_()) {
            return -1;
        }
        float currentYaw = ((Float)this.f_19804_.m_135370_(ROT_YAW)).floatValue();
        float deltaYaw = targetYaw - currentYaw;
        deltaYaw = deltaYaw > 180.0f ? deltaYaw - 360.0f : (deltaYaw < -180.0f ? deltaYaw + 360.0f : deltaYaw);
        float rotationSpeed = ((Integer)CMPConfigs.server().droneRotationSpeed.get()).intValue();
        currentYaw = Math.abs(deltaYaw) > rotationSpeed ? (currentYaw += deltaYaw > 0.0f ? rotationSpeed : -rotationSpeed) : targetYaw;
        this.f_19804_.m_135381_(ROT_YAW, (Object)Float.valueOf(currentYaw));
        return (int)Math.ceil(Math.abs(deltaYaw) / rotationSpeed);
    }

    public boolean hasPackageEntity() {
        return this.packageEntity != null;
    }

    public void removePackageEntity() {
        if (this.packageEntity == null) {
            return;
        }
        this.packageEntity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void setPackageEntity(PackageEntity packageEntity) {
        this.packageEntity = packageEntity;
    }

    public void packageDelivered() {
        this.packageEntity = null;
        this.itemStack = ItemStack.f_41583_;
    }
}

