/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.drone_controller;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import de.theidler.create_mobile_packages.items.drone_controller.ClientScreenStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class BigItemStackListPacket
extends SimplePacketBase {
    private final List<BigItemStack> stacks;

    public BigItemStackListPacket(List<BigItemStack> stacks) {
        this.stacks = stacks;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.stacks.size());
        for (BigItemStack stack : this.stacks) {
            stack.send(buffer);
        }
    }

    public static BigItemStackListPacket read(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<BigItemStack> list = new ArrayList<BigItemStack>();
        for (int i = 0; i < size; ++i) {
            list.add(BigItemStack.receive((FriendlyByteBuf)buffer));
        }
        return new BigItemStackListPacket(list);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(this::handleClient);
        context.setPacketHandled(true);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        ClientScreenStorage.stacks = this.stacks;
    }
}

