/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.drone_controller;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenWithStencils;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import de.theidler.create_mobile_packages.index.CMPPackets;
import de.theidler.create_mobile_packages.items.drone_controller.ClientScreenStorage;
import de.theidler.create_mobile_packages.items.drone_controller.DroneControllerMenu;
import de.theidler.create_mobile_packages.items.drone_controller.SendPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.glfw.GLFW;

public class DroneControllerScreen
extends AbstractSimiContainerScreen<DroneControllerMenu>
implements ScreenWithStencils {
    private static final AllGuiTextures NUMBERS = AllGuiTextures.NUMBERS;
    private static final AllGuiTextures HEADER = AllGuiTextures.STOCK_KEEPER_REQUEST_HEADER;
    private static final AllGuiTextures BODY = AllGuiTextures.STOCK_KEEPER_REQUEST_BODY;
    private static final AllGuiTextures FOOTER = AllGuiTextures.STOCK_KEEPER_REQUEST_FOOTER;
    public LerpedFloat itemScroll;
    final int rows = 9;
    final int cols = 9;
    final int rowHeight = 20;
    final int colWidth = 20;
    final Couple<Integer> noneHovered = Couple.create((Object)-1, (Object)-1);
    int itemsX;
    int itemsY;
    int orderY;
    int windowWidth;
    int windowHeight;
    public EditBox searchBox;
    EditBox addressBox;
    int emptyTicks = 0;
    int successTicks = 0;
    Inventory playerInventory;
    public List<BigItemStack> currentItemSource;
    public List<BigItemStack> displayedItems = new ArrayList<BigItemStack>();
    public List<BigItemStack> itemsToOrder = new ArrayList<BigItemStack>();
    private boolean scrollHandleActive;
    private InventorySummary forcedEntries;
    public boolean refreshSearchNextTick;
    public boolean moveToTopNextTick;

    public DroneControllerScreen(DroneControllerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.itemScroll = LerpedFloat.linear().startWithValue(0.0);
        this.forcedEntries = new InventorySummary();
        this.playerInventory = playerInventory;
    }

    protected void m_181908_() {
        boolean allEmpty;
        super.m_181908_();
        this.addressBox.m_94120_();
        ClientScreenStorage.tick();
        if (this.forcedEntries != null && !this.forcedEntries.isEmpty()) {
            for (BigItemStack stack : this.forcedEntries.getStacks()) {
                int limitedAmount = -stack.count - 1;
                int actualAmount = this.countOf(stack);
                if (actualAmount > limitedAmount) continue;
                this.forcedEntries.erase(stack.stack);
            }
        }
        this.emptyTicks = (allEmpty = this.displayedItems.isEmpty()) ? ++this.emptyTicks : 0;
        this.successTicks = this.successTicks > 0 && this.itemsToOrder.isEmpty() ? ++this.successTicks : 0;
        List<BigItemStack> clientStockSnapshot = ClientScreenStorage.stacks;
        if (clientStockSnapshot != this.currentItemSource) {
            this.currentItemSource = clientStockSnapshot;
            this.refreshSearchResults(false);
        }
        if (this.refreshSearchNextTick) {
            this.refreshSearchNextTick = false;
            this.refreshSearchResults(this.moveToTopNextTick);
        }
        this.itemScroll.tickChaser();
        if (Math.abs(this.itemScroll.getValue() - this.itemScroll.getChaseTarget()) < 0.0625f) {
            this.itemScroll.setValue((double)this.itemScroll.getChaseTarget());
        }
    }

    private void refreshSearchResults(boolean scrollBackUp) {
        String valueWithPrefix;
        if (scrollBackUp) {
            this.itemScroll.startWithValue(0.0);
        }
        if ((valueWithPrefix = this.searchBox.m_94155_()).isBlank() && this.currentItemSource != null) {
            this.displayedItems = new ArrayList<BigItemStack>(this.currentItemSource);
        }
        boolean modSearch = false;
        boolean tagSearch = false;
        modSearch = valueWithPrefix.startsWith("@");
        if (modSearch || (tagSearch = valueWithPrefix.startsWith("#"))) {
            valueWithPrefix = valueWithPrefix.substring(1);
        }
        String value = valueWithPrefix.toLowerCase(Locale.ROOT);
        if (this.currentItemSource == null) {
            return;
        }
        this.displayedItems.clear();
        for (BigItemStack entry : this.currentItemSource) {
            ItemStack stack = entry.stack;
            if (modSearch) {
                if (!ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135827_().contains(value)) continue;
                this.displayedItems.add(entry);
                continue;
            }
            if (tagSearch) {
                if (!stack.m_204131_().anyMatch(key -> key.f_203868_().toString().contains(value))) continue;
                this.displayedItems.add(entry);
                continue;
            }
            if (!stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains(value) && !ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_().contains(value)) continue;
            this.displayedItems.add(entry);
        }
    }

    protected void m_7856_() {
        int appropriateHeight = Minecraft.m_91087_().m_91268_().m_85446_() - 10;
        appropriateHeight -= Mth.m_14100_((int)(appropriateHeight - HEADER.getHeight() - FOOTER.getHeight()), (int)BODY.getHeight());
        appropriateHeight = Math.min(appropriateHeight, HEADER.getHeight() + FOOTER.getHeight() + BODY.getHeight() * 17);
        this.windowWidth = 226;
        this.windowHeight = appropriateHeight;
        this.setWindowSize(226, this.windowHeight);
        super.m_7856_();
        this.m_169413_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.itemsX = x + (this.windowWidth - 180) / 2 + 1;
        this.itemsY = y + 33;
        this.orderY = y + this.windowHeight - 72;
        MutableComponent searchLabel = CreateLang.translateDirect((String)"gui.stock_keeper.search_items", (Object[])new Object[0]);
        this.searchBox = new EditBox((Font)new NoShadowFontWrapper(this.f_96547_), x + 71, y + 22, 100, 9, (Component)searchLabel);
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(4861233);
        this.m_7787_((GuiEventListener)this.searchBox);
        boolean initial = this.addressBox == null;
        String previouslyUsedAddress = initial ? ((DroneControllerMenu)this.f_97732_).droneController.previouslyUsedAddress : this.addressBox.m_94155_();
        this.addressBox = new AddressEditBox((Screen)this, (Font)new NoShadowFontWrapper(this.f_96547_), x + 27, y + this.windowHeight - 36, 92, 10, true);
        this.addressBox.m_94202_(7424576);
        this.addressBox.m_94144_(previouslyUsedAddress);
        this.m_142416_((GuiEventListener)this.addressBox);
        ClientScreenStorage.manualUpdate();
    }

    private Couple<Integer> getHoveredSlot(int x, int y) {
        if (++x < this.itemsX || x >= this.itemsX + 180) {
            return this.noneHovered;
        }
        if (y >= this.orderY && y < this.orderY + 20) {
            int col = (x - this.itemsX) / 20;
            if (this.itemsToOrder.size() <= col || col < 0) {
                return this.noneHovered;
            }
            return Couple.create((Object)-1, (Object)col);
        }
        if (y < this.getGuiTop() + 16 || y > this.getGuiTop() + this.windowHeight - 80) {
            return this.noneHovered;
        }
        if (!this.itemScroll.settled()) {
            return this.noneHovered;
        }
        int localY = y - this.itemsY;
        int categoryIndex = 0;
        if (categoryIndex < this.displayedItems.size()) {
            int col;
            int row = Mth.m_14143_((float)((float)(localY - 4) / 20.0f + this.itemScroll.getChaseTarget()));
            int slot = row * 9 + (col = (x - this.itemsX) / 20);
            if (slot < 0) {
                return this.noneHovered;
            }
            return Couple.create((Object)categoryIndex, (Object)slot);
        }
        return this.noneHovered;
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        boolean allEmpty;
        boolean justSent;
        if (this != this.f_96541_.f_91080_) {
            return;
        }
        PoseStack ms = pGuiGraphics.m_280168_();
        float currentScroll = this.itemScroll.getValue(partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        HEADER.render(pGuiGraphics, x - 15, y);
        y += HEADER.getHeight();
        for (int i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight()) / BODY.getHeight(); ++i) {
            BODY.render(pGuiGraphics, x - 15, y);
            y += BODY.getHeight();
        }
        FOOTER.render(pGuiGraphics, x - 15, y);
        y = this.getGuiTop();
        if (this.addressBox.m_94155_().isBlank() && !this.addressBox.m_93696_()) {
            pGuiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)CreateLang.translate((String)"gui.stock_keeper.package_adress", (Object[])new Object[0]).style(ChatFormatting.ITALIC).component(), this.addressBox.m_252754_(), this.addressBox.m_252907_(), -3294040, false);
        }
        ms.m_85836_();
        ms.m_252880_((float)(x - 50), (float)(y + this.windowHeight - 70), -100.0f);
        ms.m_85841_(3.5f, 3.5f, 3.5f);
        GuiGameElement.of((ItemStack)this.playerInventory.f_35978_.m_21205_()).render(pGuiGraphics);
        ms.m_85849_();
        for (int index = 0; index < 9 && this.itemsToOrder.size() > index; ++index) {
            BigItemStack entry = this.itemsToOrder.get(index);
            boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && (Integer)hoveredSlot.getFirst() == -1;
            ms.m_85836_();
            ms.m_252880_((float)(this.itemsX + index * 20), (float)this.orderY, 0.0f);
            this.renderItemEntry(pGuiGraphics, 1.0f, entry, isStackHovered, true);
            ms.m_85849_();
        }
        if (this.itemsToOrder.size() > 9) {
            pGuiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("[+" + (this.itemsToOrder.size() - 9) + "]")), x + this.windowWidth - 40, this.orderY + 21, 16316652);
        }
        boolean bl = justSent = this.itemsToOrder.isEmpty() && this.successTicks > 0;
        if (this.isConfirmHovered(mouseX, mouseY) && !justSent) {
            AllGuiTextures.STOCK_KEEPER_REQUEST_SEND_HOVER.render(pGuiGraphics, x + this.windowWidth - 81, y + this.windowHeight - 41);
        }
        MutableComponent headerTitle = Component.m_237113_((String)"Drone Controller");
        pGuiGraphics.m_280614_(this.f_96547_, (Component)headerTitle, x + this.windowWidth / 2 - this.f_96547_.m_92852_((FormattedText)headerTitle) / 2, y + 4, 7424576, false);
        MutableComponent component = CreateLang.translate((String)"gui.stock_keeper.send", (Object[])new Object[0]).component();
        if (justSent) {
            float alpha = Mth.m_14036_((float)(((float)this.successTicks + partialTicks - 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            ms.m_85836_();
            ms.m_252880_(alpha * alpha * 50.0f, 0.0f, 0.0f);
            if (this.successTicks < 10) {
                pGuiGraphics.m_280614_(this.f_96547_, (Component)component, x + this.windowWidth - 42 - this.f_96547_.m_92852_((FormattedText)component) / 2, y + this.windowHeight - 35, new Color(0x252525).setAlpha(1.0f - alpha * alpha).getRGB(), false);
            }
            ms.m_85849_();
        } else {
            pGuiGraphics.m_280614_(this.f_96547_, (Component)component, x + this.windowWidth - 42 - this.f_96547_.m_92852_((FormattedText)component) / 2, y + this.windowHeight - 35, 0x252525, false);
        }
        if (justSent) {
            MutableComponent msg = CreateLang.translateDirect((String)"gui.stock_keeper.request_sent", (Object[])new Object[0]);
            float alpha = Mth.m_14036_((float)(((float)this.successTicks + partialTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            int msgX = x + this.windowWidth / 2 - (this.f_96547_.m_92852_((FormattedText)msg) + 10) / 2;
            int msgY = this.orderY + 5;
            if (alpha > 0.0f) {
                int c3 = new Color(9198923).setAlpha(alpha).getRGB();
                int w = this.f_96547_.m_92852_((FormattedText)msg) + 14;
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_L.render(pGuiGraphics, msgX - 8, msgY - 4);
                UIRenderHelper.drawStretched((GuiGraphics)pGuiGraphics, (int)msgX, (int)(msgY - 4), (int)w, (int)16, (int)0, (TextureSheetSegment)AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_M);
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_R.render(pGuiGraphics, msgX + this.f_96547_.m_92852_((FormattedText)msg) + 10, msgY - 4);
                pGuiGraphics.m_280614_(this.f_96547_, (Component)msg, msgX + 5, msgY, c3, false);
            }
        }
        int itemWindowX = x + 21;
        int itemWindowX2 = itemWindowX + 184;
        int itemWindowY = y + 17;
        int itemWindowY2 = y + this.windowHeight - 80;
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.f_96541_.m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        this.startStencil(pGuiGraphics, itemWindowX - 5, itemWindowY, itemWindowX2 - itemWindowX + 10, itemWindowY2 - itemWindowY);
        ms.m_85836_();
        ms.m_252880_(0.0f, -currentScroll * 20.0f, 0.0f);
        for (int sliceY = -2; sliceY < this.getMaxScroll() * 20 + this.windowHeight - 72; sliceY += AllGuiTextures.STOCK_KEEPER_REQUEST_BG.getHeight()) {
            if ((float)sliceY - currentScroll * 20.0f < -20.0f || (float)sliceY - currentScroll * 20.0f > (float)(this.windowHeight - 72)) continue;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BG.render(pGuiGraphics, x + 22, y + sliceY + 18);
        }
        AllGuiTextures.STOCK_KEEPER_REQUEST_SEARCH.render(pGuiGraphics, x + 42, this.searchBox.m_252907_() - 5);
        this.searchBox.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.searchBox.m_94155_().isBlank() && !this.searchBox.m_93696_()) {
            pGuiGraphics.m_280614_(this.f_96547_, this.searchBox.m_6035_(), x + this.windowWidth / 2 - this.f_96547_.m_92852_((FormattedText)this.searchBox.m_6035_()) / 2, this.searchBox.m_252907_(), -11915983, false);
        }
        if (allEmpty = this.displayedItems.isEmpty()) {
            Component msg = this.getTroubleshootingMessage();
            float alpha = Mth.m_14036_((float)(((float)this.emptyTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            if (alpha > 0.0f) {
                List split = this.f_96547_.m_92923_((FormattedText)msg, 160);
                for (int i = 0; i < split.size(); ++i) {
                    FormattedCharSequence sequence = (FormattedCharSequence)split.get(i);
                    int lineWidth = this.f_96547_.m_92724_(sequence);
                    int n = x + this.windowWidth / 2 - lineWidth / 2 + 1;
                    Objects.requireNonNull(this.f_96547_);
                    pGuiGraphics.m_280649_(this.f_96547_, sequence, n, this.itemsY + 20 + 1 + i * (9 + 1), new Color(4861233).setAlpha(alpha).getRGB(), false);
                    int n2 = x + this.windowWidth / 2 - lineWidth / 2;
                    Objects.requireNonNull(this.f_96547_);
                    pGuiGraphics.m_280649_(this.f_96547_, sequence, n2, this.itemsY + 20 + i * (9 + 1), new Color(16316652).setAlpha(alpha).getRGB(), false);
                }
            }
        }
        List<BigItemStack> category = this.displayedItems;
        int categoryY = 0;
        for (int index = 0; index < category.size(); ++index) {
            int pY = this.itemsY + categoryY + 4 + index / 9 * 20;
            float cullY = (float)pY - currentScroll * 20.0f;
            if (cullY < (float)y) continue;
            if (cullY > (float)(y + this.windowHeight - 72)) break;
            boolean isStackHovered = index == (Integer)hoveredSlot.getSecond();
            BigItemStack entry = category.get(index);
            ms.m_85836_();
            ms.m_252880_((float)(this.itemsX + index % 9 * 20), (float)pY, 0.0f);
            this.renderItemEntry(pGuiGraphics, 1.0f, entry, isStackHovered, false);
            ms.m_85849_();
        }
        ms.m_85849_();
        this.endStencil();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.m_14143_((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        if (barSize < windowH - 2) {
            int barX = this.itemsX + 180;
            int barY = y + 15;
            ms.m_85836_();
            ms.m_252880_(0.0f, currentScroll * 20.0f / (float)totalH * (float)(windowH - 2), 0.0f);
            AllGuiTextures pad = AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_PAD;
            pGuiGraphics.m_280411_(pad.location, barX, barY, pad.getWidth(), barSize, (float)pad.getStartX(), (float)pad.getStartY(), pad.getWidth(), pad.getHeight(), 256, 256);
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_TOP.render(pGuiGraphics, barX, barY);
            if (barSize > 16) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_MID.render(pGuiGraphics, barX, barY + barSize / 2 - 4);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_BOT.render(pGuiGraphics, barX, barY + barSize - 5);
            ms.m_85849_();
        }
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.f_96541_.m_91385_());
    }

    private int getMaxScroll() {
        int visibleHeight = this.windowHeight - 84;
        int totalRows = 2;
        List<BigItemStack> list = this.displayedItems;
        ++totalRows;
        return Math.max(0, ((totalRows += (int)Math.ceil((float)list.size() / 9.0f)) * 20 - visibleHeight + 50) / 20);
    }

    private void renderItemEntry(GuiGraphics graphics, float scale, BigItemStack entry, boolean isStackHovered, boolean isRenderingOrders) {
        int customCount = entry.count;
        if (!isRenderingOrders) {
            BigItemStack order = this.getOrderForItem(entry.stack);
            if (entry.count < 1000000000) {
                int forcedCount = this.forcedEntries.getCountOf(entry.stack);
                if (forcedCount != 0) {
                    customCount = Math.min(customCount, -forcedCount - 1);
                }
                if (order != null) {
                    customCount -= order.count;
                }
                customCount = Math.max(0, customCount);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SLOT.render(graphics, 0, 0);
        }
        boolean craftable = entry instanceof CraftableBigItemStack;
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        float scaleFromHover = 1.0f;
        if (isStackHovered) {
            scaleFromHover += 0.075f;
        }
        ms.m_85837_(1.0, 1.0, 0.0);
        ms.m_85837_(9.0, 9.0, 0.0);
        ms.m_85841_(scale, scale, scale);
        ms.m_85841_(scaleFromHover, scaleFromHover, scaleFromHover);
        ms.m_85837_(-9.0, -9.0, 0.0);
        if (customCount != 0 || craftable) {
            GuiGameElement.of((ItemStack)entry.stack).render(graphics);
        }
        ms.m_85849_();
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 190.0f);
        if (customCount != 0 || craftable) {
            graphics.m_280302_(this.f_96547_, entry.stack, 1, 1, "");
        }
        ms.m_252880_(0.0f, 0.0f, 10.0f);
        if (customCount > 1 || craftable) {
            this.drawItemCount(graphics, entry.count, customCount);
        }
        ms.m_85849_();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawItemCount(GuiGraphics graphics, int count, int customCount) {
        Object text;
        count = customCount;
        Object object = count >= 1000000 ? count / 1000000 + "m" : (count >= 10000 ? count / 1000 + "k" : (count >= 1000 ? (float)(count * 10 / 1000) / 10.0f + "k" : (text = count >= 100 ? "" + count : " " + count)));
        if (count >= 1000000000) {
            text = "+";
        }
        if (((String)text).isBlank()) {
            return;
        }
        int x = (int)Math.floor((double)(-((String)text).length()) * 2.5);
        char[] cArray = ((String)text).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            block11: {
                if (n2 >= n) {
                    return;
                }
                char c = cArray[n2];
                int index = c - 48;
                int xOffset = index * 6;
                int spriteWidth = NUMBERS.getWidth();
                switch (c) {
                    case ' ': {
                        x += 4;
                        break block11;
                    }
                    case '.': {
                        spriteWidth = 3;
                        xOffset = 60;
                        break;
                    }
                    case 'k': {
                        xOffset = 64;
                        break;
                    }
                    case 'm': {
                        spriteWidth = 7;
                        xOffset = 70;
                        break;
                    }
                    case '+': {
                        spriteWidth = 9;
                        xOffset = 84;
                    }
                }
                RenderSystem.enableBlend();
                graphics.m_280398_(DroneControllerScreen.NUMBERS.location, 14 + x, 10, 0, (float)(NUMBERS.getStartX() + xOffset), (float)NUMBERS.getStartY(), spriteWidth, NUMBERS.getHeight(), 256, 256);
                x += spriteWidth - 1;
            }
            ++n2;
        }
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot != this.noneHovered) {
            int slot = (Integer)hoveredSlot.getSecond();
            boolean orderHovered = (Integer)hoveredSlot.getFirst() == -1;
            try {
                BigItemStack entry = orderHovered ? this.itemsToOrder.get(slot) : this.displayedItems.get(slot);
                graphics.m_280153_(this.f_96547_, entry.stack, mouseX, mouseY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.addressBox.m_94155_().isBlank() && !this.addressBox.m_93696_() && this.addressBox.m_274382_()) {
            graphics.m_280666_(this.f_96547_, List.of(CreateLang.translate((String)"gui.factory_panel.restocker_address", (Object[])new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
    }

    @Nullable
    private BigItemStack getOrderForItem(ItemStack stack) {
        for (BigItemStack entry : this.itemsToOrder) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)entry.stack)) continue;
            return entry;
        }
        return null;
    }

    private boolean isConfirmHovered(int mouseX, int mouseY) {
        int confirmX = this.getGuiLeft() + 143;
        int confirmY = this.getGuiTop() + this.windowHeight - 39;
        int confirmW = 78;
        int confirmH = 18;
        if (mouseX < confirmX || mouseX >= confirmX + confirmW) {
            return false;
        }
        return mouseY >= confirmY && mouseY < confirmY + confirmH;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean rmb;
        boolean lmb = pButton == 0;
        boolean bl = rmb = pButton == 1;
        if (rmb && this.searchBox.m_5953_(pMouseX, pMouseY)) {
            this.searchBox.m_94144_("");
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.searchBox.m_93692_(true);
            return true;
        }
        if (this.addressBox.m_93696_()) {
            if (this.addressBox.m_274382_()) {
                return this.addressBox.m_6375_(pMouseX, pMouseY, pButton);
            }
            this.addressBox.m_93692_(false);
        }
        if (this.searchBox.m_93696_()) {
            if (this.searchBox.m_274382_()) {
                return this.searchBox.m_6375_(pMouseX, pMouseY, pButton);
            }
            this.searchBox.m_93692_(false);
        }
        int barX = this.itemsX + 180 - 1;
        if (this.getMaxScroll() > 0 && lmb && pMouseX > (double)barX && pMouseX <= (double)(barX + 8) && pMouseY > (double)(this.getGuiTop() + 15) && pMouseY < (double)(this.getGuiTop() + this.windowHeight - 82)) {
            this.scrollHandleActive = true;
            if (this.f_96541_.m_91302_()) {
                GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212994);
            }
            return true;
        }
        if (lmb && this.isConfirmHovered((int)pMouseX, (int)pMouseY)) {
            this.sendIt();
            this.playUiSound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f, 1.0f);
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (hoveredSlot == this.noneHovered || !lmb && !rmb) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        try {
            boolean orderClicked;
            boolean bl2 = orderClicked = (Integer)hoveredSlot.getFirst() == -1;
            if ((Integer)hoveredSlot.getSecond() > this.displayedItems.size()) {
                return false;
            }
            BigItemStack entry = orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getSecond());
            ItemStack itemStack = entry.stack;
            int transfer = DroneControllerScreen.m_96638_() ? itemStack.m_41741_() : (DroneControllerScreen.m_96637_() ? 10 : 1);
            BigItemStack existingOrder = this.getOrderForItem(entry.stack);
            if (existingOrder == null) {
                if (this.itemsToOrder.size() >= 9 || rmb) {
                    return true;
                }
                existingOrder = new BigItemStack(itemStack.m_255036_(1), 0);
                this.itemsToOrder.add(existingOrder);
                this.playUiSound(SoundEvents.f_12591_, 0.75f, 1.2f);
                this.playUiSound(SoundEvents.f_244286_, 0.75f, 0.8f);
            }
            int current = existingOrder.count;
            if (rmb || orderClicked) {
                existingOrder.count = current - transfer;
                if (existingOrder.count <= 0) {
                    this.itemsToOrder.remove(existingOrder);
                    this.playUiSound(SoundEvents.f_12591_, 0.75f, 1.8f);
                    this.playUiSound(SoundEvents.f_244286_, 0.75f, 1.8f);
                }
                return true;
            }
            existingOrder.count = current + Math.min(transfer, entry.count - current);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.scrollHandleActive) {
            this.scrollHandleActive = false;
            if (this.f_96541_.m_91302_()) {
                GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
            }
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean noHover;
        if (this.addressBox.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        boolean bl = noHover = hoveredSlot == this.noneHovered;
        if (noHover || (Integer)hoveredSlot.getFirst() >= 0 && !DroneControllerScreen.m_96638_() && this.getMaxScroll() != 0) {
            int maxScroll = this.getMaxScroll();
            int direction = (int)(Math.ceil(Math.abs(delta)) * -Math.signum(delta));
            float newTarget = Mth.m_14045_((int)Math.round(this.itemScroll.getChaseTarget() + (float)direction), (int)0, (int)maxScroll);
            this.itemScroll.chase((double)newTarget, 0.5, LerpedFloat.Chaser.EXP);
            return true;
        }
        try {
            BigItemStack existingOrder;
            boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
            BigItemStack entry = orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getSecond());
            boolean remove = delta < 0.0;
            int transfer = Mth.m_14165_((double)Math.abs(delta)) * (DroneControllerScreen.m_96637_() ? 10 : 1);
            BigItemStack bigItemStack = existingOrder = orderClicked ? entry : this.getOrderForItem(entry.stack);
            if (existingOrder == null) {
                if (this.itemsToOrder.size() >= 9 || remove) {
                    return true;
                }
                existingOrder = new BigItemStack(entry.stack.m_255036_(1), 0);
                this.itemsToOrder.add(existingOrder);
                this.playUiSound(SoundEvents.f_12591_, 0.75f, 1.2f);
                this.playUiSound(SoundEvents.f_244286_, 0.75f, 0.8f);
            }
            int current = existingOrder.count;
            if (remove) {
                existingOrder.count = current - transfer;
                if (existingOrder.count <= 0) {
                    this.itemsToOrder.remove(existingOrder);
                    this.playUiSound(SoundEvents.f_12591_, 0.75f, 1.8f);
                    this.playUiSound(SoundEvents.f_244286_, 0.75f, 1.8f);
                } else if (existingOrder.count != current) {
                    this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
                }
                return true;
            }
            existingOrder.count = current + Math.min(transfer, this.countOf(entry) - current);
            if (existingOrder.count != current && current != 0) {
                this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
            }
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private int countOf(BigItemStack entry) {
        for (BigItemStack bigItemStack : this.displayedItems) {
            if (bigItemStack.stack.m_41720_() != entry.stack.m_41720_()) continue;
            return bigItemStack.count;
        }
        return 0;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0 || !this.scrollHandleActive) {
            return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        Window window = this.f_96541_.m_91268_();
        double scaleX = (double)window.m_85445_() / (double)window.m_85443_();
        double scaleY = (double)window.m_85446_() / (double)window.m_85444_();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.m_14143_((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        int minY = this.getGuiTop() + 15 + barSize / 2;
        int maxY = this.getGuiTop() + 15 + windowH - barSize / 2;
        if (barSize >= windowH - 2) {
            return true;
        }
        int barX = this.itemsX + 180;
        double target = (pMouseY - (double)this.getGuiTop() - 15.0 - (double)barSize / 2.0) * (double)totalH / (double)(windowH - 2) / 20.0;
        this.itemScroll.chase(Mth.m_14008_((double)target, (double)0.0, (double)this.getMaxScroll()), 0.8, LerpedFloat.Chaser.EXP);
        if (this.f_96541_.m_91302_()) {
            double forceX = (double)(barX + 2) / scaleX;
            double forceY = Mth.m_14008_((double)pMouseY, (double)minY, (double)maxY) / scaleY;
            GLFW.glfwSetCursorPos((long)window.m_85439_(), (double)forceX, (double)forceY);
        }
        return true;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.addressBox.m_93696_() && this.addressBox.m_5534_(pCodePoint, pModifiers)) {
            return true;
        }
        String s = this.searchBox.m_94155_();
        if (!this.searchBox.m_5534_(pCodePoint, pModifiers)) {
            return false;
        }
        if (!Objects.equals(s, this.searchBox.m_94155_())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
        }
        return true;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 257 && this.searchBox.m_93696_()) {
            this.searchBox.m_93692_(false);
            return true;
        }
        if (pKeyCode == 257 && DroneControllerScreen.m_96638_()) {
            this.sendIt();
            return true;
        }
        if (this.addressBox.m_93696_() && this.addressBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        String s = this.searchBox.m_94155_();
        if (!this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return this.searchBox.m_93696_() && this.searchBox.m_94213_() && pKeyCode != 256 || super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        if (!Objects.equals(s, this.searchBox.m_94155_())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
        }
        return true;
    }

    private void sendIt() {
        if (this.itemsToOrder.isEmpty()) {
            return;
        }
        CMPPackets.getChannel().sendToServer((Object)new SendPackage(new PackageOrder(this.itemsToOrder), this.addressBox.m_94155_(), false, PackageOrder.empty()));
        ((DroneControllerMenu)this.f_97732_).droneController.previouslyUsedAddress = this.addressBox.m_94155_();
        this.itemsToOrder = new ArrayList<BigItemStack>();
        this.successTicks = 1;
        ClientScreenStorage.manualUpdate();
    }

    private Component getTroubleshootingMessage() {
        if (this.currentItemSource == null) {
            return CreateLang.translate((String)"gui.stock_keeper.checking_stocks", (Object[])new Object[0]).component();
        }
        if (this.currentItemSource.isEmpty()) {
            return CreateLang.translate((String)"gui.stock_keeper.inventories_empty", (Object[])new Object[0]).component();
        }
        return CreateLang.translate((String)"gui.stock_keeper.no_search_results", (Object[])new Object[0]).component();
    }
}

