/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.drone_controller;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.AdventureUtil;
import de.theidler.create_mobile_packages.items.drone_controller.DroneController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SendPackage
extends SimplePacketBase {
    private final PackageOrder order;
    private final String address;
    private final boolean encodeRequester;
    private final PackageOrder craftingRequest;

    public SendPackage(PackageOrder order, String address, boolean encodeRequester, PackageOrder craftingRequest) {
        this.order = order;
        this.address = address;
        this.encodeRequester = encodeRequester;
        this.craftingRequest = craftingRequest;
    }

    public SendPackage(FriendlyByteBuf buffer) {
        this.address = buffer.m_130277_();
        this.order = PackageOrder.read((FriendlyByteBuf)buffer);
        this.encodeRequester = buffer.readBoolean();
        this.craftingRequest = PackageOrder.read((FriendlyByteBuf)buffer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.address);
        this.order.write(buffer);
        buffer.writeBoolean(this.encodeRequester);
        this.craftingRequest.write(buffer);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || player.m_5833_() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            Level world = player.m_9236_();
            if (!world.m_46749_(player.m_20183_())) {
                return;
            }
            this.applySettings(player);
        });
        return true;
    }

    protected void applySettings(ServerPlayer player) {
        if (!this.order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_());
            AllAdvancements.STOCK_TICKER.awardTo((Player)player);
            WiFiEffectPacket.send((Level)player.m_9236_(), (BlockPos)player.m_20183_());
        }
        if (player.m_21205_().m_41720_() instanceof DroneController) {
            ((DroneController)player.m_21205_().m_41720_()).broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, this.order, null, this.address);
        }
    }
}

